/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.headless;

import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.configuration.bootstrap.ui.ErrorTextUI;
import de.rcenvironment.core.configuration.ui.LanternaUtils;
import de.rcenvironment.core.embedded.ssh.api.SshAccountConfigurationService;
import de.rcenvironment.core.mail.SMTPServerConfigurationService;
import de.rcenvironment.core.start.common.Instance;
import de.rcenvironment.core.start.common.InstanceRunner;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.headless.textui.ConfigurationTextUI;
import de.rcenvironment.core.start.headless.textui.QuestionDialogTextUI;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.equinox.app.IApplication;

public final class HeadlessInstanceRunner
extends InstanceRunner {
    private AtomicInteger exitCode = new AtomicInteger(IApplication.EXIT_OK);

    public int performRun() throws InterruptedException {
        String[] execCommandTokens = CommandLineArguments.getExecCommandTokens();
        Future commandExecutionFuture = null;
        if (execCommandTokens != null) {
            boolean isBatchMode = CommandLineArguments.isBatchModeRequested();
            String cliToken = isBatchMode ? "--batch" : "--exec";
            commandExecutionFuture = this.initiateAsyncCommandExecution(execCommandTokens, "execution of " + cliToken + " commands", isBatchMode);
        }
        if (CommandLineArguments.isConfigurationShellRequested()) {
            this.log.debug((Object)"Running text-mode configuration UI");
            ServiceRegistryAccess serviceAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
            SshAccountConfigurationService sshConfigurationService = (SshAccountConfigurationService)serviceAccess.getService(SshAccountConfigurationService.class);
            SMTPServerConfigurationService smtpServerConfigurationService = (SMTPServerConfigurationService)serviceAccess.getService(SMTPServerConfigurationService.class);
            new ConfigurationTextUI(sshConfigurationService, smtpServerConfigurationService).run();
            this.log.debug((Object)"Shutting down after text-mode configuration UI has terminated");
        } else if (CommandLineArguments.isBatchModeRequested()) {
            if (commandExecutionFuture != null) {
                try {
                    commandExecutionFuture.get();
                }
                catch (ExecutionException e) {
                    this.log.error((Object)"Uncaught error in batch command execution", (Throwable)e);
                }
            } else {
                this.log.error((Object)"Failed to initialize batch command execution");
            }
        } else {
            Instance.awaitShutdown();
        }
        return this.exitCode.get();
    }

    public void onShutdownRequired(List<InstanceValidationResult> validationResults) {
        InstanceValidationResult result = validationResults.get(0);
        String errorMessage = String.format("Instance validation failure: %s%n%nRCE will be shut down.", result.getGuiDialogMessage());
        new ErrorTextUI(LanternaUtils.applyWordWrapping((String)errorMessage)).run();
    }

    public boolean onRecoveryRequired(List<InstanceValidationResult> validationResults) {
        for (InstanceValidationResult result : validationResults) {
            boolean attemptRecovery;
            String dialogQuestion = result.getGuiDialogMessage();
            try {
                attemptRecovery = new QuestionDialogTextUI("Instance validation failure", LanternaUtils.applyWordWrapping((String)dialogQuestion)).run();
            }
            catch (RuntimeException t) {
                StringBuilder logMessageBuilder = new StringBuilder("A recoverable instance validation failure occured. The user could not be queried whether or not recovery should proceed due to the exception below. Aborting startup.");
                Optional userHint = result.getUserHint();
                if (userHint.isPresent()) {
                    logMessageBuilder.append('\n');
                    logMessageBuilder.append((String)userHint.get());
                }
                this.log.error((Object)logMessageBuilder.toString(), (Throwable)t);
                return false;
            }
            if (attemptRecovery) {
                try {
                    result.getCallback().onConfirmation();
                    continue;
                }
                catch (InstanceValidationResult.CallbackException e) {
                    new ErrorTextUI(String.format("Error during recovery from instance validation error: %s. See log for more details.", e.getMessage()));
                    this.log.error((Object)"Exception thrown during recovery from instance validation failure", (Throwable)e);
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public boolean onConfirmationRequired(List<InstanceValidationResult> validationResults) {
        for (InstanceValidationResult result : validationResults) {
            if (new QuestionDialogTextUI("Instance validation failure", String.valueOf(result.getGuiDialogMessage()) + "\n\nDo you like to proceed anyway?").run()) continue;
            return false;
        }
        return true;
    }

    public void triggerRestart() {
        this.setExitCode(IApplication.EXIT_RESTART);
        Instance.shutdown();
    }

    private void setExitCode(int newExitCode) {
        this.exitCode.set(newExitCode);
    }
}

