/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.common;

import de.rcenvironment.core.start.common.InstanceRunner;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Instance {
    private static Boolean isHeadless;
    private static Boolean shutdownRequested;
    private static CountDownLatch shutdownLatch;
    private static InstanceRunner instanceRunner;

    static {
        shutdownRequested = false;
        shutdownLatch = new CountDownLatch(1);
    }

    protected Instance() {
    }

    public static boolean isHeadless() throws IllegalStateException {
        if (isHeadless == null) {
            throw new IllegalStateException("Internal error: Headless mode not yet set");
        }
        return isHeadless;
    }

    public static boolean isShutdownRequested() {
        return shutdownRequested;
    }

    public static void setHeadless(boolean isHeadlessOn) throws IllegalStateException {
        if (isHeadless != null && isHeadlessOn != isHeadless) {
            throw new IllegalStateException(StringUtils.format((String)"Tried to set the headless mode of this instance to '%s', but it was already set to '%s'", (Object[])new Object[]{isHeadlessOn, isHeadless}));
        }
        isHeadless = isHeadlessOn;
    }

    public static synchronized void setInstanceRunner(InstanceRunner runner) throws IllegalStateException {
        if (instanceRunner != null) {
            throw new IllegalStateException(StringUtils.format((String)"Tried to set instance runner '%s' when one is already configured: '%s'", (Object[])new Object[]{runner, instanceRunner}));
        }
        instanceRunner = runner;
    }

    public static synchronized InstanceRunner getInstanceRunner() throws IllegalStateException {
        if (instanceRunner == null) {
            throw new IllegalStateException("Internal error: No instance runner configured");
        }
        return instanceRunner;
    }

    public static void awaitShutdown() throws InterruptedException {
        shutdownLatch.await();
    }

    public static void awaitShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        Instance.getInstanceRunner().beforeAwaitShutdown();
        shutdownLatch.await(timeout, unit);
    }

    public static void shutdown() {
        shutdownLatch.countDown();
        if (instanceRunner == null) {
            shutdownRequested = true;
        } else {
            Instance.getInstanceRunner().triggerShutdown();
        }
    }

    public static boolean isShutdown() {
        return shutdownLatch.getCount() == 0L;
    }

    protected static void resetShutdown() {
        shutdownLatch = new CountDownLatch(1);
    }

    public static void restart() {
        Instance.getInstanceRunner().triggerRestart();
    }
}

