/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.api;

public class OperatingSystemException
extends Exception {
    private static final long serialVersionUID = -3136170788474556276L;
    private final ErrorType errorType;

    public OperatingSystemException(String message) {
        super(message);
        this.errorType = null;
    }

    public OperatingSystemException(ErrorType errorType) {
        super(errorType.getMessage());
        this.errorType = errorType;
    }

    public OperatingSystemException(ErrorType errorType, String message) {
        super(String.valueOf(errorType.getMessage()) + ": " + message);
        this.errorType = errorType;
    }

    public ErrorType getErrorType() {
        if (this.errorType == null) {
            throw new IllegalStateException("Error type requested, but none is available; was this method called on a different instance than the one throwing the exception?");
        }
        return this.errorType;
    }

    public static enum ErrorType {
        NO_SUCH_PROCESS("No such process"),
        FAILED_TO_GATHER_CPU_PROCESS_USAGE("Failed to get CPU usage"),
        FAILED_TO_GATHER_IDLE("Failed to get idle"),
        FAILED_TO_GATHER_TOTAL_CPU_USAGE("Failed to get total CPU usage"),
        FAILED_TO_GATHER_RAM_PROCESS_USAGE("Failed to get RAM usage"),
        FAILED_TO_GATHER_TOTAL_RAM_USAGE("Failed to get total RAM usage"),
        FAILED_TO_GATHER_TOTAL_RAM("Failed to get total RAM"),
        FAILED_TO_GATHER_TOTAL_RAM_PERCENTAGE("Failed to get total RAM percentage"),
        FAILED_TO_GATHER_RAM_PROCESS_PERCENTAGE("Failed to get RAM percentage"),
        ACCESS_DENIED("Access is denied"),
        FAILED_TO_GET_PROCESS_LIST("Failed to get process list"),
        FAILED_TO_GET_CPU_LIST("Failed to get cpu core count"),
        FAILED_TO_GET_PROCESS_STATE("Failed to get process state"),
        FAILED_TO_GET_CHILD_PROCESS_LIST("Failed to get child process list"),
        FAILED_TO_KILL_PROCESS("Failed to kill process"),
        FAILED_TO_GET_FILE_SYSTEM("Failed to get file system information"),
        FAILED_TO_GET_FILE_SYSTEM_USAGE("Failed to get file system usage");

        private final String message;

        private ErrorType(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.message;
        }
    }
}

