/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement;

import com.jcraft.jsch.JSchException;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.instancemanagement.InstanceConfigurationOperationSequence;
import de.rcenvironment.core.instancemanagement.InstanceManagementService;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationException;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstanceManagementCommandPlugin
implements CommandPlugin {
    private static final int SECONDS_TO_MILLISECONDS = 1000;
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final String ROOT_COMMAND = "im";
    private static final String ZERO_STRING = "0";
    private static final String COMMA_STRING = ",";
    private static final String ALL_MARKER_TOKEN = "all";
    private static final String IF_MISSING = "--if-missing";
    private static final String FORCE_DOWNLOAD = "--force-download";
    private static final String FORCE_REINSTALL = "--force-reinstall";
    private static final String TIMEOUT = "--timeout";
    private static final String OPTION_START_WITH_GUI = "--gui";
    private static final String COMMAND_ARGUMENTS = "--command-arguments";
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final String TIMEOUT_DESCRIPTION = "--timeout - specifies the maximum length of time this command is allowed to run (in seconds) - default = 60s";
    private InstanceManagementService instanceManagementService;
    private ThreadLocal<CommandContext> currentContext = new ThreadLocal();

    public void bindInstanceManagementService(InstanceManagementService newInstance) {
        this.instanceManagementService = newInstance;
    }

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription("im install", "[<--if-missing|--force-download|--force-reinstall>] [<mayor version>]/<url version id/part> <installation id>", true, "downloads and installs a new RCE installation", new String[]{"--if-missing - download and install if and only if an installation with the same version is not present", "--force-download - forces the download and reinstallation of the installation files even if they are present in the current cache", "--force-reinstall - forces reinstallation even if the same version is already installed", TIMEOUT_DESCRIPTION}));
        contributions.add(new CommandDescription("im reinstall", "[<--force-download|--force-reinstall>] [<mayor version>]/<url version id/part> <installation id>", true, "stops all instances running the given installation id, downloads and installs the new RCE installation, and starts the instances again with the new installation", new String[]{"--force-download - forces the download and reinstallation of the installation files even if they are present in the current cache", "--force-reinstall - forces reinstallation even if the same version is already installed", TIMEOUT_DESCRIPTION}));
        contributions.add(new CommandDescription("im configure", "<instance id(s)> <command> [<parameters>] [<command> [<parameters>]] [...]", true, "configures the configuration.json file of the specified RCE instance(s)", new String[]{"Available commands:", "--set-rce-version <version> - sets the rce version of the instances. (Does not work on existing instances.)", "--reset - resets the instance to an empty configuration", "--apply-template <template id> - applies (i.e. copies) the given template as the new configuration", "--set-name <name> - sets the name of the instance", "--set-comment <comment> - sets a general comment", "--set-workflow-host-option [<true/false>] - sets or clears the workflow host flag", "--set-relay-option [<true/false>] - sets or clears the relay flag", "--set-custom-node-id <node id> - adds an override value for the node's network id; use with caution!", "--set-tempdir-path <path> - sets the root path for RCE's temporary files directory", "--add-server-port <id> <ip> <port> - adds a new server port and sets the ip and port number to bind to", "--add-connection <id> <host> <port> <true/false> - adds new connection to the given ip/hostname and port, and whether it should auto-connect", "--remove-connection <id> removes a connection", "--set-ip-filter-option [<true/false>] - enables or disables the ip filter; default: true", "--enable-im-ssh-access <port> - enables and configures SSH forwarding of RCE console commands by the IM \"master\" instance", "--configure-ssh-server <ip> <port> - enables the ssh server and sets the ip and port to bind to", "--disable-ssh-server - disables the ssh server", "--add-ssh-account <username> <role> <enabled: true/false> password - adds an SSH account", "--remove-ssh-account <username> - removes an SSH account", "--set-request-timeout - sets the request timeout in msec", "--set-forwarding-timeout - sets the forwarding timeout in msec", "--add-allowed-inbound-ip <ip> - adds/allows an inbound IP address to the filter", "--remove-allowed-inbound-ip <ip> - removes/disallows an inbound IP address from the filter", "--add-ssh-connection <name> <displayName> <host> <port> <loginName> - adds a new ssh connection", "--remove-ssh-connection <name> - removes a ssh connection", "--add-uplink-connection <id> <hostname> <port> <clientid> <gateway> <connectOnStartup> <autoRetry> <user_name> password <password>", "--remove-uplink-connection <id> - removes an uplink connection", "--publish-component <name> - publishes a new component", "--unpublish-component <name> - unpublishes a component", "--set-background-monitoring <id> <interval> - Enables background monitoring with the given interval (in seconds)"}));
        contributions.add(new CommandDescription("im start", "[--timeout <value>] [--command-arguments <arguments>] <instance id1, instance id2, ...> <installation id>", true, "starts a list of new RCE instances with the desired instance IDs and the desired installation; use \":self\" to use the current \"master\" installation", new String[]{TIMEOUT_DESCRIPTION}));
        contributions.add(new CommandDescription("im stop", "[--timeout <value>] <instance id1, instance id2, ...>", true, "stops a list of running RCE instances", new String[]{TIMEOUT_DESCRIPTION}));
        contributions.add(new CommandDescription("im start all", "[--timeout <value>] [--command-arguments <arguments>] <installation id>", true, "starts all available instances. Uses the given installation; use \":self\" to use the current \"master\" installation", new String[]{TIMEOUT_DESCRIPTION}));
        contributions.add(new CommandDescription("im stop all", "[--timeout <value>] [<installation id>]", true, "stops all running instances", new String[]{"<installation id> - optional parameter if one want to stop all running instances of a specific installation", TIMEOUT_DESCRIPTION}));
        contributions.add(new CommandDescription("im restart", "[--timeout <value>] [--command-arguments <arguments>] <instance id1, instance id2, ...> <installation id>", true, "restarts a list of RCE instances with the given instance IDs and the given installation", new String[0]));
        contributions.add(new CommandDescription("im dispose", "<instance id>", true, "disposes the specified instance meaning deletion of the profile directory", new String[0]));
        contributions.add(new CommandDescription("im list", "[<instances|installations|templates>]", true, "lists information about instances, installations or templates", new String[0]));
        contributions.add(new CommandDescription("im info", "", true, "shows additional information", new String[0]));
        return contributions;
    }

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(ROOT_COMMAND);
        String subCommand = context.consumeNextToken();
        if (subCommand == null) {
            throw CommandException.unknownCommand((CommandContext)context);
        }
        if (!this.instanceManagementService.isInstanceManagementStarted()) {
            throw CommandException.executionError((String)("Cannot execute instance management command. " + this.instanceManagementService.getReasonInstanceManagementNotStarted()), (CommandContext)context);
        }
        switch (subCommand) {
            case "install": {
                this.performInstall(context);
                break;
            }
            case "reinstall": {
                this.performReinstall(context);
                break;
            }
            case "configure": {
                this.performConfigure(context);
                break;
            }
            case "start": {
                if (context.consumeNextTokenIfEquals(ALL_MARKER_TOKEN)) {
                    this.performStartAll(context);
                    break;
                }
                this.performStart(context);
                break;
            }
            case "stop": {
                if (context.consumeNextTokenIfEquals(ALL_MARKER_TOKEN)) {
                    this.performStopAll(context);
                    break;
                }
                this.performStop(context);
                break;
            }
            case "restart": {
                this.performRestart(context);
                break;
            }
            case "list": {
                this.performList(context);
                break;
            }
            case "dispose": {
                this.performDispose(context);
                break;
            }
            case "info": {
                this.performInformation(context);
                break;
            }
            case "execute-on": {
                this.performExecuteOn(context);
                break;
            }
            default: {
                throw CommandException.syntaxError((String)"Unknown sub-command", (CommandContext)context);
            }
        }
        context.getOutputReceiver().addOutput("Done.");
    }

    private void performExecuteOn(CommandContext context) throws CommandException {
        String instanceId = context.consumeNextToken();
        String command = context.consumeNextToken();
        if (instanceId == null || command == null || context.hasRemainingTokens()) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        try {
            this.instanceManagementService.executeCommandOnInstance(instanceId, command, context.getOutputReceiver());
        }
        catch (JSchException | SshParameterException | IOException | InterruptedException e) {
            throw CommandException.executionError((String)("Could not execute command " + command + " on instance " + instanceId + ": " + e.getMessage()), (CommandContext)context);
        }
    }

    private void performInstall(CommandContext context) throws CommandException {
        int timeout = 60000;
        InstanceManagementService.InstallationPolicy policy = InstanceManagementService.InstallationPolicy.IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT;
        if (context.consumeNextTokenIfEquals(TIMEOUT)) {
            timeout = this.getTimeoutValueFromContext(context);
        }
        if (context.consumeNextTokenIfEquals(FORCE_DOWNLOAD)) {
            policy = InstanceManagementService.InstallationPolicy.FORCE_NEW_DOWNLOAD_AND_REINSTALL;
        } else if (context.consumeNextTokenIfEquals(FORCE_REINSTALL)) {
            policy = InstanceManagementService.InstallationPolicy.FORCE_REINSTALL;
        } else if (context.consumeNextTokenIfEquals(IF_MISSING)) {
            policy = InstanceManagementService.InstallationPolicy.ONLY_INSTALL_IF_NOT_PRESENT;
        }
        if (context.consumeNextTokenIfEquals(TIMEOUT)) {
            timeout = this.getTimeoutValueFromContext(context);
        }
        String urlQualifier = context.consumeNextToken();
        String installationId = context.consumeNextToken();
        if (urlQualifier == null || installationId == null || context.hasRemainingTokens()) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        try {
            switch (policy) {
                case FORCE_NEW_DOWNLOAD_AND_REINSTALL: {
                    this.instanceManagementService.setupInstallationFromUrlQualifier(installationId, urlQualifier, InstanceManagementService.InstallationPolicy.FORCE_NEW_DOWNLOAD_AND_REINSTALL, context.getOutputReceiver(), timeout);
                    break;
                }
                case FORCE_REINSTALL: {
                    this.instanceManagementService.setupInstallationFromUrlQualifier(installationId, urlQualifier, InstanceManagementService.InstallationPolicy.FORCE_REINSTALL, context.getOutputReceiver(), timeout);
                    break;
                }
                case IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT: {
                    this.instanceManagementService.setupInstallationFromUrlQualifier(installationId, urlQualifier, InstanceManagementService.InstallationPolicy.IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT, context.getOutputReceiver(), timeout);
                    break;
                }
                case ONLY_INSTALL_IF_NOT_PRESENT: {
                    this.instanceManagementService.setupInstallationFromUrlQualifier(installationId, urlQualifier, InstanceManagementService.InstallationPolicy.ONLY_INSTALL_IF_NOT_PRESENT, context.getOutputReceiver(), timeout);
                    break;
                }
                default: {
                    this.instanceManagementService.setupInstallationFromUrlQualifier(installationId, urlQualifier, InstanceManagementService.InstallationPolicy.IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT, context.getOutputReceiver(), timeout);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw CommandException.executionError((String)("Error during installation setup process: " + e.getMessage()), (CommandContext)context);
        }
    }

    private int getTimeoutValueFromContext(CommandContext context) throws CommandException {
        try {
            return Integer.parseInt(context.consumeNextToken()) * 1000;
        }
        catch (NumberFormatException numberFormatException) {
            throw CommandException.executionError((String)"Timeout value is not a number.", (CommandContext)context);
        }
    }

    private void performReinstall(CommandContext context) throws CommandException {
        InstanceManagementService.InstallationPolicy policy = InstanceManagementService.InstallationPolicy.IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT;
        if (context.consumeNextTokenIfEquals(FORCE_DOWNLOAD)) {
            policy = InstanceManagementService.InstallationPolicy.FORCE_NEW_DOWNLOAD_AND_REINSTALL;
        } else if (context.consumeNextTokenIfEquals(FORCE_REINSTALL)) {
            policy = InstanceManagementService.InstallationPolicy.FORCE_REINSTALL;
        }
        String urlQualifier = context.consumeNextToken();
        String installationId = context.consumeNextToken();
        if (urlQualifier == null || installationId == null || context.hasRemainingTokens()) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        try {
            switch (policy) {
                case FORCE_NEW_DOWNLOAD_AND_REINSTALL: {
                    this.instanceManagementService.reinstallFromUrlQualifier(installationId, urlQualifier, InstanceManagementService.InstallationPolicy.FORCE_NEW_DOWNLOAD_AND_REINSTALL, context.getOutputReceiver(), 0L);
                    break;
                }
                case FORCE_REINSTALL: {
                    this.instanceManagementService.reinstallFromUrlQualifier(installationId, urlQualifier, InstanceManagementService.InstallationPolicy.FORCE_REINSTALL, context.getOutputReceiver(), 0L);
                    break;
                }
                case IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT: {
                    this.instanceManagementService.reinstallFromUrlQualifier(installationId, urlQualifier, InstanceManagementService.InstallationPolicy.IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT, context.getOutputReceiver(), 0L);
                    break;
                }
                default: {
                    this.instanceManagementService.reinstallFromUrlQualifier(installationId, urlQualifier, InstanceManagementService.InstallationPolicy.IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT, context.getOutputReceiver(), 0L);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw CommandException.executionError((String)("Error during installation setup process: " + e.getMessage()), (CommandContext)context);
        }
    }

    private boolean validateIpAddress(String ip) {
        Matcher matcher = IP_ADDRESS_PATTERN.matcher(ip);
        return matcher.matches();
    }

    private void performConfigure(CommandContext context) throws CommandException {
        this.currentContext.set(context);
        String instanceIds = context.consumeNextToken();
        if (instanceIds == null) {
            throw CommandException.syntaxError((String)"Expected an instance id", (CommandContext)context);
        }
        if (instanceIds.contains(COMMA_STRING)) {
            throw CommandException.executionError((String)"Configuring multiple instance ids at once is not implemented yet", (CommandContext)context);
        }
        String firstToken = context.peekNextToken();
        if (firstToken == null) {
            throw CommandException.syntaxError((String)"At least one command must be provided after the instance id(s)", (CommandContext)context);
        }
        if (!this.isASubCommandToken(firstToken)) {
            throw CommandException.syntaxError((String)("Expected a command after the instance id(s), but found another value: " + firstToken), (CommandContext)context);
        }
        InstanceConfigurationOperationSequence changeSequence = this.instanceManagementService.newConfigurationOperationSequence();
        while (context.hasRemainingTokens()) {
            String commandToken = context.consumeNextToken();
            if (!this.isASubCommandToken(commandToken)) {
                throw CommandException.syntaxError((String)"Internal consistency error: received an unexpected non-command token ", (CommandContext)context);
            }
            ArrayList<String> parameters = new ArrayList<String>();
            while (this.isAParameterToken(context.peekNextToken())) {
                parameters.add(context.consumeNextToken());
            }
            this.parseConfigurationSubCommand(changeSequence, commandToken, parameters);
        }
        try {
            this.instanceManagementService.applyInstanceConfigurationOperations(instanceIds, changeSequence, context.getOutputReceiver());
        }
        catch (IOException e) {
            throw CommandException.executionError((String)e.toString(), (CommandContext)context);
        }
        catch (InstanceConfigurationException e) {
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
        }
    }

    private void parseConfigurationSubCommand(InstanceConfigurationOperationSequence changeSequence, String token, List<String> parameters) throws CommandException {
        switch (token) {
            case "--set-rce-version": {
                this.assertParameterCount(parameters, 1, token);
                String version = parameters.get(0);
                changeSequence.setProfileVersion(version);
                break;
            }
            case "--reset": {
                this.assertParameterCount(parameters, 0, token);
                changeSequence.resetConfiguration();
                break;
            }
            case "--wipe": {
                this.assertParameterCount(parameters, 0, token);
                changeSequence.wipeConfiguration();
                break;
            }
            case "--apply-template": {
                this.assertParameterCount(parameters, 1, token);
                String templateName = parameters.get(0);
                changeSequence.applyTemplate(templateName);
                break;
            }
            case "--set-name": {
                this.assertParameterCount(parameters, 1, token);
                String name = parameters.get(0);
                changeSequence.setName(name);
                break;
            }
            case "--set-comment": {
                this.assertParameterCount(parameters, 1, token);
                String comment = parameters.get(0);
                changeSequence.setComment(comment);
                break;
            }
            case "--set-relay-option": {
                this.assertParameterCount(parameters, 0, 1, token);
                changeSequence.setRelayFlag(this.parseSingleBooleanParameter(parameters, false));
                break;
            }
            case "--set-workflow-host-option": {
                this.assertParameterCount(parameters, 0, 1, token);
                changeSequence.setWorkflowHostFlag(this.parseSingleBooleanParameter(parameters, false));
                break;
            }
            case "--set-custom-node-id": {
                this.assertParameterCount(parameters, 1, token);
                changeSequence.setCustomNodeId(parameters.get(0));
                break;
            }
            case "--set-tempdir-path": {
                this.assertParameterCount(parameters, 1, token);
                String tempPath = parameters.get(0);
                changeSequence.setTempDirPath(tempPath);
                break;
            }
            case "--add-server-port": {
                this.assertParameterCount(parameters, 3, token);
                String serverPortName = parameters.get(0);
                String serverPortIp = parameters.get(1);
                int serverPortNumber = Integer.parseInt(parameters.get(2));
                changeSequence.addServerPort(serverPortName, serverPortIp, serverPortNumber);
                break;
            }
            case "--add-connection": {
                this.assertParameterCount(parameters, 4, token);
                parameters.add("5");
                parameters.add("30");
                parameters.add("1.5");
                changeSequence.addNetworkConnectionFromStringParameters(parameters);
                break;
            }
            case "--remove-connection": {
                this.assertParameterCount(parameters, 1, token);
                changeSequence.removeConnection(parameters.get(0));
                break;
            }
            case "--configure-ssh-server": {
                this.assertParameterCount(parameters, 2, token);
                this.configureSshServer(changeSequence, parameters);
                break;
            }
            case "--disable-ssh-server": {
                this.assertParameterCount(parameters, 0, token);
                changeSequence.disableSshServer();
                break;
            }
            case "--add-ssh-account": {
                this.assertParameterCount(parameters, 4, token);
                changeSequence.addSshAccountFromStringParameters(parameters);
                break;
            }
            case "--remove-ssh-account": {
                this.assertParameterCount(parameters, 1, token);
                changeSequence.removeSshAccount(parameters.get(0));
                break;
            }
            case "--set-ip-filter-option": {
                this.assertParameterCount(parameters, 0, 1, token);
                boolean ipFilterState = this.parseSingleBooleanParameter(parameters, true);
                changeSequence.setIpFilterEnabled(ipFilterState);
                break;
            }
            case "--enable-im-ssh-access": {
                this.assertParameterCount(parameters, 1, token);
                this.enableImSshAccess(changeSequence, parameters);
                break;
            }
            case "--set-request-timeout": {
                this.assertParameterCount(parameters, 1, token);
                if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)parameters.get(0))) {
                    throw CommandException.syntaxError((String)"Unexpected parameter type. Timeout must be a numeric value.", (CommandContext)this.currentContext.get());
                }
                long timeout = Long.parseLong(parameters.get(0));
                changeSequence.setRequestTimeout(timeout);
                break;
            }
            case "--set-forwarding-timeout": {
                this.assertParameterCount(parameters, 1, token);
                if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)parameters.get(0))) {
                    throw CommandException.syntaxError((String)"Unexpected parameter type. Timeout must be a numeric value.", (CommandContext)this.currentContext.get());
                }
                long fTimeout = Long.parseLong(parameters.get(0));
                changeSequence.setForwardingTimeout(fTimeout);
                break;
            }
            case "--add-allowed-inbound-ip": {
                this.assertParameterCount(parameters, 1, token);
                changeSequence.addAllowedInboundIP(parameters.get(0));
                break;
            }
            case "--remove-allowed-inbound-ip": {
                this.assertParameterCount(parameters, 1, token);
                changeSequence.removeAllowedInboundIP(parameters.get(0));
                break;
            }
            case "--add-ssh-connection": {
                this.assertParameterCount(parameters, 5, token);
                changeSequence.addSshConnectionFromStringParameters(parameters);
                break;
            }
            case "--remove-ssh-connection": {
                this.assertParameterCount(parameters, 1, token);
                changeSequence.removeSshConnection(parameters.get(0));
                break;
            }
            case "--add-uplink-connection": {
                this.assertParameterCount(parameters, 10, token);
                changeSequence.addUplinkConnectionFromStringParameters(parameters);
                break;
            }
            case "--remove-uplink-connection": {
                this.assertParameterCount(parameters, 1, token);
                changeSequence.removeUplinkConnection(parameters.get(0));
                break;
            }
            case "--publish-component": {
                this.assertParameterCount(parameters, 1, token);
                changeSequence.publishComponent(parameters.get(0));
                break;
            }
            case "--unpublish-component": {
                this.assertParameterCount(parameters, 1, token);
                changeSequence.unpublishComponent(parameters.get(0));
                break;
            }
            case "--set-background-monitoring": {
                this.assertParameterCount(parameters, 2, token);
                if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)parameters.get(1))) {
                    throw CommandException.syntaxError((String)"Unexpected parameter type. Interval must be a numeric value.", (CommandContext)this.currentContext.get());
                }
                changeSequence.setBackgroundMonitoring(parameters.get(0), Integer.parseInt(parameters.get(1)));
                break;
            }
            default: {
                throw CommandException.syntaxError((String)("Unexpected configuration command " + token), (CommandContext)this.currentContext.get());
            }
        }
    }

    private void enableImSshAccess(InstanceConfigurationOperationSequence changeSequence, List<String> parameters) throws CommandException {
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)parameters.get(0))) {
            throw CommandException.syntaxError((String)"Unexpected parameter type. Port must be a numeric value.", (CommandContext)this.currentContext.get());
        }
        int accessPort = Integer.parseInt(parameters.get(0));
        changeSequence.enableImSshAccess(accessPort);
    }

    private void configureSshServer(InstanceConfigurationOperationSequence changeSequence, List<String> parameters) throws CommandException {
        String ipAddress = parameters.get(0);
        if (!this.validateIpAddress(ipAddress)) {
            throw CommandException.syntaxError((String)(String.valueOf(ipAddress) + " is not a valid IP address."), (CommandContext)this.currentContext.get());
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)parameters.get(1))) {
            throw CommandException.syntaxError((String)"The SSH port must be a numeric value.", (CommandContext)this.currentContext.get());
        }
        int sshServerPort = Integer.parseInt(parameters.get(1));
        changeSequence.enableSshServer(ipAddress, sshServerPort);
    }

    private boolean parseSingleBooleanParameter(List<String> parameters, boolean defaultValue) throws CommandException {
        if (parameters.isEmpty()) {
            return defaultValue;
        }
        if (parameters.get(0).equals("true")) {
            return true;
        }
        if (parameters.get(0).equals("false")) {
            return false;
        }
        throw CommandException.syntaxError((String)("Invalid parameter (expected 'true' or 'false'): " + parameters.get(0)), (CommandContext)this.currentContext.get());
    }

    private void assertParameterCount(List<String> parameters, int min, String commandToken) throws CommandException {
        this.assertParameterCount(parameters, min, min, commandToken);
    }

    private void assertParameterCount(List<String> parameters, int min, int max, String commandToken) throws CommandException {
        int actual = parameters.size();
        if (actual < min || max < actual) {
            throw CommandException.syntaxError((String)StringUtils.format((String)"Wrong number of parameters for the %s command: expected between %d and %d parameters, but found %d: %s", (Object[])new Object[]{commandToken, min, max, actual, Arrays.toString(parameters.toArray())}), (CommandContext)this.currentContext.get());
        }
    }

    private boolean isASubCommandToken(String token) {
        return token != null && token.startsWith("--");
    }

    private boolean isAParameterToken(String token) {
        return token != null && !token.startsWith("--");
    }

    private void performStart(CommandContext context) throws CommandException {
        ParameterParser parameters = new ParameterParser(context, true, true);
        String commandArguments = parameters.getCommandArguments() == null ? "" : parameters.getCommandArguments();
        this.triggerStartOfInstances(parameters.getInstallationId(), parameters.getInstanceIds(), parameters.getTimeout(), parameters.getStartWithGUI(), commandArguments, context);
    }

    private void performRestart(CommandContext context) throws CommandException {
        ParameterParser parameters = new ParameterParser(context, true, true);
        this.triggerStopOfInstances(parameters.getInstanceIds(), parameters.getTimeout(), context);
        this.triggerStartOfInstances(parameters.getInstallationId(), parameters.getInstanceIds(), parameters.getTimeout(), parameters.getStartWithGUI(), parameters.getCommandArguments(), context);
    }

    private void performStop(CommandContext context) throws CommandException {
        ParameterParser parameters = new ParameterParser(context, true, false);
        this.triggerStopOfInstances(parameters.getInstanceIds(), parameters.getTimeout(), context);
    }

    private void performStopAll(CommandContext context) throws CommandException {
        ParameterParser parameters = new ParameterParser(context, false, null);
        String installationId = parameters.getInstallationId();
        if (installationId == null) {
            installationId = "";
        }
        this.triggerStopOfAllInstances(installationId, parameters.getTimeout(), context);
    }

    private void performStartAll(CommandContext context) throws CommandException {
        ParameterParser parameters = new ParameterParser(context, false, true);
        String commandArguments = parameters.getCommandArguments() == null ? "" : parameters.getCommandArguments();
        this.triggerStartOfAllInstances(parameters.getInstallationId(), parameters.getTimeout(), commandArguments, context);
    }

    private void performList(CommandContext context) throws CommandException {
        String scope = context.consumeNextToken();
        if (scope == null) {
            scope = ALL_MARKER_TOKEN;
        }
        if (("instances".equals(scope) || "installations".equals(scope) || "templates".equals(scope) || ALL_MARKER_TOKEN.equals(scope)) && !context.hasRemainingTokens()) {
            try {
                this.instanceManagementService.listInstanceManagementInformation(scope, context.getOutputReceiver());
            }
            catch (IOException e) {
                throw CommandException.executionError((String)e.toString(), (CommandContext)context);
            }
        } else {
            throw CommandException.syntaxError((String)"Unknown parameter", (CommandContext)context);
        }
    }

    private void performDispose(CommandContext context) throws CommandException {
        ParameterParser parameters = new ParameterParser(context, true, false);
        for (String instanceId : parameters.getInstanceIds()) {
            try {
                this.instanceManagementService.disposeInstance(instanceId, context.getOutputReceiver());
            }
            catch (IOException e) {
                throw CommandException.executionError((String)e.toString(), (CommandContext)context);
            }
            context.getOutputReceiver().addOutput("Instance '" + instanceId + "' disposed");
        }
    }

    private void performInformation(CommandContext context) throws CommandException {
        if (context.hasRemainingTokens()) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        this.instanceManagementService.showInstanceManagementInformation(context.getOutputReceiver());
    }

    private void triggerStartOfInstances(String installationId, List<String> instanceIdList, long timeout, boolean startWithGui, String commandArguments, CommandContext context) throws CommandException {
        try {
            this.instanceManagementService.startInstance(installationId, instanceIdList, context.getOutputReceiver(), timeout, startWithGui, commandArguments);
        }
        catch (IOException e) {
            throw CommandException.executionError((String)e.toString(), (CommandContext)context);
        }
    }

    private void triggerStartOfAllInstances(String installationId, long timeout, String commandArguments, CommandContext context) throws CommandException {
        try {
            this.instanceManagementService.startAllInstances(installationId, context.getOutputReceiver(), timeout, commandArguments);
        }
        catch (IOException e) {
            throw CommandException.executionError((String)e.toString(), (CommandContext)context);
        }
    }

    private void triggerStopOfInstances(List<String> instanceIdList, long timeout, CommandContext context) throws CommandException {
        try {
            this.instanceManagementService.stopInstance(instanceIdList, context.getOutputReceiver(), timeout);
        }
        catch (IOException e) {
            throw CommandException.executionError((String)e.toString(), (CommandContext)context);
        }
    }

    private void triggerStopOfAllInstances(String installationId, long timeout, CommandContext context) throws CommandException {
        try {
            this.instanceManagementService.stopAllInstances(installationId, context.getOutputReceiver(), timeout);
        }
        catch (IOException e) {
            throw CommandException.executionError((String)e.toString(), (CommandContext)context);
        }
    }

    private static final class ParameterParser {
        private final CommandContext context;
        private final String installationId;
        private final long timeout;
        private final boolean startWithGUI;
        private final List<String> instanceIds;
        private final String commandArguments;

        private ParameterParser(CommandContext context, boolean expectListOfInstanceIds, Boolean expectInstallationId) throws CommandException {
            this.context = context;
            List remainingTokens = context.consumeRemainingTokens();
            this.timeout = this.determineTimeout(remainingTokens);
            this.startWithGUI = this.determineStartWithGUI(remainingTokens);
            this.commandArguments = this.determineCommandArguments(remainingTokens);
            this.installationId = expectInstallationId != Boolean.FALSE ? this.determineInstallationId(remainingTokens, expectInstallationId == Boolean.TRUE) : null;
            this.instanceIds = expectListOfInstanceIds ? this.parseTokensToInstanceIdList(remainingTokens) : Collections.unmodifiableList(new ArrayList());
        }

        public long getTimeout() throws CommandException {
            return this.timeout;
        }

        public boolean getStartWithGUI() throws CommandException {
            return this.startWithGUI;
        }

        public List<String> getInstanceIds() throws CommandException {
            return this.instanceIds;
        }

        public String getInstallationId() {
            return this.installationId;
        }

        public String getCommandArguments() {
            return this.commandArguments;
        }

        private long determineTimeout(List<String> remainingTokens) throws CommandException {
            long result = 0L;
            if (remainingTokens.contains(InstanceManagementCommandPlugin.TIMEOUT)) {
                int index = remainingTokens.indexOf(InstanceManagementCommandPlugin.TIMEOUT);
                remainingTokens.remove(index);
                try {
                    String t = remainingTokens.remove(index);
                    if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)t)) {
                        throw CommandException.executionError((String)"No timeout specified", (CommandContext)this.context);
                    }
                    result = Long.parseLong(t);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw CommandException.executionError((String)"No timeout specified", (CommandContext)this.context);
                }
            }
            return result;
        }

        private boolean determineStartWithGUI(List<String> remainingTokens) {
            int index = remainingTokens.indexOf(InstanceManagementCommandPlugin.OPTION_START_WITH_GUI);
            if (index >= 0) {
                remainingTokens.remove(index);
                return true;
            }
            return false;
        }

        private String determineInstallationId(List<String> remainingTokens, boolean required) throws CommandException {
            if (!remainingTokens.isEmpty()) {
                String lastToken = remainingTokens.remove(remainingTokens.size() - 1);
                if (lastToken.isEmpty()) {
                    throw CommandException.executionError((String)"Installation ID can not be empty", (CommandContext)this.context);
                }
                return lastToken;
            }
            if (required) {
                throw new IllegalStateException("No remaining token to use as installation id");
            }
            return null;
        }

        private List<String> parseTokensToInstanceIdList(List<String> remainingTokens) throws CommandException {
            LinkedList<String> instanceIdList = new LinkedList<String>();
            for (String token : remainingTokens) {
                if (token.contains(InstanceManagementCommandPlugin.COMMA_STRING)) {
                    if (token.length() == 1) continue;
                    if (token.startsWith(InstanceManagementCommandPlugin.COMMA_STRING)) {
                        instanceIdList.add(token.replaceFirst(InstanceManagementCommandPlugin.COMMA_STRING, ""));
                        continue;
                    }
                    instanceIdList.addAll(Arrays.asList(token.split(InstanceManagementCommandPlugin.COMMA_STRING)));
                    continue;
                }
                instanceIdList.add(token);
            }
            if (instanceIdList.isEmpty()) {
                throw CommandException.syntaxError((String)"Expected at least one instance id", (CommandContext)this.context);
            }
            return Collections.unmodifiableList(instanceIdList);
        }

        private String determineCommandArguments(List<String> remainingTokens) {
            int index = remainingTokens.indexOf(InstanceManagementCommandPlugin.COMMAND_ARGUMENTS);
            if (index >= 0 && index + 1 < remainingTokens.size()) {
                String arguments = remainingTokens.get(index + 1);
                remainingTokens.remove(index + 1);
                remainingTokens.remove(index);
                return arguments;
            }
            return null;
        }
    }
}

