/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.execute.Messages;
import de.rcenvironment.core.gui.workflow.execute.PlaceholderPage;
import java.awt.GraphicsEnvironment;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class WorkflowExecutionWizardValidationDialog
extends TitleAreaDialog {
    private static final String DIALOG_TITLE = "Validation Report";
    private static final String INDEX = "index";
    private static final String ORDER = "order";
    private static final int MINUS_ONE = -1;
    private static final int MINIMUM_TABLE_SIZE = 10000;
    private Table table;
    private final Map<String, List<ComponentValidationMessage>> messagesMap;
    private final WorkflowDescription wfDescription;
    private final PlaceholderPage placeholderPage;
    private final ImageManager imageManger = ImageManager.getInstance();

    public WorkflowExecutionWizardValidationDialog(Shell parentShell, Map<String, List<ComponentValidationMessage>> messagesMap, WorkflowDescription wfDescription, PlaceholderPage placeholderPage) {
        super(parentShell);
        this.messagesMap = messagesMap;
        this.wfDescription = wfDescription;
        this.placeholderPage = placeholderPage;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    public void create() {
        super.create();
        this.setTitle(DIALOG_TITLE);
        this.setMessageText();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite container = new Composite(area, 4);
        GridData data = new GridData(1808);
        data.heightHint = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getHeight() * 2 / 5;
        data.widthHint = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getWidth() * 2 / 3;
        data.grabExcessVerticalSpace = true;
        container.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.initilizeTable(container);
        this.createColumns();
        this.fillTable();
        Label horizontalBar = new Label(container, 258);
        horizontalBar.setLayoutData((Object)new GridData(768));
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.proceedButton, false);
        this.createButton(parent, 1, Messages.cancelButton, true);
    }

    private void setMessageText() {
        int messageCount = 0;
        for (String key : this.messagesMap.keySet()) {
            if ((messageCount += this.messagesMap.get(key).size()) > 1) break;
        }
        for (String key : this.placeholderPage.getPlaceholderValidators().keySet()) {
            if (messageCount > 1) break;
            messageCount += this.placeholderPage.getPlaceholderValidators().get(key).size();
        }
        boolean hasErrorMessage = false;
        for (String key : this.messagesMap.keySet()) {
            for (ComponentValidationMessage message : this.messagesMap.get(key)) {
                if (message.getType() != ComponentValidationMessage.Type.ERROR) continue;
                hasErrorMessage = true;
                break;
            }
            if (hasErrorMessage) break;
        }
        String titleText = messageCount > 1 ? Messages.validationProblems : Messages.validationProblem;
        if (hasErrorMessage) {
            this.setMessage(titleText, 3);
        } else {
            this.setMessage(titleText, 2);
        }
    }

    private void initilizeTable(Composite parent) {
        this.table = new Table(parent, 68354);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData data = new GridData(1808);
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 10000;
        this.table.setLayoutData((Object)data);
        this.table.addKeyListener((KeyListener)new TableCopyKeyListener());
        this.table.addMouseListener((MouseListener)new TableCopyMouseListener());
    }

    private void createColumns() {
        TableColumn componentColumn = new TableColumn(this.table, 0);
        componentColumn.setText("Component");
        componentColumn.setData(INDEX, (Object)0);
        componentColumn.addSelectionListener((SelectionListener)new SortColumnListener());
        componentColumn.setData(ORDER, (Object)OrderState.COMPONENT_UP);
        this.table.notifyListeners(13, new Event());
        TableColumn typeColumn = new TableColumn(this.table, 0);
        typeColumn.setText("Type");
        typeColumn.setData(INDEX, (Object)1);
        typeColumn.addSelectionListener((SelectionListener)new SortColumnListener());
        typeColumn.setData(ORDER, (Object)OrderState.TYPE_UP);
        TableColumn messageColumn = new TableColumn(this.table, 0);
        messageColumn.setText("Message");
        messageColumn.setData(INDEX, (Object)2);
        messageColumn.addSelectionListener((SelectionListener)new SortColumnListener());
        messageColumn.setData(ORDER, (Object)OrderState.MESSAGE_UP);
    }

    private void fillTable() {
        for (String nodeIdentifier : this.messagesMap.keySet()) {
            WorkflowNode currentNode = null;
            for (WorkflowNode node : this.wfDescription.getWorkflowNodes()) {
                if (!node.getIdentifier().equals(nodeIdentifier)) continue;
                currentNode = node;
                break;
            }
            if (currentNode == null) continue;
            String nodeName = currentNode.getName();
            if (this.placeholderPage.getPlaceholderValidators().containsKey(nodeName)) {
                for (String placeholderName : this.placeholderPage.getPlaceholderValidators().get(nodeName)) {
                    String dataType = (String)this.placeholderPage.placeholderHelper.getPlaceholdersDataType().get(String.valueOf(nodeName) + "." + placeholderName);
                    if (dataType != null && dataType.equals("text")) {
                        this.addMessageItem(currentNode, ComponentValidationMessage.Type.ERROR, String.valueOf(Messages.textExceedsMaxLength) + placeholderName);
                        continue;
                    }
                    this.addMessageItem(currentNode, ComponentValidationMessage.Type.ERROR, String.valueOf(Messages.missingPlaceholder) + placeholderName);
                }
            }
            for (ComponentValidationMessage message : this.messagesMap.get(nodeIdentifier)) {
                this.addMessageItem(currentNode, message.getType(), message.getAbsoluteMessage());
            }
        }
        new SortColumnListener().intialSort();
        this.table.getColumn(0).pack();
        this.table.getColumn(1).pack();
        this.table.getColumn(2).pack();
    }

    private Image getImage(WorkflowNode element) {
        return element.getComponentDescription().getIcon16();
    }

    private void addMessageItem(WorkflowNode node, ComponentValidationMessage.Type type, String message) {
        TableItem item = new TableItem(this.table, 0);
        item.setImage(0, this.getImage(node));
        item.setText(0, node.getName());
        switch (type) {
            case ERROR: {
                item.setImage(1, this.imageManger.getSharedImage((ImageSource)StandardImages.ERROR_16));
                item.setText(1, type.toString());
                break;
            }
            case WARNING: {
                item.setImage(1, this.imageManger.getSharedImage((ImageSource)StandardImages.WARNING_16));
                item.setText(1, type.toString());
                break;
            }
            default: {
                item.setImage(1, this.imageManger.getSharedImage((ImageSource)StandardImages.ERROR_16));
                item.setText(1, ComponentValidationMessage.Type.ERROR.toString());
            }
        }
        item.setText(2, message);
    }

    private String buildCopyString(TableItem[] tableItems) {
        String returnString = "";
        int i = 0;
        while (i < tableItems.length) {
            returnString = String.valueOf(returnString) + tableItems[i].getText(0);
            returnString = String.valueOf(returnString) + " - ";
            returnString = String.valueOf(returnString) + tableItems[i].getText(1);
            returnString = String.valueOf(returnString) + " - ";
            returnString = String.valueOf(returnString) + tableItems[i].getText(2);
            returnString = String.valueOf(returnString) + "\n";
            ++i;
        }
        return returnString;
    }

    private static enum OrderState {
        COMPONENT_UP,
        COMPONENT_DOWN,
        TYPE_UP,
        TYPE_DOWN,
        MESSAGE_UP,
        MESSAGE_DOWN;

    }

    private class SortColumnListener
    implements SelectionListener {
        private SortColumnListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            TableColumn tableColumn = (TableColumn)arg0.getSource();
            this.sortColumn(tableColumn);
        }

        public void intialSort() {
            this.sortColumn(WorkflowExecutionWizardValidationDialog.this.table.getColumn(0));
        }

        private void sortColumn(TableColumn tableColumn) {
            int index = (Integer)tableColumn.getData(WorkflowExecutionWizardValidationDialog.INDEX);
            final int orderdir = this.setOrderDirFromTableColumn(tableColumn);
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            Collator collator = Collator.getInstance();
            collator.setStrength(0);
            TableItem[] items = WorkflowExecutionWizardValidationDialog.this.table.getItems();
            int i = 0;
            while (i < items.length) {
                list.add(new Object[]{collator.getCollationKey(items[i].getText(index)), this.getItemData(items[i])});
                ++i;
            }
            Collections.sort(list, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] arg0, Object[] arg1) {
                    return orderdir * ((CollationKey)arg0[0]).compareTo((CollationKey)arg1[0]);
                }
            });
            i = 0;
            while (i < items.length) {
                this.setItemData(items[i], (Object[])((Object[])list.get(i))[1]);
                ++i;
            }
        }

        private int setOrderDirFromTableColumn(TableColumn tableColumn) {
            int orderdir;
            OrderState orderState = (OrderState)((Object)tableColumn.getData(WorkflowExecutionWizardValidationDialog.ORDER));
            block0 : switch ((Integer)tableColumn.getData(WorkflowExecutionWizardValidationDialog.INDEX)) {
                case 0: {
                    switch (orderState) {
                        case COMPONENT_UP: {
                            orderdir = 1;
                            tableColumn.setData(WorkflowExecutionWizardValidationDialog.ORDER, (Object)OrderState.COMPONENT_DOWN);
                            break block0;
                        }
                        case COMPONENT_DOWN: {
                            orderdir = -1;
                            tableColumn.setData(WorkflowExecutionWizardValidationDialog.ORDER, (Object)OrderState.COMPONENT_UP);
                            break block0;
                        }
                    }
                    orderdir = 1;
                    tableColumn.setData(WorkflowExecutionWizardValidationDialog.ORDER, (Object)OrderState.COMPONENT_DOWN);
                    break;
                }
                case 1: {
                    switch (orderState) {
                        case TYPE_UP: {
                            orderdir = 1;
                            tableColumn.setData(WorkflowExecutionWizardValidationDialog.ORDER, (Object)OrderState.TYPE_DOWN);
                            break block0;
                        }
                        case TYPE_DOWN: {
                            orderdir = -1;
                            tableColumn.setData(WorkflowExecutionWizardValidationDialog.ORDER, (Object)OrderState.TYPE_UP);
                            break block0;
                        }
                    }
                    orderdir = 1;
                    tableColumn.setData(WorkflowExecutionWizardValidationDialog.ORDER, (Object)OrderState.TYPE_DOWN);
                    break;
                }
                case 2: {
                    switch (orderState) {
                        case MESSAGE_UP: {
                            orderdir = 1;
                            tableColumn.setData(WorkflowExecutionWizardValidationDialog.ORDER, (Object)OrderState.MESSAGE_DOWN);
                            break block0;
                        }
                        case MESSAGE_DOWN: {
                            orderdir = -1;
                            tableColumn.setData(WorkflowExecutionWizardValidationDialog.ORDER, (Object)OrderState.MESSAGE_UP);
                            break block0;
                        }
                    }
                    orderdir = 1;
                    tableColumn.setData(WorkflowExecutionWizardValidationDialog.ORDER, (Object)OrderState.MESSAGE_DOWN);
                    break;
                }
                default: {
                    orderdir = 1;
                    tableColumn.setData(WorkflowExecutionWizardValidationDialog.ORDER, (Object)OrderState.COMPONENT_DOWN);
                }
            }
            return orderdir;
        }

        private Object[] getItemData(TableItem item) {
            return new Object[]{item.getText(0), item.getText(1), item.getText(2), item.getImage(0), item.getImage(1), item.getImage(2)};
        }

        private void setItemData(TableItem item, Object[] object) {
            String[] values = new String[]{(String)object[0], (String)object[1], (String)object[2]};
            Image[] images = new Image[]{(Image)object[3], (Image)object[4], (Image)object[5]};
            item.setText(values);
            item.setImage(images);
        }
    }

    private class TableCopyKeyListener
    implements KeyListener {
        private TableCopyKeyListener() {
        }

        public void keyPressed(KeyEvent arg0) {
            if (arg0.getSource() instanceof Table && arg0.stateMask == 262144 && arg0.keyCode == 99) {
                TableItem[] tableItems = ((Table)arg0.getSource()).getSelection();
                Clipboard clipboard = new Clipboard(WorkflowExecutionWizardValidationDialog.this.getShell().getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                String copyString = WorkflowExecutionWizardValidationDialog.this.buildCopyString(tableItems);
                clipboard.setContents((Object[])new String[]{copyString}, new Transfer[]{textTransfer});
                clipboard.dispose();
            }
        }

        public void keyReleased(KeyEvent arg0) {
        }
    }

    private class TableCopyMouseListener
    implements MouseListener {
        private TableCopyMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent arg0) {
        }

        public void mouseDown(MouseEvent event) {
            if (event.button == 3) {
                final Menu menu = new Menu((Control)WorkflowExecutionWizardValidationDialog.this.table);
                MenuItem newItem = new MenuItem(menu, 0);
                newItem.setText("Copy");
                newItem.setImage(WorkflowExecutionWizardValidationDialog.this.imageManger.getSharedImage((ImageSource)StandardImages.COPY_16));
                menu.setVisible(true);
                newItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }

                    public void widgetSelected(SelectionEvent arg0) {
                        TableItem[] tableItems = WorkflowExecutionWizardValidationDialog.this.table.getSelection();
                        Clipboard clipboard = new Clipboard(WorkflowExecutionWizardValidationDialog.this.getShell().getDisplay());
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        String copyString = WorkflowExecutionWizardValidationDialog.this.buildCopyString(tableItems);
                        clipboard.setContents((Object[])new String[]{copyString}, new Transfer[]{textTransfer});
                        clipboard.dispose();
                        menu.dispose();
                    }
                });
            }
        }

        public void mouseUp(MouseEvent arg0) {
        }
    }
}

