/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.integration;

import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationMetaDataDefinition;
import de.rcenvironment.core.component.model.configuration.api.ReadOnlyConfiguration;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.integration.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PropertiesSection
extends ValidatingWorkflowNodePropertySection {
    private static final int LIST_HEIGHT = 100;
    private static final int LIST_WIDTH = 150;
    private static final int COMLUMN_WIDTH = 200;
    private static final int COMLUMN_WIDTH_PLACEHOLDER = 140;
    private List propGroupList;
    private Table propertyTable;
    private int groupSelection;
    private TableColumn valueColumn;
    private TableColumn nameColumn;
    private TableColumn placeholderColumn;
    private Map<String, String> previousValues;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, true));
        Section propertiesSection = this.getWidgetFactory().createSection(composite, 256);
        propertiesSection.setText(Messages.propertyConfiguration);
        propertiesSection.setLayoutData((Object)new GridData(1808));
        Composite propertiesComposite = this.getWidgetFactory().createFlatFormComposite((Composite)propertiesSection);
        propertiesComposite.setLayout((Layout)new GridLayout(2, false));
        propertiesComposite.setLayoutData((Object)new GridData(1808));
        new Label(propertiesComposite, 0).setText(Messages.propGroupsLabel);
        new Label(propertiesComposite, 0).setText(Messages.properties);
        this.propGroupList = new List(propertiesComposite, 2564);
        GridData groupsListGridData = new GridData(1040);
        groupsListGridData.widthHint = 150;
        groupsListGridData.heightHint = 100;
        groupsListGridData.grabExcessVerticalSpace = true;
        this.propGroupList.setLayoutData((Object)groupsListGridData);
        this.propGroupList.addSelectionListener((SelectionListener)new PropertyGroupTableListener(this.propGroupList));
        this.propertyTable = new Table(propertiesComposite, 34818);
        this.propertyTable.setHeaderVisible(true);
        this.propertyTable.setLayoutData((Object)new GridData(1808));
        this.nameColumn = new TableColumn(this.propertyTable, 0);
        this.nameColumn.setText(Messages.name);
        this.nameColumn.setResizable(true);
        this.nameColumn.setWidth(200);
        this.valueColumn = new TableColumn(this.propertyTable, 0);
        this.valueColumn.setText(Messages.value);
        this.valueColumn.setResizable(false);
        this.valueColumn.setWidth(200);
        this.valueColumn.setAlignment(0x1000000);
        this.placeholderColumn = new TableColumn(this.propertyTable, 0);
        this.placeholderColumn.setText("Define at workflow start");
        this.placeholderColumn.setResizable(false);
        this.placeholderColumn.setWidth(140);
        this.propertyTable.setLinesVisible(true);
        TableItem nullItem = new TableItem(this.propertyTable, 0);
        nullItem.setText("");
        TableEditor editor = new TableEditor(this.propertyTable);
        Text nullText = new Text((Composite)this.propertyTable, 0);
        editor.setEditor((Control)nullText, nullItem, 1);
        propertiesSection.setClient((Control)propertiesComposite);
    }

    private void updateSelection() {
        Control[] controlArray = this.propertyTable.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.propertyTable.removeAll();
        if (this.propGroupList.getItemCount() > this.groupSelection) {
            String group = this.propGroupList.getItem(this.groupSelection);
            Map config = this.getConfiguration().getConfigurationDescription().getConfiguration();
            ConfigurationMetaDataDefinition metadata = this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition().getConfigurationMetaDataDefinition();
            LinkedList<String> groupKeys = new LinkedList<String>();
            for (String configKey : config.keySet()) {
                if (!metadata.getGuiGroupName(configKey).equals(group)) continue;
                groupKeys.add(configKey);
            }
            Collections.sort(groupKeys);
            this.previousValues = new HashMap<String, String>();
            for (final String groupKey : groupKeys) {
                TableItem configItem = new TableItem(this.propertyTable, 0);
                configItem.setText(metadata.getGuiName(groupKey));
                TableEditor editor = new TableEditor(this.propertyTable);
                Text textField = new Text((Composite)this.propertyTable, 0);
                textField.setData("property.control", (Object)groupKey);
                final Button checkBox = new Button((Composite)this.propertyTable, 0x1000020);
                checkBox.setData("property.control", (Object)groupKey);
                if (!((String)config.get(groupKey)).equals("")) {
                    textField.setText((String)config.get(groupKey));
                    textField.setEnabled(true);
                    checkBox.setSelection(false);
                    this.previousValues.put(groupKey, (String)config.get(groupKey));
                } else {
                    textField.setEnabled(false);
                    checkBox.setSelection(true);
                    this.previousValues.put(groupKey, " ");
                }
                textField.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent arg0) {
                        PropertiesSection.this.getPreviousValues().put(groupKey, ((Text)arg0.getSource()).getText());
                        PropertiesSection.this.setProperty(groupKey, ((Text)arg0.getSource()).getText());
                    }

                    public void focusGained(FocusEvent arg0) {
                    }
                });
                editor.grabHorizontal = true;
                editor.setEditor((Control)textField, configItem, 1);
                TableEditor boxEditor = new TableEditor(this.propertyTable);
                checkBox.pack();
                boxEditor.minimumWidth = checkBox.getSize().x;
                boxEditor.horizontalAlignment = 0x1000000;
                checkBox.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent evt) {
                        String defValue = PropertiesSection.this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition().getDefaultValue(groupKey);
                        if (checkBox.getSelection()) {
                            PropertiesSection.this.setProperty(groupKey, "");
                        } else {
                            PropertiesSection.this.previousValues = PropertiesSection.this.getPreviousValues();
                            if (!defValue.equals("") && ((String)PropertiesSection.this.previousValues.get(groupKey)).equals(" ")) {
                                PropertiesSection.this.setProperty(groupKey, defValue);
                            } else {
                                PropertiesSection.this.setProperty(groupKey, (String)PropertiesSection.this.previousValues.get(groupKey));
                            }
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent evt) {
                        this.widgetSelected(evt);
                    }
                });
                boxEditor.horizontalAlignment = 0x1000000;
                boxEditor.setEditor((Control)checkBox, configItem, 2);
            }
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.propGroupList.removeAll();
        ConfigurationDefinition config = this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition();
        TreeSet<String> groupNames = new TreeSet<String>();
        for (String key : config.getConfigurationKeys()) {
            String group;
            if (key.equals("storeComponentHistoryData") || groupNames.contains(group = config.getConfigurationMetaDataDefinition().getGuiGroupName(key))) continue;
            groupNames.add(group);
        }
        for (String group : groupNames) {
            this.propGroupList.add(group);
        }
        if (this.propGroupList.getItemCount() > 0) {
            this.propGroupList.select(0);
            this.groupSelection = 0;
        } else {
            TableItem nullItem = new TableItem(this.propertyTable, 0);
            nullItem.setText("");
            TableEditor editor = new TableEditor(this.propertyTable);
            Text nullText = new Text((Composite)this.propertyTable, 0);
            editor.grabHorizontal = true;
            editor.setEditor((Control)nullText, nullItem, 1);
        }
        this.updateSelection();
        ReadOnlyConfiguration readOnlyconfig = this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition().getReadOnlyConfiguration();
        String chosen = this.getProperty("chosenDeleteTempDirBehavior");
        if (chosen == null) {
            boolean deleteOnceActive = Boolean.parseBoolean(readOnlyconfig.getValue("deleteWorkingDirectoriesAfterWorkflowExecution"));
            boolean deleteAlwaysActive = Boolean.parseBoolean(readOnlyconfig.getValue("deleteWorkingDirectoriesAfterIteration"));
            if (deleteOnceActive) {
                this.setPropertyNotUndoable("chosenDeleteTempDirBehavior", "deleteWorkingDirectoriesAfterWorkflowExecution");
            } else if (deleteAlwaysActive) {
                this.setPropertyNotUndoable("chosenDeleteTempDirBehavior", "deleteWorkingDirectoriesAfterIteration");
            } else {
                this.setPropertyNotUndoable("chosenDeleteTempDirBehavior", "deleteWorkingDirectoriesNever");
            }
        }
    }

    public void refreshSection() {
        super.refreshSection();
        this.aboutToBeShown();
    }

    protected PropertiesSectionUpdater createUpdater() {
        return new PropertiesSectionUpdater();
    }

    private Map<String, String> getPreviousValues() {
        return this.previousValues;
    }

    protected class PropertiesSectionUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected PropertiesSectionUpdater() {
            super((WorkflowNodePropertySection)PropertiesSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            PropertiesSection.this.propertyTable.setRedraw(false);
            if (control instanceof Button) {
                Control[] controlArray = control.getParent().getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (c instanceof Text && c.getData("property.control").equals(control.getData("property.control"))) {
                        if (newValue.equals("")) {
                            ((Text)c).setEnabled(false);
                            ((Button)control).setSelection(true);
                        } else {
                            ((Text)c).setEnabled(true);
                            ((Button)control).setSelection(false);
                        }
                    }
                    ++n2;
                }
            }
            if (control instanceof Text) {
                ((Text)control).setText(newValue);
            }
            PropertiesSection.this.propertyTable.setRedraw(true);
        }
    }

    private final class PropertyGroupTableListener
    implements SelectionListener {
        private final List tabsList;

        private PropertyGroupTableListener(List tabsList) {
            this.tabsList = tabsList;
        }

        public void widgetSelected(SelectionEvent event) {
            int[] selectedItems = this.tabsList.getSelectionIndices();
            if (selectedItems.length == 1) {
                PropertiesSection.this.groupSelection = selectedItems[0];
            }
            PropertiesSection.this.updateSelection();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }
}

