/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.introduction;

import de.rcenvironment.core.gui.introduction.ProjectFile;
import de.rcenvironment.core.gui.introduction.WorkflowFile;
import de.rcenvironment.core.gui.wizards.exampleproject.RCEExampleProjectWizard;
import de.rcenvironment.core.utils.common.StringUtils;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class ShowExampleAction
implements IIntroAction {
    private static final String WORKFLOW_EXAMPLES_PROJECT_FIRST_WORKFLOW_NAME = "01_01_Hello_World.wf";
    private static final String WORKFLOW_EXAMPLES_PROJECT_FIRST_FOLDER_NAME = "01_First Steps";
    private static final String WORKFLOW_EXAMPLES_PROJECT_NAME = "Workflow Examples Project";
    private final Log log = LogFactory.getLog(this.getClass());

    public void run(IIntroSite site, Properties properties) {
        try {
            this.importWorkflowExamplesProject();
            this.loadFirstExampleWorkflowIntoWorkflowEditor();
            this.showWelcomeScreenOnSidePanel();
        }
        catch (CoreException e) {
            this.logExceptionAsWarning(e);
        }
    }

    private void showWelcomeScreenOnSidePanel() {
        IIntroPart intropart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        PlatformUI.getWorkbench().getIntroManager().setIntroStandby(intropart, true);
    }

    private void logExceptionAsWarning(CoreException e) {
        this.log.warn((Object)StringUtils.format((String)"Status: %s\nCause: %s", (Object[])new Object[]{e.getStatus(), e.getCause()}));
    }

    private void importWorkflowExamplesProject() throws CoreException {
        this.ensureExampleProjectExistsOnDisk();
        this.ensureExampleProjectExistsInWorkspace();
        this.ensureExampleProjectIsOpened();
    }

    private void ensureExampleProjectExistsOnDisk() {
        if (!this.exampleProjectExistsOnDisk()) {
            this.openWizardDialog();
        }
    }

    private void ensureExampleProjectExistsInWorkspace() throws CoreException {
        ProjectFile projectFile = this.getExampleProjectFile();
        IProjectDescription description = projectFile.getProjectDescription();
        IProject project = projectFile.getProjectFromWorkspaceByName();
        this.ensureProjectExists(description, project);
    }

    private void ensureExampleProjectIsOpened() throws CoreException {
        ProjectFile projectFile = this.getExampleProjectFile();
        IProject project = projectFile.getProjectFromWorkspaceByName();
        this.ensureProjectIsOpened(project);
    }

    private boolean exampleProjectExistsOnDisk() {
        ProjectFile projectFile = this.getExampleProjectFile();
        return projectFile.exists();
    }

    private ProjectFile getExampleProjectFile() {
        IPath absolutePathToWorkspace = this.getAbsolutePathToWorkspace();
        IPath absolutePathToExampleProjectFolder = absolutePathToWorkspace.append(WORKFLOW_EXAMPLES_PROJECT_NAME);
        ProjectFile absolutePathToProjectFile = ProjectFile.createForProjectFolder(absolutePathToExampleProjectFolder);
        return absolutePathToProjectFile;
    }

    private IPath getAbsolutePathToWorkspace() {
        URL workspaceURL = Platform.getInstanceLocation().getURL();
        this.throwExceptionIfURLIsNull(workspaceURL);
        return this.getAbsolutePathFromLocalURL(workspaceURL);
    }

    private void throwExceptionIfURLIsNull(URL workspaceURL) {
        if (workspaceURL == null) {
            throw new IllegalStateException("No workspace defined when importing Workflow Example Project.");
        }
    }

    private IPath getAbsolutePathFromLocalURL(URL workspaceURL) {
        String absolutePathToWorkspace = workspaceURL.getPath();
        if (this.isRunningOnWindows()) {
            return new Path(this.truncateFirstLetterFromString(absolutePathToWorkspace));
        }
        return new Path(absolutePathToWorkspace);
    }

    private boolean isRunningOnWindows() {
        return Platform.getOS().equals("win32");
    }

    private String truncateFirstLetterFromString(String value) {
        return value.substring(1);
    }

    private void ensureProjectExists(IProjectDescription description, IProject project) throws CoreException {
        if (!project.exists()) {
            project.create(description, null);
        }
    }

    private void ensureProjectIsOpened(IProject project) throws CoreException {
        if (!project.isOpen()) {
            project.open(null);
        }
    }

    private void openWizardDialog() {
        WizardDialog dialog = new WizardDialog(null, (IWizard)new RCEExampleProjectWizard());
        dialog.open();
    }

    private void loadFirstExampleWorkflowIntoWorkflowEditor() throws PartInitException {
        IPath absolutePathToWorkspace = this.getAbsolutePathToWorkspace();
        if (absolutePathToWorkspace == null) {
            this.log.warn((Object)"No platform instance location available");
            return;
        }
        IPath pathToFirstExampleWorkflow = absolutePathToWorkspace.append(WORKFLOW_EXAMPLES_PROJECT_NAME).append(WORKFLOW_EXAMPLES_PROJECT_FIRST_FOLDER_NAME).append(WORKFLOW_EXAMPLES_PROJECT_FIRST_WORKFLOW_NAME);
        WorkflowFile firstExampleWorkflowFile = WorkflowFile.fromPath(pathToFirstExampleWorkflow);
        if (firstExampleWorkflowFile.canBeLoadedIntoWorkflowEditor()) {
            IWorkbenchPage page = this.getWorkflowEditorPage();
            firstExampleWorkflowFile.loadIntoWorkbenchPage(page);
        }
    }

    private IWorkbenchPage getWorkflowEditorPage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }
}

