/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.cluster.view.internal;

import de.rcenvironment.core.gui.cluster.view.internal.ClusterConnectionInformation;
import de.rcenvironment.core.gui.cluster.view.internal.Messages;
import de.rcenvironment.core.utils.cluster.ClusterJobInformation;
import de.rcenvironment.core.utils.cluster.ClusterService;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClusterJobInformationModel {
    public static final String NOT_CONNECTED = Messages.notConnectedSelection;
    private static ClusterJobInformationModel instance = null;
    private Map<String, Set<ClusterJobInformation>> clusterJobInformationMap = new HashMap<String, Set<ClusterJobInformation>>();
    private Map<String, ClusterConnectionInformation> connectionInformationMap = new HashMap<String, ClusterConnectionInformation>();
    private Map<String, ClusterService> connectedClustersMap = new HashMap<String, ClusterService>();
    private String selectedConnectedConfigurationName = NOT_CONNECTED;

    protected static synchronized ClusterJobInformationModel getInstance() {
        if (instance == null) {
            instance = new ClusterJobInformationModel();
        }
        return instance;
    }

    protected synchronized Set<ClusterJobInformation> getClusterJobInformation() {
        if (this.selectedConnectedConfigurationName == null) {
            throw new IllegalArgumentException("no cluster set as selected");
        }
        if (this.selectedConnectedConfigurationName.equals(NOT_CONNECTED)) {
            return new HashSet<ClusterJobInformation>();
        }
        return this.clusterJobInformationMap.get(this.selectedConnectedConfigurationName);
    }

    protected synchronized void setSelectedConnectedConfigurationName(String configurationName) {
        if (this.connectedClustersMap.containsKey(configurationName) || configurationName.equals(NOT_CONNECTED)) {
            this.selectedConnectedConfigurationName = configurationName;
        }
    }

    protected synchronized void addClusterConnectionInformation(String configurationName, ClusterConnectionInformation connectionInformation) {
        this.connectionInformationMap.put(configurationName, connectionInformation);
    }

    protected synchronized ClusterConnectionInformation getClusterConnectionInformation(String configurationName) {
        if (!this.connectionInformationMap.containsKey(configurationName)) {
            throw new IllegalArgumentException("no cluster connection information available for: " + configurationName);
        }
        return this.connectionInformationMap.get(configurationName);
    }

    protected synchronized String[] getConnectedConfigurationNames() {
        if (this.connectedClustersMap.isEmpty()) {
            return new String[]{NOT_CONNECTED};
        }
        return this.connectedClustersMap.keySet().toArray(new String[this.connectedClustersMap.size()]);
    }

    protected synchronized void getUpdateFromCluster() throws IOException {
        if (this.selectedConnectedConfigurationName == null) {
            throw new IllegalArgumentException("no cluster set as selected");
        }
        if (!this.selectedConnectedConfigurationName.equals(NOT_CONNECTED)) {
            this.clusterJobInformationMap.put(this.selectedConnectedConfigurationName, this.connectedClustersMap.get(this.selectedConnectedConfigurationName).fetchClusterJobInformation());
            this.connectionInformationMap.get(this.selectedConnectedConfigurationName).setLastUpdate(new Date());
        }
    }

    protected synchronized void addConnectedCluster(String configurationName, ClusterService jobInformationService) {
        this.connectedClustersMap.put(configurationName, jobInformationService);
    }

    protected synchronized void removeConnectedCluster(String configurationName) {
        this.connectedClustersMap.remove(configurationName);
        this.connectionInformationMap.remove(configurationName);
        if (configurationName.equals(this.selectedConnectedConfigurationName)) {
            if (this.connectedClustersMap.isEmpty()) {
                this.setSelectedConnectedConfigurationName(NOT_CONNECTED);
            } else {
                this.setSelectedConnectedConfigurationName(this.connectedClustersMap.keySet().iterator().next());
            }
        }
    }

    protected ClusterService getClusterInformationService() {
        return this.connectedClustersMap.get(this.selectedConnectedConfigurationName);
    }
}

