/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.cluster.configuration.internal;

import de.rcenvironment.core.gui.cluster.configuration.internal.ClusterConnectionConfiguration;
import de.rcenvironment.core.gui.cluster.configuration.internal.ClusterConnectionConfigurationDialogsController;
import de.rcenvironment.core.gui.cluster.configuration.internal.Messages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ClusterConnectionConfigurationSelectionDialog
extends ElementListSelectionDialog {
    protected static final int NEW = 2;
    protected static final int EDIT = 3;
    protected static final int DELETE = 4;
    protected static final int CONNECT = 5;
    private ClusterConnectionConfigurationDialogsController controller;
    private Button editButton;
    private Button deleteButton;
    private Button connectButton;
    private ClusterConnectionConfiguration selectedConfiguration;
    private boolean hasInitialElements = false;

    public ClusterConnectionConfigurationSelectionDialog(Shell parent, ClusterConnectionConfigurationDialogsController controller) {
        super(parent, (ILabelProvider)new LabelProvider());
        this.setTitle(Messages.selectHostDialogTitle);
        this.setMessage(Messages.selectHostDialogMessage);
        Object[] configurations = controller.getStoredClusterConnectionConfigurations();
        this.setElements(configurations);
        this.hasInitialElements = configurations.length > 0;
        this.controller = controller;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button newButton = this.createButton(parent, 2, Messages.newButtonTitle, false);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClusterConnectionConfigurationSelectionDialog.this.controller.openNewClusterConnectionConfigurationDialog();
                ClusterConnectionConfigurationSelectionDialog.this.updateDialog();
            }
        });
        this.editButton = this.createButton(parent, 3, Messages.editButtonTitle, false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClusterConnectionConfigurationSelectionDialog.this.controller.openEditClusterConnectionConfigurationDialog((ClusterConnectionConfiguration)ClusterConnectionConfigurationSelectionDialog.this.getSelectedElements()[0]);
                ClusterConnectionConfigurationSelectionDialog.this.updateDialog();
            }
        });
        this.editButton.setEnabled(this.hasInitialElements);
        this.deleteButton = this.createButton(parent, 4, Messages.deleteButtonTitle, false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClusterConnectionConfigurationSelectionDialog.this.controller.openDeleteConfirmationDialog((ClusterConnectionConfiguration)ClusterConnectionConfigurationSelectionDialog.this.getSelectedElements()[0]);
                ClusterConnectionConfigurationSelectionDialog.this.updateDialog();
            }
        });
        this.deleteButton.setEnabled(this.hasInitialElements);
        this.connectButton = this.createButton(parent, 5, Messages.connectButtonTitle, true);
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClusterConnectionConfigurationSelectionDialog.this.setSelectedConfiguration();
                ClusterConnectionConfigurationSelectionDialog.this.setReturnCode(5);
                ClusterConnectionConfigurationSelectionDialog.this.close();
            }
        });
        this.connectButton.setEnabled(this.hasInitialElements);
        Button cancelButton = this.createButton(parent, 1, Messages.cancelButtonTitle, false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClusterConnectionConfigurationSelectionDialog.this.setReturnCode(1);
                ClusterConnectionConfigurationSelectionDialog.this.close();
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    protected void handleDefaultSelected() {
        this.setSelectedConfiguration();
        this.setReturnCode(5);
        this.close();
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        this.setSelectedConfiguration();
        this.updateButtons();
    }

    protected ClusterConnectionConfiguration getSelectedElement() {
        return this.selectedConfiguration;
    }

    private void setSelectedConfiguration() {
        this.selectedConfiguration = this.getSelectedElements().length > 0 ? (ClusterConnectionConfiguration)this.getSelectedElements()[0] : null;
    }

    private void updateDialog() {
        this.setListElements(this.controller.getStoredClusterConnectionConfigurations());
        this.updateButtons();
    }

    private void updateButtons() {
        ClusterConnectionConfiguration[] configurations = this.controller.getStoredClusterConnectionConfigurations();
        boolean enabled = configurations.length > 0 && this.getSelectedElements().length > 0;
        this.editButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
        this.connectButton.setEnabled(enabled);
    }
}

