/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.cluster.configuration.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.configuration.SecureStorageSection;
import de.rcenvironment.core.configuration.SecureStorageService;
import de.rcenvironment.core.gui.cluster.configuration.internal.Activator;
import de.rcenvironment.core.gui.cluster.configuration.internal.ClusterConnectionConfiguration;
import de.rcenvironment.core.gui.cluster.configuration.internal.ClusterConnectionConfigurationSelectionDialog;
import de.rcenvironment.core.gui.cluster.configuration.internal.CreateClusterConnectionConfigurationDialog;
import de.rcenvironment.core.gui.cluster.configuration.internal.EditClusterConnectionConfigurationDialog;
import de.rcenvironment.core.gui.cluster.configuration.internal.Messages;
import de.rcenvironment.core.gui.cluster.configuration.internal.PlainClusterConnectionConfiguration;
import de.rcenvironment.core.gui.cluster.configuration.internal.PlainClusterConnectionConfigurationImpl;
import de.rcenvironment.core.gui.cluster.configuration.internal.SensitiveClusterConnectionConfiguration;
import de.rcenvironment.core.gui.cluster.configuration.internal.SensitiveClusterConnectionConfigurationImpl;
import de.rcenvironment.core.gui.cluster.internal.ErrorMessageDialogFactory;
import de.rcenvironment.core.gui.cluster.view.internal.ClusterConnectionInformation;
import de.rcenvironment.core.utils.cluster.ClusterService;
import de.rcenvironment.core.utils.cluster.ClusterServiceManager;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;

public class ClusterConnectionConfigurationDialogsController {
    protected static final String SECURE_STORAGE_SECTION_ID = "core.cluster.monitoring";
    protected static final String SETTINGS_KEY_CONFIGURATIONS = "de.rcenvironment.core.gui.cluster.connectionconfigurations";
    protected static final String SETTINGS_KEY_PASSWORD_STORED = "de.rcenvironment.core.gui.cluster.connectionconfigurations.password";
    private static final String READING_STORED_CONFIGURATION_FAILED_WILL_BE_RESET = "Reading stored configurations failed. Will be reset";
    private static final String STORING_CONFIGURATION_FAILED = "Storing configuration failed";
    private static final Log LOGGER = LogFactory.getLog(ClusterConnectionConfigurationDialogsController.class);
    protected final IDialogSettings dialogSettings;
    private Composite parent;
    private ClusterService jobInformationService;
    private String clusterConfigurationName;
    private ServiceRegistryAccess serviceRegistryAccess;

    public ClusterConnectionConfigurationDialogsController(Composite parent) {
        this.parent = parent;
        this.dialogSettings = Activator.getInstance().getDialogSettings();
        this.serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
    }

    public ClusterConnectionInformation openClusterConnectionSelectionDialog() {
        ClusterConnectionInformation connectionInformation = null;
        ClusterConnectionConfigurationSelectionDialog dialog = new ClusterConnectionConfigurationSelectionDialog(this.parent.getShell(), this);
        dialog.create();
        switch (dialog.open()) {
            case 5: {
                ClusterConnectionConfiguration configuration = dialog.getSelectedElement();
                connectionInformation = this.connectToCluster(configuration);
                break;
            }
        }
        return connectionInformation;
    }

    public ClusterService getClusterJobInformationService() {
        return this.jobInformationService;
    }

    public String getClusterConfigurationName() {
        return this.clusterConfigurationName;
    }

    protected void openNewClusterConnectionConfigurationDialog() {
        CreateClusterConnectionConfigurationDialog dialog = new CreateClusterConnectionConfigurationDialog(this.parent.getShell(), this.getClusterConnectionConfigurationNames(this.getStoredClusterConnectionConfigurations()));
        dialog.create();
        switch (dialog.open()) {
            case 2: {
                this.createNewClusterConnectionConfiguration(dialog);
            }
        }
    }

    protected void openEditClusterConnectionConfigurationDialog(ClusterConnectionConfiguration configuration) {
        EditClusterConnectionConfigurationDialog dialog = new EditClusterConnectionConfigurationDialog(this.parent.getShell(), this.getClusterConnectionConfigurationNames(this.getStoredClusterConnectionConfigurations()), configuration);
        dialog.create();
        switch (dialog.open()) {
            case 2: {
                this.editClusterConnectionConfiguration(dialog, configuration);
            }
        }
    }

    protected void openDeleteConfirmationDialog(ClusterConnectionConfiguration configuration) {
        MessageDialog dialog = new MessageDialog(this.parent.getShell(), Messages.deleteConfirmDialogTitle, null, StringUtils.format((String)Messages.deleteConfirmDialogQuestion, (Object[])new Object[]{configuration}), 3, new String[]{Messages.yes, Messages.no}, 0);
        switch (dialog.open()) {
            case 0: {
                this.deleteClusterConnectionConfiguration(configuration);
            }
        }
    }

    private String openPasswordInputDialog() {
        String password = null;
        InputDialog dialog = new InputDialog(this.parent.getShell(), Messages.passwordDialogTitle, Messages.passwordDialogMessage, null, new IInputValidator(){

            public String isValid(String input) {
                if (input.isEmpty()) {
                    return "";
                }
                return null;
            }
        }){

            protected int getInputTextStyle() {
                return 0x400000;
            }
        };
        switch (dialog.open()) {
            case 0: {
                password = dialog.getValue();
                break;
            }
            case 1: {
                this.openClusterConnectionSelectionDialog();
                break;
            }
        }
        return password;
    }

    private ClusterConnectionInformation connectToCluster(ClusterConnectionConfiguration configuration) {
        ClusterConnectionInformation connectionInformation = null;
        if (configuration.getPassword() == null || configuration.getPassword().isEmpty()) {
            String password = this.openPasswordInputDialog();
            if (password != null) {
                configuration.setPassword(password);
            } else {
                return null;
            }
        }
        ClusterServiceManager clusterServiceManager = (ClusterServiceManager)this.serviceRegistryAccess.getService(ClusterServiceManager.class);
        this.jobInformationService = clusterServiceManager.retrieveSshBasedClusterService(configuration.getClusterQueuingSystem(), configuration.getPathToClusterQueuingSystemCommands(), configuration.getHost(), configuration.getPort(), configuration.getUsername(), configuration.getPassword());
        this.clusterConfigurationName = configuration.getConfigurationName();
        connectionInformation = new ClusterConnectionInformation(configuration, new Date());
        return connectionInformation;
    }

    private void createNewClusterConnectionConfiguration(CreateClusterConnectionConfigurationDialog dialog) {
        ClusterConnectionConfiguration newConfiguration = new ClusterConnectionConfiguration(dialog.getClusterQueuingSystem(), dialog.getPathsToClusterQueuingSystemCommands(), dialog.getHost(), dialog.getPort(), dialog.getUsername(), dialog.getConfigurationName(), dialog.getPassword());
        ClusterConnectionConfiguration[] configurations = this.getStoredClusterConnectionConfigurations();
        ClusterConnectionConfiguration[] newConfigurations = new ClusterConnectionConfiguration[configurations.length + 1];
        System.arraycopy(configurations, 0, newConfigurations, 0, configurations.length);
        newConfigurations[configurations.length] = newConfiguration;
        this.storeClusterConnectionConfigurations(newConfigurations, dialog.getPassword() != null && !dialog.getPassword().isEmpty());
    }

    private void editClusterConnectionConfiguration(EditClusterConnectionConfigurationDialog dialog, ClusterConnectionConfiguration oldConfiguration) {
        ClusterConnectionConfiguration newConfiguration = new ClusterConnectionConfiguration(dialog.getClusterQueuingSystem(), dialog.getPathsToClusterQueuingSystemCommands(), dialog.getHost(), dialog.getPort(), dialog.getUsername(), dialog.getConfigurationName(), dialog.getPassword());
        ClusterConnectionConfiguration[] configurations = this.getStoredClusterConnectionConfigurations();
        int i = 0;
        while (i < configurations.length) {
            if (configurations[i].getConfigurationName().equals(oldConfiguration.getConfigurationName())) {
                configurations[i] = newConfiguration;
                break;
            }
            ++i;
        }
        this.storeClusterConnectionConfigurations(configurations, dialog.getPassword() != null && !dialog.getPassword().isEmpty());
    }

    private void deleteClusterConnectionConfiguration(ClusterConnectionConfiguration configuration) {
        ClusterConnectionConfiguration[] configurations = this.getStoredClusterConnectionConfigurations();
        ClusterConnectionConfiguration[] newConfigurations = new ClusterConnectionConfiguration[configurations.length - 1];
        int j = 0;
        int i = 0;
        while (i < configurations.length) {
            if (!configurations[i].getConfigurationName().equals(configuration.getConfigurationName())) {
                newConfigurations[j++] = configurations[i];
            }
            ++i;
        }
        this.storeClusterConnectionConfigurations(newConfigurations, configuration.getPassword() != null && !configuration.getPassword().isEmpty());
    }

    private void storeClusterConnectionConfigurations(ClusterConnectionConfiguration[] configurations, boolean savePassword) {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            PlainClusterConnectionConfigurationImpl[] plainConfigurations = new PlainClusterConnectionConfigurationImpl[configurations.length];
            int i = 0;
            while (i < plainConfigurations.length) {
                plainConfigurations[i] = configurations[i].getPlainClusterConnectionConfiguration();
                ++i;
            }
            this.dialogSettings.put(SETTINGS_KEY_CONFIGURATIONS, mapper.writeValueAsString((Object)plainConfigurations));
            SecureStorageSection storageSection = ((SecureStorageService)this.serviceRegistryAccess.getService(SecureStorageService.class)).getSecureStorageSection(SECURE_STORAGE_SECTION_ID);
            if (savePassword) {
                this.dialogSettings.put(SETTINGS_KEY_PASSWORD_STORED, true);
                SensitiveClusterConnectionConfigurationImpl[] sensitiveConfigurations = new SensitiveClusterConnectionConfigurationImpl[configurations.length];
                int i2 = 0;
                while (i2 < sensitiveConfigurations.length) {
                    sensitiveConfigurations[i2] = configurations[i2].getSensitiveClusterConnectionConfiguration();
                    ++i2;
                }
                storageSection.store(SETTINGS_KEY_CONFIGURATIONS, mapper.writeValueAsString((Object)sensitiveConfigurations));
            } else {
                this.dialogSettings.put(SETTINGS_KEY_PASSWORD_STORED, false);
                storageSection.delete(SETTINGS_KEY_CONFIGURATIONS);
            }
        }
        catch (OperationFailureException | IOException e) {
            ErrorMessageDialogFactory.createMessageDialogForStoringConfigurationFailure(this.parent);
            LOGGER.error((Object)STORING_CONFIGURATION_FAILED, e);
        }
    }

    protected ClusterConnectionConfiguration[] getStoredClusterConnectionConfigurations() {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        ClusterConnectionConfiguration[] configurations = new ClusterConnectionConfiguration[]{};
        PlainClusterConnectionConfiguration[] plainConfigurations = new ClusterConnectionConfiguration[]{};
        SensitiveClusterConnectionConfiguration[] sensitiveConfigurations = new ClusterConnectionConfiguration[]{};
        try {
            SecureStorageSection storageSection;
            String configurationJsonString;
            if (this.dialogSettings.get(SETTINGS_KEY_CONFIGURATIONS) != null && !this.dialogSettings.get(SETTINGS_KEY_CONFIGURATIONS).isEmpty()) {
                String rawConfigurations = this.dialogSettings.get(SETTINGS_KEY_CONFIGURATIONS);
                plainConfigurations = (PlainClusterConnectionConfiguration[])mapper.readValue(rawConfigurations, PlainClusterConnectionConfiguration[].class);
            }
            if (this.dialogSettings.getBoolean(SETTINGS_KEY_PASSWORD_STORED) && !(configurationJsonString = (storageSection = ((SecureStorageService)this.serviceRegistryAccess.getService(SecureStorageService.class)).getSecureStorageSection(SECURE_STORAGE_SECTION_ID)).read(SETTINGS_KEY_CONFIGURATIONS, "")).isEmpty()) {
                sensitiveConfigurations = (SensitiveClusterConnectionConfiguration[])mapper.readValue(configurationJsonString, SensitiveClusterConnectionConfiguration[].class);
            }
            configurations = new ClusterConnectionConfiguration[plainConfigurations.length];
            int i = 0;
            while (i < configurations.length) {
                configurations[i] = new ClusterConnectionConfiguration(plainConfigurations[i].getClusterQueuingSystem(), plainConfigurations[i].getPathToClusterQueuingSystemCommands(), plainConfigurations[i].getHost(), plainConfigurations[i].getPort(), plainConfigurations[i].getUsername(), plainConfigurations[i].getConfigurationName());
                SensitiveClusterConnectionConfiguration[] sensitiveClusterConnectionConfigurationArray = sensitiveConfigurations;
                int n = sensitiveConfigurations.length;
                int n2 = 0;
                while (n2 < n) {
                    SensitiveClusterConnectionConfiguration sensitiveConfig = sensitiveClusterConnectionConfigurationArray[n2];
                    if (sensitiveConfig.getKey().equals(configurations[i].getKey())) {
                        configurations[i].setPassword(sensitiveConfig.getPassword());
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
        }
        catch (OperationFailureException | IOException e) {
            ErrorMessageDialogFactory.createMessageDialogForReadingConfigurationsFailure(this.parent);
            this.storeClusterConnectionConfigurations(configurations, true);
            LOGGER.error((Object)READING_STORED_CONFIGURATION_FAILED_WILL_BE_RESET, e);
        }
        return configurations;
    }

    private List<String> getClusterConnectionConfigurationNames(ClusterConnectionConfiguration[] configurations) {
        ArrayList<String> configurationNames = new ArrayList<String>();
        ClusterConnectionConfiguration[] clusterConnectionConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ClusterConnectionConfiguration configuration = clusterConnectionConfigurationArray[n2];
            configurationNames.add(configuration.getConfigurationName());
            ++n2;
        }
        return configurationNames;
    }
}

