/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.authorization;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationIdRules;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.management.api.PermissionMatrixChangeListener;
import de.rcenvironment.core.gui.authorization.AuthorizationConstants;
import de.rcenvironment.core.gui.authorization.AuthorizationGroupViewerComparator;
import de.rcenvironment.core.gui.authorization.AuthorizationLabelProvider;
import de.rcenvironment.core.gui.authorization.ExportGroupKeyAction;
import de.rcenvironment.core.gui.authorization.ImportGroupKeyAction;
import de.rcenvironment.core.gui.authorization.ShowAuthorizationGroupIdAction;
import de.rcenvironment.core.gui.authorization.ToolbarFilterWidget;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.SelectionProviderAction;

public class AuthorizationGroupDialog
extends TitleAreaDialog {
    private static final int DEFAULT_TEXTFIELD_WIDTH = 300;
    private static final String APOSTROPHE = "'";
    private static final String DOT = ".";
    private CreateGroupAction createGroupAction;
    private DeleteGroupAction deleteGroupAction;
    private ImportGroupKeyAction importGroupKeyAction;
    private ExportGroupKeyAction exportGroupKeyAction;
    private String groupNameForCreation;
    private TableViewer groupsTable;
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final ServiceRegistryPublisherAccess serviceRegistryAccess;
    private final AuthorizationService authorizationService;
    private final LocalComponentRegistrationService localComponentRegistrationService;
    private AuthorizationGroupViewerComparator comparator = new AuthorizationGroupViewerComparator();
    private ListSortAction sortActionAscending;
    private ListSortAction sortActionDescending;
    private ShowAuthorizationGroupIdAction showIdAction;

    public AuthorizationGroupDialog(Shell shell) {
        super(shell);
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        this.localComponentRegistrationService = (LocalComponentRegistrationService)this.serviceRegistryAccess.getService(LocalComponentRegistrationService.class);
        this.authorizationService = (AuthorizationService)this.serviceRegistryAccess.getService(AuthorizationService.class);
    }

    private void registerChangeListeners() {
        this.serviceRegistryAccess.registerService(PermissionMatrixChangeListener.class, (Object)new PermissionMatrixChangeListener(){

            public void onPermissionMatrixChanged(boolean accessGroupsChanged, boolean componentSelectorsChanged, boolean assignmentsChanged) {
                if (accessGroupsChanged) {
                    Display.getDefault().asyncExec(() -> {
                        if (!AuthorizationGroupDialog.this.groupsTable.getControl().isDisposed()) {
                            AuthorizationGroupDialog.this.groupsTable.refresh();
                        }
                    });
                }
            }
        });
    }

    public void create() {
        super.create();
        this.setTitle("Manage Authorization Groups");
        this.setMessage("Here you can create or delete authorization groups.\n To share group access it is possible to import or export group keys.", 1);
        this.getButton(0).setVisible(false);
        this.getButton(1).setText("Close");
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayout gridlayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridlayout);
        GridData compositeData = new GridData(1808);
        compositeData.heightHint = 400;
        composite.setLayoutData((Object)compositeData);
        ToolBar toolbar = new ToolBar(composite, 8519744);
        GridData toolbarGridData = new GridData(136);
        toolbar.setLayoutData((Object)toolbarGridData);
        Label placeholderGroupLabel = new Label(composite, 0);
        placeholderGroupLabel.setEnabled(false);
        ScrolledComposite scrollComposite = new ScrolledComposite(composite, 768);
        scrollComposite.setLayout((Layout)new GridLayout(1, false));
        scrollComposite.setMinSize(250, 200);
        scrollComposite.setLayoutData((Object)new GridData(1808));
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.groupsTable = new TableViewer((Composite)scrollComposite, 2562);
        this.groupsTable.getTable().setLayoutData((Object)new GridData(1808));
        this.groupsTable.getTable().addKeyListener((KeyListener)new GroupsListKeyListener());
        this.groupsTable.setContentProvider((IContentProvider)new GroupsListContentProvider());
        this.groupsTable.setLabelProvider((IBaseLabelProvider)new AuthorizationLabelProvider());
        this.groupsTable.setInput((Object)this.authorizationService.getDefaultAuthorizationObjects().accessGroupPublicInLocalNetwork());
        this.groupsTable.setComparator((ViewerComparator)this.comparator);
        scrollComposite.setContent(this.groupsTable.getControl());
        this.createActions();
        this.fillLocalToolbar(toolbar);
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayout buttonsCompositeLayout = new GridLayout(1, true);
        buttonsComposite.setLayout((Layout)buttonsCompositeLayout);
        GridData buttonsCompositeData = new GridData(16384, 128, false, true);
        buttonsComposite.setLayoutData((Object)buttonsCompositeData);
        ActionContributionItem createGroupContribution = new ActionContributionItem((IAction)this.createGroupAction);
        createGroupContribution.fill(buttonsComposite);
        Button createGroupButton = (Button)createGroupContribution.getWidget();
        createGroupButton.setLayoutData((Object)new GridData(768));
        ActionContributionItem deleteGroupContribution = new ActionContributionItem((IAction)this.deleteGroupAction);
        deleteGroupContribution.fill(buttonsComposite);
        Button deleteGroupButton = (Button)deleteGroupContribution.getWidget();
        deleteGroupButton.setLayoutData((Object)new GridData(768));
        ActionContributionItem importKeyContribution = new ActionContributionItem((IAction)this.importGroupKeyAction);
        importKeyContribution.fill(buttonsComposite);
        Button importGroupButton = (Button)importKeyContribution.getWidget();
        importGroupButton.setLayoutData((Object)new GridData(768));
        ActionContributionItem exportKeyContribution = new ActionContributionItem((IAction)this.exportGroupKeyAction);
        exportKeyContribution.fill(buttonsComposite);
        Button exportGroupButton = (Button)exportKeyContribution.getWidget();
        exportGroupButton.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText("Note: Authorization groups for publishing components over\nUplink Connections must have the name prefix 'external_'.");
        this.registerChangeListeners();
        this.hookContextMenu();
        scrollComposite.setFocus();
        return composite;
    }

    private void fillLocalToolbar(ToolBar toolbar) {
        new ToolbarFilterWidget((StructuredViewer)this.groupsTable, "Filter groups...").fill(toolbar, 0);
        new ActionContributionItem((IAction)this.sortActionAscending).fill(toolbar, 1);
        new ActionContributionItem((IAction)this.sortActionDescending).fill(toolbar, 2);
    }

    private void createActions() {
        this.sortActionAscending = new ListSortAction(1);
        this.sortActionAscending.setImageDescriptor(AuthorizationConstants.SORT_ASC);
        this.sortActionAscending.setText("Sort alphabetically ascending");
        this.sortActionDescending = new ListSortAction(-1);
        this.sortActionDescending.setImageDescriptor(AuthorizationConstants.SORT_DESC);
        this.sortActionDescending.setText("Sort alphabetically descending");
        this.importGroupKeyAction = new ImportGroupKeyAction(this.authorizationService);
        this.exportGroupKeyAction = new ExportGroupKeyAction((ISelectionProvider)this.groupsTable, this.authorizationService);
        this.exportGroupKeyAction.setEnabled(false);
        this.createGroupAction = new CreateGroupAction();
        this.deleteGroupAction = new DeleteGroupAction((ISelectionProvider)this.groupsTable);
        this.deleteGroupAction.setEnabled(false);
        this.showIdAction = new ShowAuthorizationGroupIdAction((StructuredViewer)this.groupsTable);
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.groupsTable.getTable());
        menuManager.add((IAction)this.sortActionAscending);
        menuManager.add((IAction)this.sortActionDescending);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.createGroupAction);
        menuManager.add((IAction)this.deleteGroupAction);
        menuManager.add((IAction)this.importGroupKeyAction);
        menuManager.add((IAction)this.exportGroupKeyAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.showIdAction);
        this.groupsTable.getTable().setMenu(menu);
    }

    private final class CreateGroupAction
    extends Action {
        private CreateGroupAction() {
            super("Create Group...");
        }

        public void run() {
            Display display = Display.getDefault();
            Shell shell = display.getActiveShell();
            CreateGroupDialog createGroupDialog = new CreateGroupDialog(shell, AuthorizationGroupDialog.this);
            int id = createGroupDialog.open();
            if (id == 0) {
                try {
                    AuthorizationGroupDialog.this.authorizationService.createLocalGroup(AuthorizationGroupDialog.this.groupNameForCreation);
                }
                catch (OperationFailureException operationFailureException) {
                    AuthorizationGroupDialog.this.log.warn((Object)("Failed to create authorization group '" + AuthorizationGroupDialog.this.groupNameForCreation + AuthorizationGroupDialog.APOSTROPHE + AuthorizationGroupDialog.DOT));
                }
            }
        }
    }

    private class CreateGroupDialog
    extends Dialog {
        private static final int VALIDATION_LABEL_HEIGHT_HINT = 55;
        private AuthorizationGroupDialog view;
        private Text groupNameTextfield;

        protected CreateGroupDialog(Shell parentShell, AuthorizationGroupDialog view) {
            super(parentShell);
            this.view = null;
            this.view = view;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Create Authorization Group");
        }

        protected void okPressed() {
            this.view.groupNameForCreation = this.groupNameTextfield.getText();
            super.okPressed();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(0).setEnabled(false);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            GridLayout containerLayout = new GridLayout(2, false);
            container.setLayout((Layout)containerLayout);
            Label groupNameLabel = new Label(container, 0);
            groupNameLabel.setText("Group name: ");
            this.groupNameTextfield = new Text(container, 2048);
            GridData groupNameGridData = new GridData(4, 4, true, false);
            groupNameGridData.widthHint = 300;
            this.groupNameTextfield.setLayoutData((Object)groupNameGridData);
            Composite validationMessage = new Composite(container, 0);
            GridData validationMessageGridData = new GridData(4, 4, true, false);
            validationMessageGridData.horizontalSpan = 2;
            validationMessage.setLayoutData((Object)validationMessageGridData);
            validationMessage.setLayout((Layout)new GridLayout(2, false));
            validationMessage.setVisible(false);
            Label validationIconLabel = new Label(validationMessage, 0);
            validationIconLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ERROR_16));
            validationIconLabel.setLayoutData((Object)new GridData(1, 1, false, true));
            Label validationTextLabel = new Label(validationMessage, 64);
            GridData validationLabelGridData = new GridData(4, 0, true, false);
            validationLabelGridData.widthHint = 300;
            validationLabelGridData.heightHint = 55;
            validationTextLabel.setLayoutData((Object)validationLabelGridData);
            this.groupNameTextfield.addModifyListener(event -> {
                String input = this.groupNameTextfield.getText();
                Optional validationError = AuthorizationIdRules.validateAuthorizationGroupId((String)input);
                if (!input.isEmpty() && validationError.isPresent()) {
                    validationTextLabel.setText(StringUtils.format((String)"The chosen group name is not valid.\n%s.", (Object[])new Object[]{((String)validationError.get()).replaceAll("&", "&&")}));
                    validationMessage.setVisible(true);
                } else {
                    validationTextLabel.setText("");
                    validationMessage.setVisible(false);
                }
                this.getButton(0).setEnabled(!validationError.isPresent());
            });
            return container;
        }
    }

    private final class DeleteGroupAction
    extends SelectionProviderAction {
        private DeleteGroupAction(ISelectionProvider selectionProvider) {
            super(selectionProvider, "Delete Group...");
        }

        public void run() {
            IStructuredSelection selection = this.getStructuredSelection();
            if (selection.isEmpty()) {
                return;
            }
            MessageBox warning = new MessageBox(AuthorizationGroupDialog.this.getParentShell(), 296);
            StringBuilder message = new StringBuilder("Do you really want to delete ");
            if (selection.size() == 1 && selection.getFirstElement() instanceof AuthorizationAccessGroup) {
                message.append(StringUtils.format((String)"group '%s'", (Object[])new Object[]{((AuthorizationAccessGroup)selection.getFirstElement()).getDisplayName()}));
            } else {
                message.append("the selected groups");
            }
            message.append("?\nPlease note that all associations to components will be discarded, too.");
            warning.setMessage(message.toString());
            warning.setText("Delete Group");
            int id = warning.open();
            if (id == 32) {
                Iterator i = selection.iterator();
                i.forEachRemaining(o -> {
                    if (o instanceof AuthorizationAccessGroup) {
                        AuthorizationGroupDialog.this.authorizationService.deleteLocalGroupData((AuthorizationAccessGroup)o);
                    }
                });
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                this.setEnabled(true);
                Iterator i = selection.iterator();
                i.forEachRemaining(o -> {
                    if (o instanceof AuthorizationAccessGroup && AuthorizationGroupDialog.this.authorizationService.isPublicAccessGroup((AuthorizationAccessGroup)o)) {
                        this.setEnabled(false);
                    }
                });
                return;
            }
            this.setEnabled(false);
        }
    }

    private final class GroupsListContentProvider
    implements IStructuredContentProvider {
        private GroupsListContentProvider() {
        }

        public Object[] getElements(Object object) {
            ArrayList<AuthorizationAccessGroup> groups = new ArrayList<AuthorizationAccessGroup>();
            for (AuthorizationAccessGroup group : AuthorizationGroupDialog.this.localComponentRegistrationService.listAvailableAuthorizationAccessGroups()) {
                groups.add(group);
            }
            return groups.toArray();
        }
    }

    private final class GroupsListKeyListener
    extends KeyAdapter {
        private GroupsListKeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 127 && AuthorizationGroupDialog.this.deleteGroupAction.isEnabled()) {
                AuthorizationGroupDialog.this.deleteGroupAction.run();
            }
        }
    }

    private final class ListSortAction
    extends Action {
        private int direction;

        protected ListSortAction(int direction) {
            this.direction = direction;
            this.setChecked(AuthorizationGroupDialog.this.comparator.getDirection() == direction);
        }

        public void run() {
            AuthorizationGroupDialog.this.comparator.setDirection(this.direction);
            AuthorizationGroupDialog.this.groupsTable.refresh();
            AuthorizationGroupDialog.this.sortActionAscending.setChecked(this.direction == 1);
            AuthorizationGroupDialog.this.sortActionDescending.setChecked(this.direction == -1);
        }
    }
}

