/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.update.api;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public final class PersistentComponentDescriptionUpdaterUtils {
    public static final String EP_IDENTIFIER = "epIdentifier";
    private static final String INITIAL = "initial";
    private static final String REQUIRED = "required";
    private static final String CONFIGURATION = "configuration";
    private static final String USAGE = "usage";
    private static final String NAME = "name";
    private static final String STATIC_OUTPUTS = "staticOutputs";
    private static final String STATIC_INPUTS = "staticInputs";
    private static final String DYNAMIC_INPUTS = "dynamicInputs";
    private static final String DYNAMIC_OUTPUTS = "dynamicOutputs";
    private static final String METADATA = "metadata";
    private static final String DIRECTORY = "Directory";
    private static final String DATATYPE = "datatype";
    private static final String IDENTIFIER = "identifier";
    private static ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();

    private PersistentComponentDescriptionUpdaterUtils() {
    }

    public static PersistentComponentDescription updateAllDynamicEndpointsToIdentifier(String direction, String identifier, PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode dynEndpoints = node.get(direction);
        if (dynEndpoints != null) {
            for (JsonNode endpoint : dynEndpoints) {
                if (endpoint.get(EP_IDENTIFIER) != null && !endpoint.get(EP_IDENTIFIER).equals((Object)"null") && !endpoint.get(EP_IDENTIFIER).isNull()) continue;
                ((ObjectNode)endpoint).remove(EP_IDENTIFIER);
                ((ObjectNode)endpoint).set(EP_IDENTIFIER, (JsonNode)TextNode.valueOf((String)identifier));
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription removeOuterLoopDoneEndpoints(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        PersistentComponentDescriptionUpdaterUtils.removeOuterLoopDoneEndpoint(node, STATIC_OUTPUTS, NAME, "Outer loop done");
        PersistentComponentDescriptionUpdaterUtils.removeOuterLoopDoneEndpoint(node, DYNAMIC_INPUTS, EP_IDENTIFIER, "outerLoopDone");
        return new PersistentComponentDescription(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node));
    }

    private static void removeOuterLoopDoneEndpoint(JsonNode node, String endpointGroup, String identifyingKey, String identifyingValue) {
        if (node.has(endpointGroup)) {
            ArrayNode endpointsJsonNode = (ArrayNode)node.get(endpointGroup);
            Iterator elements = endpointsJsonNode.elements();
            while (elements.hasNext()) {
                ObjectNode endpointJsonNode = (ObjectNode)elements.next();
                if (!endpointJsonNode.get(identifyingKey).textValue().equals(identifyingValue)) continue;
                elements.remove();
                break;
            }
        }
    }

    public static PersistentComponentDescription removeEndpointCharacterInfoFromMetaData(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData(node, STATIC_INPUTS);
        PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData(node, STATIC_OUTPUTS);
        PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData(node, DYNAMIC_INPUTS);
        PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData(node, DYNAMIC_OUTPUTS);
        return new PersistentComponentDescription(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node));
    }

    private static void removeEndpointCharacterInfoFromMetaData(JsonNode node, String endpointGroup) {
        if (node.has(endpointGroup)) {
            ArrayNode endpointsJsonNode = (ArrayNode)node.get(endpointGroup);
            Iterator elements = endpointsJsonNode.elements();
            block0: while (elements.hasNext()) {
                JsonNode endpointJsonNode = (JsonNode)elements.next();
                if (!endpointJsonNode.has(METADATA)) continue;
                JsonNode metaDataJsonNode = endpointJsonNode.get(METADATA);
                Iterator metaDataFields = metaDataJsonNode.fields();
                while (metaDataFields.hasNext()) {
                    Map.Entry nextMetaDataField = (Map.Entry)metaDataFields.next();
                    if (!((String)nextMetaDataField.getKey()).equals("loopEndpointType_5e0ed1cd")) continue;
                    metaDataFields.remove();
                    continue block0;
                }
            }
        }
    }

    public static PersistentComponentDescription reassignEndpointIdentifiers(PersistentComponentDescription description, String endpointGroup, String epIdentifier, String epIdentifierToReplace, String epNameSuffix) throws JsonProcessingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        if (node.has(endpointGroup)) {
            ArrayNode endpointsJsonNode = (ArrayNode)node.get(endpointGroup);
            Iterator elements = endpointsJsonNode.elements();
            while (elements.hasNext()) {
                JsonNode endpointJsonNode = (JsonNode)elements.next();
                if (!endpointJsonNode.has(EP_IDENTIFIER) || !endpointJsonNode.get(EP_IDENTIFIER).textValue().equals(epIdentifier) || !endpointJsonNode.get(NAME).textValue().endsWith(epNameSuffix)) continue;
                ((ObjectNode)endpointJsonNode).put(EP_IDENTIFIER, epIdentifierToReplace);
            }
        }
        return new PersistentComponentDescription(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateFaultToleranceOfLoopDriver(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode configJsonNode = node.get(CONFIGURATION);
        if (configJsonNode instanceof ObjectNode) {
            String configKeyFinallyFailIfDiscarded;
            String configKeyFailLoopOnly;
            String configKeyMaxRerunBeforeDiscard;
            String configKeyMaxRerunBeforeFail;
            ObjectNode configObjectNode = (ObjectNode)configJsonNode;
            String confgKeyFaultToleranceNAV = "loopFaultTolerance_5e0ed1cd";
            if (configObjectNode.has(confgKeyFaultToleranceNAV)) {
                String faultToleranceNAV = configObjectNode.get(confgKeyFaultToleranceNAV).textValue();
                configObjectNode.put(confgKeyFaultToleranceNAV, "Fail");
                configObjectNode.put("faultTolerance-NAV_5e0ed1cd", faultToleranceNAV);
            }
            if (configObjectNode.has(configKeyMaxRerunBeforeFail = "loopRerunAndFail_5e0ed1cd")) {
                String faultToleranceNAV = configObjectNode.get(configKeyMaxRerunBeforeFail).textValue();
                configObjectNode.remove(configKeyMaxRerunBeforeFail);
                configObjectNode.put("maxRerunBeforeFail-NAV_5e0ed1cd", faultToleranceNAV);
            }
            if (configObjectNode.has(configKeyMaxRerunBeforeDiscard = "loopRerunAndDiscard_5e0ed1cd")) {
                String faultToleranceNAV = configObjectNode.get(configKeyMaxRerunBeforeDiscard).textValue();
                configObjectNode.remove(configKeyMaxRerunBeforeDiscard);
                configObjectNode.put("maxRerunBeforeDiscard-NAV_5e0ed1cd", faultToleranceNAV);
            }
            if (configObjectNode.has(configKeyFailLoopOnly = "failLoop_5e0ed1cd")) {
                String faultToleranceNAV = configObjectNode.get(configKeyFailLoopOnly).textValue();
                configObjectNode.remove(configKeyFailLoopOnly);
                configObjectNode.put("failLoopOnly-NAV_5e0ed1cd", faultToleranceNAV);
            }
            if (configObjectNode.has(configKeyFinallyFailIfDiscarded = "finallyFail_5e0ed1cd")) {
                String faultToleranceNAV = configObjectNode.get(configKeyFinallyFailIfDiscarded).textValue();
                configObjectNode.remove(configKeyFinallyFailIfDiscarded);
                configObjectNode.put("finallyFailIfDiscarded-NAV_5e0ed1cd", faultToleranceNAV);
            }
        }
        return new PersistentComponentDescription(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateSchedulingInformation(PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser jsonParser = jsonFactory.createParser(description.getComponentDescriptionAsString());
        JsonNode node = (JsonNode)mapper.readTree(jsonParser);
        jsonParser.close();
        PersistentComponentDescriptionUpdaterUtils.updateInputNode(node.get(DYNAMIC_INPUTS));
        PersistentComponentDescriptionUpdaterUtils.updateInputNode(node.get(STATIC_INPUTS));
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        return description;
    }

    public static PersistentComponentDescription updateIsNestedLoop(PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser jsonParser = jsonFactory.createParser(description.getComponentDescriptionAsString());
        JsonNode node = (JsonNode)mapper.readTree(jsonParser);
        jsonParser.close();
        String oldConfigKey = "isNestedLoop";
        ObjectNode configurationsNode = (ObjectNode)node.get(CONFIGURATION);
        if (configurationsNode != null && configurationsNode.has(oldConfigKey)) {
            boolean isNestedLoop = configurationsNode.get(oldConfigKey).asBoolean();
            configurationsNode.remove(oldConfigKey);
            configurationsNode.put("isNestedLoop_5e0ed1cd", isNestedLoop);
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        return description;
    }

    private static void updateInputNode(JsonNode inputNode) {
        block14: {
            if (inputNode == null) break block14;
            Iterator nodeIterator = inputNode.elements();
            while (nodeIterator.hasNext()) {
                String usage;
                JsonNode dynInputNode = (JsonNode)nodeIterator.next();
                ObjectNode jsonNode = (ObjectNode)dynInputNode.get(METADATA);
                JsonNode usageJsonNode = jsonNode.get(USAGE);
                if (usageJsonNode == null) continue;
                switch (usage = usageJsonNode.textValue()) {
                    case "required": {
                        jsonNode.put("inputHandling_73b1056e", EndpointDefinition.InputDatumHandling.Single.name());
                        jsonNode.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
                        break;
                    }
                    case "initial": {
                        jsonNode.put("inputHandling_73b1056e", EndpointDefinition.InputDatumHandling.Constant.name());
                        jsonNode.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.Required.name());
                        break;
                    }
                    case "optional": {
                        jsonNode.put("inputHandling_73b1056e", EndpointDefinition.InputDatumHandling.Single.name());
                        jsonNode.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.NotRequired.name());
                        break;
                    }
                }
                jsonNode.remove(USAGE);
            }
        }
    }

    public static PersistentComponentDescription addStaticInput(PersistentComponentDescription description, String inputName) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode staticInputs = (ArrayNode)node.get(STATIC_INPUTS);
        if (staticInputs == null) {
            staticInputs = JsonNodeFactory.instance.arrayNode();
            ((ObjectNode)node).set(STATIC_INPUTS, (JsonNode)staticInputs);
        }
        ObjectNode staticCPACSIn = JsonNodeFactory.instance.objectNode();
        ObjectNode metaDataNode = JsonNodeFactory.instance.objectNode();
        metaDataNode.set(USAGE, (JsonNode)TextNode.valueOf((String)INITIAL));
        staticCPACSIn.set(NAME, (JsonNode)TextNode.valueOf((String)inputName));
        staticCPACSIn.set(DATATYPE, (JsonNode)TextNode.valueOf((String)"FileReference"));
        staticCPACSIn.set(METADATA, (JsonNode)metaDataNode);
        staticCPACSIn.set(IDENTIFIER, (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
        staticInputs.add((JsonNode)staticCPACSIn);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription addStaticOutput(PersistentComponentDescription description, String outputName, String dataType) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode staticOutputs = (ArrayNode)node.get(STATIC_OUTPUTS);
        if (staticOutputs == null) {
            staticOutputs = JsonNodeFactory.instance.arrayNode();
            ((ObjectNode)node).set(STATIC_OUTPUTS, (JsonNode)staticOutputs);
        }
        ObjectNode newOutput = JsonNodeFactory.instance.objectNode();
        newOutput.set(NAME, (JsonNode)TextNode.valueOf((String)outputName));
        newOutput.set(DATATYPE, (JsonNode)TextNode.valueOf((String)dataType));
        newOutput.set(METADATA, (JsonNode)JsonNodeFactory.instance.objectNode());
        newOutput.set(IDENTIFIER, (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
        staticOutputs.add((JsonNode)newOutput);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription addStaticOutput(PersistentComponentDescription description, String outputName) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode staticOutputs = (ArrayNode)node.get(STATIC_OUTPUTS);
        if (staticOutputs == null) {
            staticOutputs = JsonNodeFactory.instance.arrayNode();
            ((ObjectNode)node).set(STATIC_OUTPUTS, (JsonNode)staticOutputs);
        }
        ObjectNode staticCPACSOut = JsonNodeFactory.instance.objectNode();
        staticCPACSOut.set(NAME, (JsonNode)TextNode.valueOf((String)outputName));
        staticCPACSOut.set(DATATYPE, (JsonNode)TextNode.valueOf((String)"FileReference"));
        staticCPACSOut.set(METADATA, (JsonNode)JsonNodeFactory.instance.objectNode());
        staticCPACSOut.set(IDENTIFIER, (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
        staticOutputs.add((JsonNode)staticCPACSOut);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateConsumeCPACSFlag(PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode staticInputs = (ArrayNode)node.get(STATIC_INPUTS);
        ObjectNode configuration = (ObjectNode)node.get(CONFIGURATION);
        if (configuration.get("consumeCPACS") != null && Boolean.valueOf(configuration.get("consumeCPACS").textValue()).booleanValue()) {
            for (JsonNode staticInput : staticInputs) {
                if (staticInput.get(NAME).textValue().equals(DIRECTORY)) continue;
                ObjectNode metadata = (ObjectNode)staticInput.get(METADATA);
                metadata.set(USAGE, (JsonNode)TextNode.valueOf((String)REQUIRED));
            }
        }
        configuration.remove("consumeCPACS");
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateDynamicInputsOptional(PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode dynamicInputs = (ArrayNode)node.get(DYNAMIC_INPUTS);
        if (dynamicInputs != null) {
            for (JsonNode dynamicInput : dynamicInputs) {
                if (dynamicInput.get(NAME).textValue().equals(DIRECTORY)) continue;
                ((ObjectNode)dynamicInput.get(METADATA)).set(USAGE, (JsonNode)TextNode.valueOf((String)"optional"));
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateConsumeDirectoryFlag(PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ArrayNode dynamicInputs = (ArrayNode)node.get(DYNAMIC_INPUTS);
        ObjectNode configuration = (ObjectNode)node.get(CONFIGURATION);
        if (configuration.get("consumeDirectory") != null && Boolean.valueOf(configuration.get("consumeDirectory").textValue()).booleanValue()) {
            for (JsonNode dynamicInput : dynamicInputs) {
                if (!dynamicInput.get(NAME).textValue().equals(DIRECTORY)) continue;
                ObjectNode metadata = (ObjectNode)dynamicInput.get(METADATA);
                metadata.set(USAGE, (JsonNode)TextNode.valueOf((String)REQUIRED));
            }
        } else if (configuration.get("consumeDirectory") != null && !configuration.get("consumeDirectory").booleanValue()) {
            for (JsonNode dynamicInput : dynamicInputs) {
                if (!dynamicInput.get(NAME).textValue().equals(DIRECTORY)) continue;
                ObjectNode metadata = (ObjectNode)dynamicInput.get(METADATA);
                metadata.set(USAGE, (JsonNode)TextNode.valueOf((String)INITIAL));
            }
        }
        configuration.remove("consumeDirectory");
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }

    public static PersistentComponentDescription updateDirectoryEndpointId(String direction, PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode dynEndpoints = node.get(direction);
        if (dynEndpoints != null) {
            for (JsonNode endpoint : dynEndpoints) {
                if (!endpoint.get(NAME).textValue().equals(DIRECTORY)) continue;
                ((ObjectNode)endpoint).remove(EP_IDENTIFIER);
                ((ObjectNode)endpoint).set(EP_IDENTIFIER, (JsonNode)TextNode.valueOf((String)"directory"));
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        return new PersistentComponentDescription(writer.writeValueAsString((Object)node));
    }
}

