/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.messaging.internal.InternalMessagingException;
import de.rcenvironment.core.communication.rpc.ServiceCallRequest;
import de.rcenvironment.core.communication.rpc.ServiceCallResult;
import de.rcenvironment.core.communication.rpc.spi.RemoteServiceCallHandlerService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReliableRPCStreamReceiver {
    private final String streamId;
    private final RemoteServiceCallHandlerService serviceCallHandlerService;
    private final AtomicInteger concurrencyCounter = new AtomicInteger(0);
    private final boolean verboseRequestLoggingEnabled = DebugSettings.getVerboseLoggingEnabled((String)"RemoteServiceCalls");
    private final Object sequentialHandlingLock = new Object();
    private ServiceCallResult lastProcessedResult;
    private long lastProcessedSequenceNumber;
    private final Log log = LogFactory.getLog(this.getClass());

    public ReliableRPCStreamReceiver(String streamId, RemoteServiceCallHandlerService serviceCallHandlerService) {
        this.streamId = streamId;
        this.serviceCallHandlerService = Objects.requireNonNull(serviceCallHandlerService);
    }

    public String getStreamId() {
        return this.streamId;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ServiceCallResult handle(ServiceCallRequest serviceCallRequest) throws InternalMessagingException {
        int concurrencyLevel;
        long newSequenceNumber = serviceCallRequest.getSequenceNumber();
        if (newSequenceNumber <= 0L) {
            throw new IllegalStateException();
        }
        if (this.verboseRequestLoggingEnabled && (concurrencyLevel = this.concurrencyCounter.incrementAndGet()) > 1) {
            this.log.debug((Object)StringUtils.format((String)"Handling remote rRPC %d of stream %s, calling %s.%s() at a concurrent call count of %d", (Object[])new Object[]{newSequenceNumber, serviceCallRequest.getReliableRPCStreamId(), serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName(), concurrencyLevel}));
        }
        try {
            block12: {
                block11: {
                    Object object = this.sequentialHandlingLock;
                    // MONITORENTER : object
                    if (newSequenceNumber != this.lastProcessedSequenceNumber) break block11;
                    this.log.debug((Object)StringUtils.format((String)"Received repeated request for rRPC %d of stream %s, calling %s.%s(); sending the cached result again, as it was probably lost in transmission", (Object[])new Object[]{newSequenceNumber, serviceCallRequest.getReliableRPCStreamId(), serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName()}));
                    ServiceCallResult serviceCallResult = this.lastProcessedResult;
                    // MONITOREXIT : object
                    if (!this.verboseRequestLoggingEnabled) return serviceCallResult;
                    this.concurrencyCounter.decrementAndGet();
                    {
                        catch (Throwable throwable) {
                            // MONITOREXIT : object
                            throw throwable;
                        }
                    }
                    this.log.debug((Object)StringUtils.format((String)"Completed incoming rRPC request %d of stream %s", (Object[])new Object[]{serviceCallRequest.getSequenceNumber(), this.streamId}));
                    return serviceCallResult;
                }
                if (newSequenceNumber != this.lastProcessedSequenceNumber + 1L) break block12;
                if (this.verboseRequestLoggingEnabled) {
                    this.log.debug((Object)StringUtils.format((String)"Processing sequential remote rRPC %d of stream %s, calling %s.%s()", (Object[])new Object[]{newSequenceNumber, serviceCallRequest.getReliableRPCStreamId(), serviceCallRequest.getServiceName(), serviceCallRequest.getMethodName()}));
                }
                ServiceCallResult result = this.serviceCallHandlerService.dispatchToLocalService(serviceCallRequest);
                this.lastProcessedSequenceNumber = newSequenceNumber;
                this.lastProcessedResult = result;
                ServiceCallResult serviceCallResult = result;
                // MONITOREXIT : object
                if (!this.verboseRequestLoggingEnabled) return serviceCallResult;
                this.concurrencyCounter.decrementAndGet();
                this.log.debug((Object)StringUtils.format((String)"Completed incoming rRPC request %d of stream %s", (Object[])new Object[]{serviceCallRequest.getSequenceNumber(), this.streamId}));
                return serviceCallResult;
            }
            throw new IllegalStateException("Unexpected state: new sequence number is " + newSequenceNumber + ", while the last processed one is " + this.lastProcessedSequenceNumber);
        }
        catch (Throwable throwable) {
            if (!this.verboseRequestLoggingEnabled) throw throwable;
            this.concurrencyCounter.decrementAndGet();
            this.log.debug((Object)StringUtils.format((String)"Completed incoming rRPC request %d of stream %s", (Object[])new Object[]{serviceCallRequest.getSequenceNumber(), this.streamId}));
            throw throwable;
        }
    }
}

