/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.nodeproperties.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.nodeproperties.NodeProperty;
import de.rcenvironment.core.communication.nodeproperties.internal.CompositeNodePropertyKey;
import de.rcenvironment.core.communication.nodeproperties.internal.NodePropertyImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodePropertiesRegistry {
    private final Map<CompositeNodePropertyKey, NodePropertyImpl> knowledgeMap = new HashMap<CompositeNodePropertyKey, NodePropertyImpl>();
    private final Map<String, String> mostRecentSessionIds = new HashMap<String, String>();
    private final Log log = LogFactory.getLog(this.getClass());

    public Map<String, String> getNodeProperties(InstanceNodeSessionId nodeId) {
        String nodeIdString = nodeId.getInstanceNodeSessionIdString();
        HashMap<String, String> result = new HashMap<String, String>();
        for (NodePropertyImpl entry : this.knowledgeMap.values()) {
            CompositeNodePropertyKey key = entry.getCompositeKey();
            if (!key.getInstanceNodeSessionIdString().equals(nodeIdString)) continue;
            result.put(key.getDataKey(), entry.getValue());
        }
        return result;
    }

    public NodeProperty getNodeProperty(InstanceNodeSessionId nodeId, String dataKey) {
        CompositeNodePropertyKey ckey = new CompositeNodePropertyKey(nodeId.getInstanceNodeSessionIdString(), dataKey);
        return this.knowledgeMap.get(ckey);
    }

    public String getNodePropertyValue(InstanceNodeSessionId nodeId, String dataKey) {
        NodeProperty property = this.getNodeProperty(nodeId, dataKey);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public Map<InstanceNodeSessionId, Map<String, String>> getAllNodeProperties() {
        HashMap<InstanceNodeSessionId, Map<String, String>> result = new HashMap<InstanceNodeSessionId, Map<String, String>>();
        for (NodePropertyImpl entry : this.knowledgeMap.values()) {
            CompositeNodePropertyKey key = entry.getCompositeKey();
            InstanceNodeSessionId nodeId = entry.getInstanceNodeSessionId();
            HashMap<String, String> nodeMap = (HashMap<String, String>)result.get(nodeId);
            if (!result.containsKey(nodeId)) {
                nodeMap = new HashMap<String, String>();
                result.put(nodeId, nodeMap);
            }
            nodeMap.put(key.getDataKey(), entry.getValue());
        }
        return result;
    }

    public Map<InstanceNodeSessionId, Map<String, String>> getAllNodeProperties(Collection<InstanceNodeSessionId> nodeIds) {
        HashMap<InstanceNodeSessionId, Map<String, String>> result = new HashMap<InstanceNodeSessionId, Map<String, String>>();
        for (InstanceNodeSessionId nodeId : nodeIds) {
            result.put(nodeId, this.getNodeProperties(nodeId));
        }
        return result;
    }

    public void mergeUnchecked(Collection<NodePropertyImpl> update) {
        HashMap<String, String> updatedSessionsByInstanceNodeIds = new HashMap<String, String>();
        for (NodePropertyImpl entry : update) {
            boolean performActualMerge = this.processSessionTimestampOfIncomingEntry(entry, updatedSessionsByInstanceNodeIds);
            if (!performActualMerge) continue;
            this.knowledgeMap.put(entry.getCompositeKey(), entry);
        }
        this.purgeOutdatedEntries(updatedSessionsByInstanceNodeIds);
    }

    public Collection<NodePropertyImpl> mergeAndGetEffectiveSubset(Collection<NodePropertyImpl> update) {
        HashMap<String, String> updatedSessionsByInstanceNodeIds = new HashMap<String, String>();
        ArrayList<NodePropertyImpl> effectiveSubset = new ArrayList<NodePropertyImpl>();
        for (NodePropertyImpl entry : update) {
            CompositeNodePropertyKey ckey;
            NodePropertyImpl existing;
            boolean performActualMerge = this.processSessionTimestampOfIncomingEntry(entry, updatedSessionsByInstanceNodeIds);
            if (!performActualMerge || (existing = this.knowledgeMap.get(ckey = entry.getCompositeKey())) != null && existing.getSequenceNo() >= entry.getSequenceNo()) continue;
            this.knowledgeMap.put(ckey, entry);
            effectiveSubset.add(entry);
        }
        this.purgeOutdatedEntries(updatedSessionsByInstanceNodeIds);
        return effectiveSubset;
    }

    public Collection<NodePropertyImpl> getDetachedCopyOfEntries() {
        return Collections.unmodifiableCollection(new ArrayList<NodePropertyImpl>(this.knowledgeMap.values()));
    }

    public Collection<NodePropertyImpl> getComplementingKnowledge(Collection<NodePropertyImpl> input) {
        HashMap<CompositeNodePropertyKey, NodePropertyImpl> inputMap = new HashMap<CompositeNodePropertyKey, NodePropertyImpl>();
        for (NodePropertyImpl entry : input) {
            CompositeNodePropertyKey ckey = entry.getCompositeKey();
            NodeProperty existing = (NodeProperty)inputMap.get(ckey);
            if (existing == null) {
                inputMap.put(ckey, entry);
                continue;
            }
            this.log.warn((Object)("Received node property update with more than one entry for key " + ckey + "; falling back to full knowledge response"));
            return this.getDetachedCopyOfEntries();
        }
        ArrayList<NodePropertyImpl> response = new ArrayList<NodePropertyImpl>();
        for (NodePropertyImpl ownEntry : this.knowledgeMap.values()) {
            CompositeNodePropertyKey ckey = ownEntry.getCompositeKey();
            NodePropertyImpl correspondingInput = (NodePropertyImpl)inputMap.get(ckey);
            if (correspondingInput != null && correspondingInput.getSequenceNo() >= ownEntry.getSequenceNo()) continue;
            response.add(ownEntry);
        }
        return Collections.unmodifiableCollection(response);
    }

    public int getEntryCount() {
        return this.knowledgeMap.size();
    }

    private boolean processSessionTimestampOfIncomingEntry(NodePropertyImpl entry, Map<String, String> updatedSessionsByInstanceNodeIds) {
        boolean performActualMerge;
        InstanceNodeSessionId instanceNodeSessionId = entry.getInstanceNodeSessionId();
        String instanceNodeIdString = instanceNodeSessionId.getInstanceNodeIdString();
        String incomingSessionId = instanceNodeSessionId.getSessionIdPart();
        String previousSessionId = this.mostRecentSessionIds.get(instanceNodeIdString);
        int incomingSessionComparedToPrevious = previousSessionId != null ? this.compareSessionIdTimes(incomingSessionId, previousSessionId) : 1;
        if (incomingSessionComparedToPrevious < 0) {
            this.log.debug((Object)("Received a node property for the outdated node session " + instanceNodeSessionId + "; ignoring the update"));
            performActualMerge = false;
        } else {
            if (incomingSessionComparedToPrevious > 0) {
                this.mostRecentSessionIds.put(instanceNodeIdString, incomingSessionId);
                updatedSessionsByInstanceNodeIds.put(instanceNodeIdString, incomingSessionId);
            }
            performActualMerge = true;
        }
        return performActualMerge;
    }

    private void purgeOutdatedEntries(Map<String, String> sessionPartsOfAffectedInstanceNodeIds) {
        ArrayList<CompositeNodePropertyKey> propertyKeysToDelete = new ArrayList<CompositeNodePropertyKey>();
        for (Map.Entry<CompositeNodePropertyKey, NodePropertyImpl> propertyEntry : this.knowledgeMap.entrySet()) {
            String propertyKeySessionPart;
            CompositeNodePropertyKey propertyKey = propertyEntry.getKey();
            String propertyKeyInstanceNodeSessionId = propertyKey.getInstanceNodeSessionIdString();
            String propertyKeyInstanceNodeIdPart = propertyKeyInstanceNodeSessionId.substring(0, 32);
            String incomingSessionPart = sessionPartsOfAffectedInstanceNodeIds.get(propertyKeyInstanceNodeIdPart);
            if (incomingSessionPart == null || !this.isSessionIdMoreRecentThan(incomingSessionPart, propertyKeySessionPart = propertyKeyInstanceNodeSessionId.substring(propertyKeyInstanceNodeSessionId.length() - 10))) continue;
            this.log.debug((Object)StringUtils.format((String)"Removing cached node property %s as the most recent session id is now %s", (Object[])new Object[]{propertyKey, incomingSessionPart}));
            propertyKeysToDelete.add(propertyKey);
        }
        for (CompositeNodePropertyKey key : propertyKeysToDelete) {
            this.knowledgeMap.remove(key);
        }
    }

    private boolean isSessionIdMoreRecentThan(String session1, String session2) {
        return this.compareSessionIdTimes(session1, session2) > 0;
    }

    private int compareSessionIdTimes(String session1, String session2) {
        return session1.compareTo(session2);
    }
}

