/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.impl;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.uplink.client.session.api.UplinkConnection;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.function.Consumer;

public class SshUplinkConnectionImpl
implements UplinkConnection {
    private final Session sshSession;
    private ChannelExec executionChannel;

    public SshUplinkConnectionImpl(Session sshSession) {
        this.sshSession = sshSession;
    }

    @Override
    public synchronized OutputStream open(Consumer<InputStream> incomingStreamConsumer, Consumer<String> errorConsumer) throws IOException {
        if (this.executionChannel != null) {
            throw new IllegalStateException("Cannot be started while already running");
        }
        try {
            this.executionChannel = (ChannelExec)this.sshSession.openChannel("exec");
            OutputStream outputStreamForInput = this.executionChannel.getOutputStream();
            this.executionChannel.setCommand("ra uplink");
            InputStream incomingStream = this.executionChannel.getInputStream();
            InputStream errorStream = this.executionChannel.getErrStream();
            ConcurrencyUtils.getAsyncTaskService().execute("SSH Uplink: forward incoming data stream", () -> incomingStreamConsumer.accept(incomingStream));
            ConcurrencyUtils.getAsyncTaskService().execute("SSH Uplink: monitor incoming error stream", () -> {
                block3: {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));
                    try {
                        String message;
                        while ((message = reader.readLine()) != null) {
                            errorConsumer.accept(message);
                        }
                    }
                    catch (IOException e) {
                        if (e instanceof EOFException) break block3;
                        errorConsumer.accept("Error stream watcher terminated unexpectedly: " + e.toString());
                    }
                }
            });
            this.executionChannel.connect();
            return outputStreamForInput;
        }
        catch (JSchException e) {
            this.executionChannel = null;
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void close() {
        if (this.executionChannel == null) {
            return;
        }
        this.executionChannel.disconnect();
    }
}

