/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.impl;

import de.rcenvironment.core.communication.uplink.client.session.api.UplinkConnection;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSession;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSessionService;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.function.Consumer;

public class LocalServiceUplinkConnectionImpl
implements UplinkConnection {
    private final AsyncTaskService asyncTaskService;
    private final ServerSideUplinkSessionService sessionService;
    private PipedInputStream r2cPipedInputStream;
    private PipedInputStream c2rPipedInputStream;

    public LocalServiceUplinkConnectionImpl(AsyncTaskService asyncTaskService, ServerSideUplinkSessionService sessionService) {
        this.asyncTaskService = asyncTaskService;
        this.sessionService = sessionService;
    }

    @Override
    public OutputStream open(Consumer<InputStream> incomingStreamConsumer, Consumer<String> errorConsumer) throws IOException {
        this.c2rPipedInputStream = new PipedInputStream();
        PipedOutputStream c2rPipedOutputStream = new PipedOutputStream(this.c2rPipedInputStream);
        this.r2cPipedInputStream = new PipedInputStream();
        PipedOutputStream r2cPipedOutputStream = new PipedOutputStream(this.r2cPipedInputStream);
        ServerSideUplinkSession serverSideSession = this.sessionService.createServerSideSession("Local service uplink connection", "test", this.c2rPipedInputStream, r2cPipedOutputStream);
        this.asyncTaskService.execute("Local service uplink connection: Running the server-side session", serverSideSession::runSession);
        this.asyncTaskService.execute("Local service uplink connection: Providing the input stream", () -> incomingStreamConsumer.accept(this.r2cPipedInputStream));
        return c2rPipedOutputStream;
    }

    @Override
    public void close() {
        try {
            this.c2rPipedInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to close the local service uplink connection's client-to-relay output stream");
        }
        try {
            this.r2cPipedInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to close the local service uplink connection's relay-to-client output stream");
        }
    }
}

