/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.spi;

import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractInteractiveCommandConsole
implements TextOutputReceiver {
    private final CommandExecutionService commandExecutionService;
    private final Log log = LogFactory.getLog(this.getClass());
    private String commandPrefix;

    public AbstractInteractiveCommandConsole(CommandExecutionService commandExecutionService) {
        this(commandExecutionService, "");
    }

    public AbstractInteractiveCommandConsole(CommandExecutionService commandExecutionService, String commandPrefix) {
        this.commandExecutionService = commandExecutionService;
        this.commandPrefix = commandPrefix;
    }

    public void onStart() {
    }

    public abstract void addOutput(String var1);

    public void onFinished() {
    }

    public final void onFatalError(Exception e) {
        if (e instanceof CommandException) {
            CommandException ce = (CommandException)e;
            switch (ce.getType()) {
                case SYNTAX_ERROR: {
                    if (ce.getMessage() != null) {
                        this.addOutput(StringUtils.format((String)"Syntax error: %s", (Object[])new Object[]{ce.getMessage()}));
                        this.addOutput(StringUtils.format((String)"Use \"%shelp\" to see all available commands.", (Object[])new Object[]{this.commandPrefix}));
                        break;
                    }
                    this.addOutput(StringUtils.format((String)"Syntax error. Use \"%shelp\" to see all available commands.", (Object[])new Object[]{this.commandPrefix}));
                    break;
                }
                case UNKNOWN_COMMAND: {
                    this.addOutput(StringUtils.format((String)"Unknown command \"%s\". Use \"%shelp\" to see all available commands.", (Object[])new Object[]{ce.getCommandString(), this.commandPrefix}));
                    break;
                }
                case EXECUTION_ERROR: {
                    this.log.warn((Object)StringUtils.format((String)"Error executing command \"%s\"; message=%s", (Object[])new Object[]{ce.getCommandString(), ce.getMessage()}));
                    if (ce.getMessage() != null) {
                        this.addOutput(StringUtils.format((String)"Error executing command \"%s\": %s", (Object[])new Object[]{ce.getCommandString(), ce.getMessage()}));
                        break;
                    }
                    this.addOutput(StringUtils.format((String)"Error executing command \"%s\". No message text available; check the log file for more information.", (Object[])new Object[]{ce.getCommandString()}));
                    break;
                }
                case HELP_REQUESTED: {
                    boolean useCommandPrefix = this.commandPrefix != null && !this.commandPrefix.isEmpty();
                    this.commandExecutionService.printHelpText(useCommandPrefix, ce.shouldPrintDeveloperHelp(), this);
                    break;
                }
                default: {
                    this.log.error((Object)"Unhandled CommandException sub-type", (Throwable)e);
                    this.addOutput("Internal error: Unhandled CommandException sub-type (" + e.toString() + ")");
                    break;
                }
            }
        } else {
            this.log.info((Object)"Error during command execution", (Throwable)e);
            this.addOutput("Error during command execution (" + e.toString() + "); check log file for details");
        }
    }
}

