/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.common;

import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.List;

public final class CommandException
extends Exception {
    private static final long serialVersionUID = 405551760124111120L;
    private final Type type;
    private final List<String> commandTokens;
    private final boolean showDeveloperHelp;

    private CommandException(Type type, String message, CommandContext context) {
        super(message);
        this.type = type;
        this.commandTokens = context.getOriginalTokens();
        this.showDeveloperHelp = context.isDeveloperCommandSetEnabled();
    }

    public static CommandException syntaxError(String message, CommandContext context) {
        return new CommandException(Type.SYNTAX_ERROR, message, context);
    }

    public static CommandException wrongNumberOfParameters(CommandContext context) {
        return new CommandException(Type.SYNTAX_ERROR, "Wrong number of parameters", context);
    }

    public static CommandException executionError(String message, CommandContext context) {
        return new CommandException(Type.EXECUTION_ERROR, message, context);
    }

    public static CommandException unknownCommand(CommandContext context) {
        return new CommandException(Type.UNKNOWN_COMMAND, null, context);
    }

    public static CommandException requestHelp(CommandContext context) {
        return new CommandException(Type.HELP_REQUESTED, null, context);
    }

    public Type getType() {
        return this.type;
    }

    public String getCommandString() {
        return org.apache.commons.lang3.StringUtils.join(this.commandTokens, (char)' ');
    }

    public boolean shouldPrintDeveloperHelp() {
        return this.showDeveloperHelp;
    }

    @Override
    public String toString() {
        return StringUtils.format((String)"Type=%s, Tokens=%s, ShowDevHelp=%s, Message=%s", (Object[])new Object[]{this.type, this.commandTokens, this.showDeveloperHelp, this.getMessage()});
    }

    public static enum Type {
        HELP_REQUESTED,
        UNKNOWN_COMMAND,
        SYNTAX_ERROR,
        EXECUTION_ERROR;

    }
}

