/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.execution.python.internal;

import de.rcenvironment.components.script.common.ScriptComponentHistoryDataItem;
import de.rcenvironment.components.script.execution.DefaultScriptExecutor;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.NotAValueTD;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.scripting.ScriptingUtils;
import de.rcenvironment.core.scripting.python.PythonScriptContext;
import de.rcenvironment.core.scripting.python.PythonScriptEngine;
import de.rcenvironment.core.utils.common.OSFamily;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PythonScriptExecutor
extends DefaultScriptExecutor {
    private static final String NOT_VALUE_UUID = "not_a_value_7fdc603e";
    private static final String OS = "os";
    private PythonScriptContext scriptContext;
    private Log log = LogFactory.getLog(PythonScriptExecutor.class);

    public boolean prepareExecutor(ComponentContext compCtx) throws ComponentException {
        super.prepareExecutor(compCtx);
        this.componentContext = compCtx;
        String pythonInstallation = this.componentContext.getConfigurationValue("pythonExecutionPath");
        if (pythonInstallation == null || pythonInstallation.isEmpty()) {
            throw new ComponentException("No Python installation specified.");
        }
        this.scriptContext = new PythonScriptContext();
        this.scriptContext.setAttribute("pythonExecutionPath", (Object)pythonInstallation, 0);
        this.scriptContext.setAttribute(OS, (Object)OSFamily.getLocal(), 0);
        this.scriptContext.setAttribute("compCtx", (Object)this.componentContext, 0);
        this.stateMap = new HashMap();
        scriptingService = (ScriptingService)compCtx.getService(ScriptingService.class);
        return true;
    }

    public void prepareOutputForRun() {
    }

    public void prepareNewRun(ScriptLanguage scriptLanguage, String userScript, ScriptComponentHistoryDataItem dataItem) throws ComponentException {
        this.historyDataItem = dataItem;
        this.scriptEngine = scriptingService.createScriptEngine(scriptLanguage);
        this.wrappingScript = userScript;
        if (this.wrappingScript == null || this.wrappingScript.length() == 0) {
            throw new ComponentException("No Python script configured");
        }
        this.scriptEngine.setContext((ScriptContext)this.scriptContext);
        this.scriptContext.removeAttribute("stateMap", 0);
        this.scriptContext.setAttribute("stateMap", (Object)this.stateMap, 0);
        this.scriptContext.removeAttribute("runNumber", 0);
        this.scriptContext.setAttribute("runNumber", (Object)this.getCurrentRunNumber(), 0);
        ((PythonScriptEngine)this.scriptEngine).createNewExecutor((CommonComponentHistoryDataItem)this.historyDataItem);
        typedDatumFactory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
    }

    public void runScript() throws ComponentException {
        int exitCode = 0;
        try {
            try {
                this.componentContext.announceExternalProgramStart();
                exitCode = (Integer)this.scriptEngine.eval(this.wrappingScript);
            }
            catch (ScriptException e) {
                throw new ComponentException("Failed to execute script", (Throwable)e);
            }
        }
        finally {
            this.componentContext.announceExternalProgramTermination();
        }
        if (exitCode != 0) {
            throw new ComponentException("Failed to execute script; exit code: " + exitCode);
        }
    }

    public boolean postRun() throws ComponentException {
        TypedDatumFactory factory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
        for (String outputName : this.componentContext.getOutputs()) {
            DataType type = this.componentContext.getOutputDataType(outputName);
            List resultList = (List)this.scriptEngine.get(outputName);
            NotAValueTD outputValue = null;
            String workingPath = ((PythonScriptEngine)this.scriptEngine).getExecutor().getWorkDir().getAbsolutePath();
            if (this.scriptEngine.get(outputName) == null) continue;
            for (Object o : resultList) {
                if (o != null && !String.valueOf(o).equals(NOT_VALUE_UUID)) {
                    outputValue = ScriptingUtils.getOutputByType(o, (DataType)type, (String)outputName, (String)workingPath, (ComponentContext)this.componentContext);
                    this.componentContext.writeOutput(outputName, (TypedDatum)outputValue);
                    continue;
                }
                if (!String.valueOf(o).equals(NOT_VALUE_UUID)) continue;
                outputValue = factory.createNotAValue();
                this.componentContext.writeOutput(outputName, (TypedDatum)outputValue);
            }
        }
        this.stateMap = ((PythonScriptEngine)this.scriptEngine).getStateOutput();
        for (String outputName : ((PythonScriptEngine)this.scriptEngine).getCloseOutputChannelsList()) {
            this.componentContext.closeOutput(outputName);
        }
        ((PythonScriptEngine)this.scriptEngine).dispose();
        return true;
    }

    private TypedDatum convertBoolean(TypedDatumFactory factory, Object o) throws ComponentException {
        String stringValue = o.toString();
        boolean isNumber = true;
        BooleanTD outputValue = null;
        try {
            float numberValue = Float.parseFloat(stringValue);
            outputValue = Math.abs(numberValue) > 0.0f ? factory.createBoolean(true) : factory.createBoolean(false);
        }
        catch (NumberFormatException numberFormatException) {
            isNumber = false;
        }
        if (!isNumber && (stringValue.equalsIgnoreCase("0") || stringValue.equalsIgnoreCase("0L") || stringValue.equalsIgnoreCase("0.0") || stringValue.equalsIgnoreCase("0j") || stringValue.equalsIgnoreCase("()") || stringValue.equalsIgnoreCase("[]") || stringValue.isEmpty() || stringValue.equalsIgnoreCase("{}") || stringValue.equalsIgnoreCase("false") || stringValue.equalsIgnoreCase("none"))) {
            outputValue = factory.createBoolean(false);
        } else if (!isNumber) {
            outputValue = factory.createBoolean(true);
        }
        return outputValue;
    }

    private TypedDatum handleFileOrDirectoryOutput(String outputName, TypedDatum outputValue, String type, Object o) throws ComponentException {
        block5: {
            try {
                File file = new File(String.valueOf(o));
                if (!file.isAbsolute()) {
                    file = new File(((PythonScriptEngine)this.scriptEngine).getExecutor().getWorkDir(), String.valueOf(o));
                }
                if (file.exists()) {
                    outputValue = type.equals("directory") ? ((ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class)).createDirectoryReferenceTDFromLocalDirectory(this.componentContext, file, file.getName()) : ((ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class)).createFileReferenceTDFromLocalFile(this.componentContext, file, file.getName());
                    if (file.getAbsolutePath().startsWith(((ConfigurationService)this.componentContext.getService(ConfigurationService.class)).getParentTempDirectoryRoot().getAbsolutePath())) {
                        this.tempFiles.add(file);
                    }
                    break block5;
                }
                throw new ComponentException(StringUtils.format((String)"Failed to write %s to output '%s' as it does not exist: %s", (Object[])new Object[]{type, outputName, file.getAbsolutePath()}));
            }
            catch (IOException e) {
                throw new ComponentException(StringUtils.format((String)"Failed to store %s into the data management - if it is not stored in the data management, it can not be sent as output value", (Object[])new Object[]{type}), (Throwable)e);
            }
        }
        return outputValue;
    }

    public void deleteTempFiles() {
        super.deleteTempFiles();
        if (this.scriptEngine != null) {
            ((PythonScriptEngine)this.scriptEngine).dispose();
        }
    }

    public void cancelScript() {
        if (this.scriptEngine == null) {
            this.log.error((Object)"Cannot cancel the execution, as the script engine (Script Component) is not propertly prepared.");
            return;
        }
        ((PythonScriptEngine)this.scriptEngine).cancel();
    }

    public boolean isCancelable() {
        return true;
    }
}

