/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.inputprovider.gui;

import de.rcenvironment.components.inputprovider.gui.Messages;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class InputProviderEndpointEditDialog
extends EndpointEditDialog
implements SelectionListener {
    private static final int[] NOTETEXTSIZE = new int[]{75, 10};
    private static final int SHORTTEXT_MAXLENGTH = 140;
    private Label label;
    private Text textField;
    private Combo combo;
    private Button selectFromFileSystemButton;
    private Composite confContainer;
    private Composite warningComposite;
    private Boolean warningCompositeCreated = false;
    private NumericalTextConstraintListener floatListener;
    private NumericalTextConstraintListener integerListener;
    private Button selectFromProjectButton;
    private Button selectAtStartCheckbox;
    private boolean isInProject;

    public InputProviderEndpointEditDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, Image icon, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues) {
        super(parentShell, actionType, configuration, direction, id, isStatic, metaData, metadataValues);
    }

    protected void createEndpointSettings(Composite parent) {
        super.createEndpointSettings(parent);
        this.comboDataType.addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        this.removeListeners();
        this.initialize();
    }

    protected Text createLabelAndTextfield(Composite container, String text, String dataType, String value) {
        this.confContainer = container;
        this.createValueArea();
        this.createFileSelectionArea();
        this.createListeners();
        this.initialize();
        this.initializeWithValue(value);
        return this.textField;
    }

    private void initializeWithValue(String value) {
        if (this.metadataValues.containsKey("fileSourceType") && ((String)this.metadataValues.get("fileSourceType")).equals("atWorkflowStart")) {
            this.selectAtStartCheckbox.setSelection(true);
            this.setSelectedAtStart();
        } else {
            this.textField.setText(value);
        }
        if (this.combo != null) {
            this.combo.select(this.combo.indexOf(value));
        }
    }

    protected void initializeBounds() {
        super.initializeBounds();
        if (this.combo != null) {
            this.combo.setBounds(this.textField.getBounds());
        }
    }

    private void initialize() {
        if (!this.selectAtStartCheckbox.getSelection()) {
            this.textField.setText("");
            this.textField.setEnabled(true);
        }
        String dataType = this.comboDataType.getText();
        this.setTextFieldOrComboVisible(true);
        this.setDataTypeSelected(true);
        if (dataType.equals(DataType.Integer.getDisplayName())) {
            this.textField.addVerifyListener((VerifyListener)this.integerListener);
        } else if (dataType.equals(DataType.Float.getDisplayName())) {
            this.textField.addVerifyListener((VerifyListener)this.floatListener);
        } else if (dataType.equals(DataType.FileReference.getDisplayName()) || dataType.equals(DataType.DirectoryReference.getDisplayName())) {
            if (!this.selectAtStartCheckbox.getSelection()) {
                this.setFileOrDirectorySelected(true);
            }
        } else if (dataType.equals(DataType.Boolean.getDisplayName())) {
            if (this.combo == null) {
                this.createBooleanCombo();
            }
            this.setTextFieldOrComboVisible(false);
            if (!this.selectAtStartCheckbox.getSelection()) {
                this.textField.setText(this.combo.getText());
            }
            this.combo.setEnabled(!this.selectAtStartCheckbox.getSelection());
        }
    }

    private void setTextFieldOrComboVisible(boolean textFieldVisible) {
        this.textField.setVisible(textFieldVisible);
        if (this.combo != null) {
            this.combo.setVisible(!textFieldVisible);
        }
    }

    private void createValueArea() {
        this.label = new Label(this.confContainer, 0);
        this.label.setText(Messages.value);
        this.textField = new Text(this.confContainer, 2048);
        this.textField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textField.setVisible(false);
    }

    private void createFileSelectionArea() {
        this.isInProject = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput().toString().split("/").length != 1;
        Composite fileSelectionComposite = new Composite(this.confContainer, 0);
        fileSelectionComposite.setLayout((Layout)new GridLayout(2, true));
        GridData g = new GridData(4, 4, true, true);
        g.horizontalSpan = 2;
        fileSelectionComposite.setLayoutData((Object)g);
        Composite atStartComposite = new Composite(fileSelectionComposite, 0);
        atStartComposite.setLayout((Layout)new GridLayout(2, false));
        g = new GridData();
        g.horizontalSpan = 2;
        g.grabExcessHorizontalSpace = true;
        atStartComposite.setLayoutData((Object)g);
        this.selectAtStartCheckbox = new Button(atStartComposite, 32);
        this.selectAtStartCheckbox.setText(Messages.chooseAtWorkflowStart);
        this.selectAtStartCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                InputProviderEndpointEditDialog.this.setSelectedAtStart();
                InputProviderEndpointEditDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.selectFromProjectButton = new Button(fileSelectionComposite, 8);
        this.selectFromProjectButton.setText(Messages.selectFromProject);
        g = new GridData(2, 2, false, false);
        this.selectFromProjectButton.setLayoutData((Object)g);
        this.selectFromProjectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                IFolder resource = null;
                if (InputProviderEndpointEditDialog.this.comboDataType.getText().equals(DataType.DirectoryReference.getDisplayName())) {
                    resource = PropertyTabGuiHelper.selectDirectoryFromActiveProject((Shell)InputProviderEndpointEditDialog.this.confContainer.getShell(), (String)Messages.selectDirectory, (String)Messages.selectDirectoryFromProject);
                } else if (InputProviderEndpointEditDialog.this.isInProject) {
                    resource = PropertyTabGuiHelper.selectFileFromActiveProject((Shell)InputProviderEndpointEditDialog.this.confContainer.getShell(), (String)Messages.selectFile, (String)Messages.selectFileFromProject);
                }
                if (resource != null) {
                    InputProviderEndpointEditDialog.this.textField.setText(resource.getFullPath().makeRelative().toPortableString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.selectFromFileSystemButton = new Button(fileSelectionComposite, 8);
        this.selectFromFileSystemButton.setText(Messages.selectFromFileSystem);
        this.selectFromFileSystemButton.setLayoutData((Object)g);
        this.selectFromFileSystemButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String path;
                if (InputProviderEndpointEditDialog.this.comboDataType.getText().equals(DataType.DirectoryReference.getDisplayName())) {
                    DirectoryDialog dialog = new DirectoryDialog(InputProviderEndpointEditDialog.this.confContainer.getShell(), 4096);
                    dialog.setText(Messages.selectDirectory);
                    dialog.setMessage(Messages.selectDirectoryFromFileSystem);
                    this.checkIfPathExists((Dialog)dialog, InputProviderEndpointEditDialog.this.textField.getText());
                    path = dialog.open();
                } else {
                    FileDialog dialog = new FileDialog(InputProviderEndpointEditDialog.this.confContainer.getShell(), 4096);
                    dialog.setText(Messages.selectFile);
                    this.checkIfPathExists((Dialog)dialog, InputProviderEndpointEditDialog.this.textField.getText());
                    path = dialog.open();
                }
                if (path != null) {
                    InputProviderEndpointEditDialog.this.textField.setText(path);
                }
            }

            private void checkIfPathExists(Dialog dialog, String text) {
                Path isThisPathExisting = Paths.get(text, new String[0]);
                if (Files.exists(isThisPathExisting, LinkOption.NOFOLLOW_LINKS)) {
                    if (dialog instanceof DirectoryDialog) {
                        ((DirectoryDialog)dialog).setFilterPath(isThisPathExisting.toString());
                    } else if (isThisPathExisting.getParent() != null) {
                        ((FileDialog)dialog).setFilterPath(isThisPathExisting.getParent().toString());
                    } else {
                        File[] paths = File.listRoots();
                        if (paths[0].getPath() != null) {
                            ((FileDialog)dialog).setFilterPath(paths[0].getPath());
                        } else {
                            return;
                        }
                    }
                    return;
                }
                if (isThisPathExisting.getParent() == null) {
                    return;
                }
                this.checkIfPathExists(dialog, isThisPathExisting.getParent().toString());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.setFileOrDirectorySelected(false);
        if (!this.isInProject) {
            this.createWorkflowNotInRCEWarning();
        }
    }

    private void createWorkflowNotInRCEWarning() {
        this.warningComposite = new Composite(this.confContainer, 0);
        this.warningComposite.setLayout((Layout)new GridLayout(2, false));
        GridData g = new GridData(4, 2, true, true);
        g.horizontalSpan = 2;
        this.warningComposite.setLayoutData((Object)g);
        Label noteLabel = new Label(this.warningComposite, 128);
        noteLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16));
        noteLabel.setLayoutData((Object)new GridData(2));
        g = new GridData(770);
        g.horizontalAlignment = 4;
        g.widthHint = NOTETEXTSIZE[1];
        g.heightHint = NOTETEXTSIZE[0];
        g.grabExcessHorizontalSpace = true;
        Text noteText = new Text(this.warningComposite, 72);
        noteText.setEditable(false);
        noteText.setEnabled(false);
        noteText.setLayoutData((Object)g);
        noteText.setCursor(Display.getCurrent().getSystemCursor(0));
        noteText.setText("Select from project is not available because the component is in a workflow outside your current workspace.");
        this.warningCompositeCreated = true;
    }

    private void setSelectedAtStart() {
        boolean selectAtStart = this.selectAtStartCheckbox.getSelection();
        this.textField.setEnabled(!selectAtStart);
        if (selectAtStart) {
            this.textField.setText("-");
        } else {
            this.textField.setText("");
        }
        String dataType = this.comboDataType.getText();
        if (dataType.equals(DataType.FileReference.toString()) || dataType.equals(DataType.DirectoryReference.toString())) {
            if (this.isInProject) {
                this.selectFromProjectButton.setEnabled(!selectAtStart);
            } else {
                this.warningComposite.setVisible(!selectAtStart);
            }
            this.selectFromFileSystemButton.setEnabled(!selectAtStart);
        }
        if (dataType.equals(DataType.Boolean.toString())) {
            this.combo.setEnabled(!selectAtStart);
            if (!selectAtStart) {
                this.textField.setText(this.combo.getText());
            }
        }
        if (selectAtStart) {
            this.metadataValues.put("fileSourceType", "atWorkflowStart");
        } else {
            this.metadataValues.remove("fileSourceType");
        }
    }

    private void setDataTypeSelected(boolean selected) {
        this.selectAtStartCheckbox.setEnabled(selected);
        this.selectFromProjectButton.setEnabled(false);
        this.selectFromFileSystemButton.setEnabled(false);
        if (!this.isInProject && this.warningCompositeCreated.booleanValue()) {
            this.warningComposite.setVisible(!selected);
        }
    }

    private void setFileOrDirectorySelected(boolean selected) {
        this.selectAtStartCheckbox.setEnabled(selected);
        if (this.isInProject) {
            this.selectFromProjectButton.setEnabled(selected);
        } else {
            this.selectFromProjectButton.setEnabled(!selected);
            if (this.warningCompositeCreated.booleanValue()) {
                this.warningComposite.setVisible(selected);
            }
        }
        this.selectFromFileSystemButton.setEnabled(selected);
    }

    private void createBooleanCombo() {
        this.combo = new Combo(this.confContainer, 8);
        this.combo.add(Boolean.TRUE.toString().toLowerCase());
        this.combo.add(Boolean.FALSE.toString().toLowerCase());
        this.combo.setText(Boolean.TRUE.toString().toLowerCase());
        this.combo.setBounds(this.textField.getBounds());
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                InputProviderEndpointEditDialog.this.textField.setText(InputProviderEndpointEditDialog.this.combo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.combo.setVisible(false);
    }

    private void createListeners() {
        this.floatListener = new NumericalTextConstraintListener(this.textField, 1);
        this.integerListener = new NumericalTextConstraintListener(this.textField, 2);
    }

    private void removeListeners() {
        this.textField.removeVerifyListener((VerifyListener)this.integerListener);
        this.textField.removeVerifyListener((VerifyListener)this.floatListener);
    }

    protected boolean validateMetaDataInputs() {
        boolean isValid = true;
        for (Widget widget : this.widgetToKeyMap.keySet()) {
            boolean inputIsRequired;
            boolean datatypeIsNotBoolean;
            String key = "";
            if (this.metaData.getMetaDataKeys().contains(this.widgetToKeyMap.get(widget))) {
                key = (String)this.widgetToKeyMap.get(widget);
            }
            String dataType = this.metaData.getDataType(key);
            String validation = this.metaData.getValidation(key);
            boolean bl = datatypeIsNotBoolean = !dataType.equals("bool");
            if (!datatypeIsNotBoolean || this.metaData.getPossibleValues(key) != null && !this.metaData.getPossibleValues(key).contains("*")) continue;
            boolean bl2 = inputIsRequired = validation != null && validation.contains("required");
            if (((Text)widget).getText().equals("") && inputIsRequired && !this.comboDataType.getText().equalsIgnoreCase(DataType.ShortText.getDisplayName())) {
                isValid = false;
                continue;
            }
            if (((Text)widget).getText().equals("")) continue;
            if (dataType.equalsIgnoreCase("int")) {
                int value = Integer.MAX_VALUE;
                try {
                    value = Integer.parseInt(((Text)widget).getText());
                    isValid &= this.checkValidation(value, validation);
                }
                catch (NumberFormatException numberFormatException) {
                    isValid &= false;
                }
                continue;
            }
            if (dataType.equalsIgnoreCase("bool")) {
                double value = Double.MAX_VALUE;
                try {
                    value = Double.parseDouble(((Text)widget).getText());
                    isValid &= this.checkValidation(value, validation);
                }
                catch (NumberFormatException numberFormatException) {
                    isValid &= false;
                }
                continue;
            }
            if (!dataType.equalsIgnoreCase("text")) continue;
            String value = ((Text)widget).getText();
            if (value.length() <= 140) {
                isValid &= true;
                continue;
            }
            isValid &= false;
        }
        if (!isValid && (this.comboDataType.getText().equalsIgnoreCase(DataType.FileReference.getDisplayName()) || this.comboDataType.getText().equalsIgnoreCase(DataType.DirectoryReference.getDisplayName())) && this.selectAtStartCheckbox.getSelection()) {
            isValid = true;
        }
        return isValid;
    }
}

