/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.doe.common;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public final class DOEAlgorithms {
    public static final double MAXMIMAL_RUNS = Math.pow(10.0, 5.0);

    private DOEAlgorithms() {
    }

    public static Double[][] populateTableFullFactorial(int varCount, int numLevels) {
        if (Math.pow(numLevels, varCount) < MAXMIMAL_RUNS) {
            int noRuns = (int)Math.pow(numLevels, varCount);
            Double[][] table = new Double[noRuns][varCount];
            AtomicInteger run = new AtomicInteger(0);
            DOEAlgorithms.populateTableFullFactorialRec(varCount, varCount - 1, numLevels, new double[varCount], run, table);
            return table;
        }
        return new Double[0][0];
    }

    private static void populateTableFullFactorialRec(int varCount, int varIndex, int numLevels, double[] values, AtomicInteger run, Double[][] table) {
        if (varIndex < 0) {
            int i = 0;
            while (i < varCount) {
                table[run.get()][i] = values[i];
                ++i;
            }
            run.incrementAndGet();
            values = new double[varCount];
        } else {
            double step = 2.0 / ((double)numLevels - 1.0);
            int i = 0;
            while (i < numLevels) {
                values[varIndex] = -1.0 + (double)i * step;
                DOEAlgorithms.populateTableFullFactorialRec(varCount, varIndex - 1, numLevels, values, run, table);
                ++i;
            }
        }
    }

    public static Double[][] populateTableLatinHypercube(int varCount, int desiredRuns, int seed) {
        if ((double)desiredRuns < MAXMIMAL_RUNS) {
            int numRuns = desiredRuns;
            Random generator = new Random(seed);
            double binSize = 2.0 / (double)numRuns;
            int[] iindex = new int[numRuns];
            Double[][] table = new Double[desiredRuns][varCount];
            int i = 0;
            while (i < varCount) {
                int j = 0;
                while (j < numRuns) {
                    iindex[j] = j;
                    ++j;
                }
                j = 0;
                while (j < numRuns) {
                    int k = (int)(generator.nextDouble() * (double)numRuns);
                    int itemp = iindex[k];
                    iindex[k] = iindex[j];
                    iindex[j] = itemp;
                    ++j;
                }
                j = 0;
                while (j < numRuns) {
                    double val = -1.0 + (double)iindex[j] * binSize + generator.nextDouble() * binSize;
                    table[j][i] = val;
                    ++j;
                }
                ++i;
            }
            return table;
        }
        return new Double[0][0];
    }

    public static Double[][] populateTableMonteCarlo(int varCount, int runs, int seed) {
        if ((double)runs < MAXMIMAL_RUNS) {
            Double[][] result = new Double[runs][varCount];
            Random generator = new Random(seed);
            int i = 0;
            while (i < runs) {
                int j = 0;
                while (j < varCount) {
                    result[i][j] = generator.nextDouble() * 2.0 - 1.0;
                    ++j;
                }
                ++i;
            }
            return result;
        }
        return new Double[0][0];
    }

    public static Double convertValue(Double low, Double up, Double valueOf) {
        if (valueOf == -1.0) {
            return low;
        }
        if (valueOf == 1.0) {
            return up;
        }
        return (up - low) / 2.0 * valueOf + (low + up) / 2.0;
    }
}

