/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.util.Assert;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilderImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMWriter;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.wizards.NamespaceInfoContentBuilder;
import org.eclipse.wst.xml.ui.internal.wizards.XMLSchemaValidationChecker;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NewXMLGenerator {
    protected String grammarURI;
    protected CMDocument cmDocument;
    protected int buildPolicy;
    protected String rootElementName;
    protected ICatalogEntry xmlCatalogEntry;
    protected int optionalElementDepthLimit = -1;
    protected String publicId;
    protected String systemId;
    protected String defaultSystemId;
    public List namespaceInfoList;

    public NewXMLGenerator() {
    }

    public NewXMLGenerator(String grammarURI, CMDocument cmDocument) {
        this.grammarURI = grammarURI;
        this.cmDocument = cmDocument;
    }

    public static CMDocument createCMDocument(String uri, String[] errorInfo) {
        String title = null;
        String message = null;
        Vector errorList = new Vector();
        CMDocument cmDocument = null;
        if (URIHelper.isReadableURI((String)uri, (boolean)true)) {
            cmDocument = ContentModelManager.getInstance().createCMDocument(uri, null);
            if (uri.endsWith(".dtd")) {
                if (errorList.size() > 0) {
                    title = XMLWizardsMessages._UI_INVALID_GRAMMAR_ERROR;
                    message = XMLWizardsMessages._UI_LABEL_ERROR_DTD_INVALID_INFO;
                }
            } else {
                int globalElementCount;
                XMLSchemaValidationChecker validator = new XMLSchemaValidationChecker();
                if (!validator.isValid(uri)) {
                    title = XMLWizardsMessages._UI_INVALID_GRAMMAR_ERROR;
                    message = XMLWizardsMessages._UI_LABEL_ERROR_SCHEMA_INVALID_INFO;
                } else if (cmDocument != null && (globalElementCount = cmDocument.getElements().getLength()) == 0) {
                    title = XMLWizardsMessages._UI_WARNING_TITLE_NO_ROOT_ELEMENTS;
                    message = XMLWizardsMessages._UI_WARNING_MSG_NO_ROOT_ELEMENTS;
                }
            }
        } else {
            title = XMLWizardsMessages._UI_WARNING_TITLE_NO_ROOT_ELEMENTS;
            message = String.valueOf(XMLWizardsMessages._UI_WARNING_URI_NOT_FOUND_COLON) + " " + uri;
        }
        errorInfo[0] = title;
        errorInfo[1] = message;
        return cmDocument;
    }

    private String applyLineDelimiter(IFile file, String text) {
        String systemLineSeparator = System.getProperty("line.separator");
        String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", systemLineSeparator, new IScopeContext[]{new ProjectScope(file.getProject()), new InstanceScope()});
        if (!systemLineSeparator.equals(lineDelimiter)) {
            String convertedText = StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
            convertedText = StringUtils.replace((String)convertedText, (String)"\r", (String)"\n");
            convertedText = StringUtils.replace((String)convertedText, (String)"\n", (String)lineDelimiter);
            return convertedText;
        }
        return text;
    }

    public void createEmptyXMLDocument(IFile newFile) throws Exception {
        String charSet = this.getUserPreferredCharset();
        String contents = "<?xml version=\"1.0\" encoding=\"" + charSet + "\"?>";
        this.createTemplateXMLDocument(newFile, contents);
    }

    void createTemplateXMLDocument(IFile newFile, String contents) throws Exception {
        if (contents != null) {
            String charSet = this.getUserPreferredCharset();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, charSet));
            contents = this.applyLineDelimiter(newFile, contents);
            writer.print(contents);
            writer.flush();
            outputStream.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            newFile.setContents((InputStream)inputStream, true, true, null);
            inputStream.close();
        }
    }

    private String getUserPreferredCharset() {
        Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
        String charSet = preference.getString("outputCodeset");
        return charSet;
    }

    public void createXMLDocument(String xmlFileName) throws Exception {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(xmlFileName);
        String charset = null;
        if (contentType != null) {
            charset = contentType.getDefaultCharset();
        }
        ByteArrayOutputStream outputStream = this.createXMLDocument(xmlFileName, charset);
        File file = new File(xmlFileName);
        FileOutputStream fos = new FileOutputStream(file);
        outputStream.writeTo(fos);
        fos.close();
    }

    public void createXMLDocument(IFile newFile, String xmlFileName) throws Exception {
        String charset = newFile.getCharset();
        ByteArrayOutputStream outputStream = this.createXMLDocument(xmlFileName, charset);
        String contents = outputStream.toString(charset);
        contents = this.applyLineDelimiter(newFile, contents);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes(charset));
        newFile.setContents((InputStream)inputStream, true, true, null);
        inputStream.close();
    }

    public ByteArrayOutputStream createXMLDocument(String xmlFileName, String charset) throws Exception {
        if (charset == null && (charset = this.getUserPreferredCharset()) == null) {
            charset = "UTF-8";
        }
        CMDocument cmDocument = this.getCMDocument();
        Assert.isNotNull((Object)cmDocument);
        Assert.isNotNull((Object)this.getRootElementName());
        CMNamedNodeMap nameNodeMap = cmDocument.getElements();
        CMElementDeclaration cmElementDeclaration = (CMElementDeclaration)nameNodeMap.getNamedItem(this.getRootElementName());
        Document xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        DOMContentBuilderImpl contentBuilder = new DOMContentBuilderImpl(xmlDocument);
        contentBuilder.supressCreationOfDoctypeAndXMLDeclaration = true;
        contentBuilder.setBuildPolicy(this.buildPolicy);
        contentBuilder.setOptionalElementDepthLimit(this.optionalElementDepthLimit);
        contentBuilder.setExternalCMDocumentSupport((DOMContentBuilderImpl.ExternalCMDocumentSupport)new MyExternalCMDocumentSupport(this.namespaceInfoList, xmlFileName));
        contentBuilder.createDefaultRootContent(cmDocument, cmElementDeclaration, this.namespaceInfoList);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, charset);
        DOMWriter domWriter = new DOMWriter((Writer)outputStreamWriter);
        domWriter.print(xmlDocument, charset, cmDocument.getNodeName(), NewXMLGenerator.getNonWhitespaceString(this.getPublicId()), NewXMLGenerator.getNonWhitespaceString(this.getSystemId()));
        outputStream.flush();
        outputStream.close();
        return outputStream;
    }

    public void createNamespaceInfoList() {
        List result = new Vector();
        if (this.cmDocument != null) {
            List result2 = (List)this.cmDocument.getProperty("http://org.eclipse.wst/cm/properties/completeNamespaceInfo");
            if (result2 != null) {
                result = result2;
                int size = result.size();
                int i = 0;
                while (i < size) {
                    NamespaceInfo info = (NamespaceInfo)result.get(i);
                    if (i == 0) {
                        String locationInfo = null;
                        if (this.xmlCatalogEntry != null) {
                            locationInfo = this.xmlCatalogEntry.getEntryType() == 2 ? this.xmlCatalogEntry.getAttributeValue("webURL") : this.xmlCatalogEntry.getKey();
                        }
                        if (locationInfo == null) {
                            locationInfo = this.defaultSystemId;
                        }
                        info.locationHint = locationInfo;
                        info.setProperty("locationHint-readOnly", (Object)"true");
                        info.setProperty("uri-readOnly", (Object)"true");
                        info.setProperty("unremovable", (Object)"true");
                    } else {
                        info.locationHint = null;
                    }
                    ++i;
                }
            }
            NamespaceInfoContentBuilder builder = new NamespaceInfoContentBuilder();
            builder.setBuildPolicy(2);
            builder.visitCMNode((CMNode)this.cmDocument);
            result.addAll(builder.list);
        }
        this.namespaceInfoList = result;
    }

    public boolean isMissingNamespaceLocation() {
        boolean result = false;
        for (NamespaceInfo info : this.namespaceInfoList) {
            if (info.locationHint != null) continue;
            result = true;
            break;
        }
        return result;
    }

    public String[] getNamespaceInfoErrors() {
        String[] errorList = null;
        return errorList;
    }

    public void setXMLCatalogEntry(ICatalogEntry catalogEntry) {
        this.xmlCatalogEntry = catalogEntry;
    }

    public ICatalogEntry getXMLCatalogEntry() {
        return this.xmlCatalogEntry;
    }

    public void setBuildPolicy(int policy) {
        this.buildPolicy = policy;
    }

    public void setDefaultSystemId(String sysId) {
        this.defaultSystemId = sysId;
    }

    public String getDefaultSystemId() {
        return this.defaultSystemId;
    }

    public void setSystemId(String sysId) {
        this.systemId = sysId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setPublicId(String pubId) {
        this.publicId = pubId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setGrammarURI(String gramURI) {
        this.grammarURI = gramURI;
    }

    public String getGrammarURI() {
        return this.grammarURI;
    }

    public void setCMDocument(CMDocument cmDoc) {
        this.cmDocument = cmDoc;
    }

    public CMDocument getCMDocument() {
        return this.cmDocument;
    }

    public void setRootElementName(String rootName) {
        this.rootElementName = rootName;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public static String getNonWhitespaceString(String string) {
        String result = null;
        if (string != null && string.trim().length() > 0) {
            result = string;
        }
        return result;
    }

    public void setOptionalElementDepthLimit(int optionalElementDepthLimit) {
        this.optionalElementDepthLimit = optionalElementDepthLimit;
    }

    protected class MyExternalCMDocumentSupport
    implements DOMContentBuilderImpl.ExternalCMDocumentSupport {
        protected List namespaceInfoList1;
        protected URIResolver idResolver;
        protected String resourceLocation;

        protected MyExternalCMDocumentSupport(List namespaceInfoListParam, String resourceLocation) {
            this.namespaceInfoList1 = namespaceInfoListParam;
            this.resourceLocation = resourceLocation;
            this.idResolver = URIResolverPlugin.createResolver();
        }

        public CMDocument getCMDocument(Element element, String namespaceURI) {
            CMDocument result = null;
            if (namespaceURI != null && namespaceURI.trim().length() > 0) {
                String locationHint = null;
                for (NamespaceInfo info : this.namespaceInfoList1) {
                    if (!namespaceURI.equals(info.uri)) continue;
                    locationHint = info.locationHint;
                    break;
                }
                if (locationHint != null) {
                    NewXMLGenerator.this.grammarURI = this.idResolver.resolve(this.resourceLocation, locationHint, locationHint);
                    result = ContentModelManager.getInstance().createCMDocument(NewXMLGenerator.this.getGrammarURI(), null);
                }
            } else {
                result = NewXMLGenerator.this.cmDocument;
            }
            return result;
        }
    }
}

