/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.hyperlink;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class HighlighterHyperlinkPresenter
implements IHyperlinkPresenter,
PaintListener,
ITextInputListener,
IDocumentListener,
IPropertyChangeListener {
    public static final String HYPERLINK_COLOR = "hyperlinkColor";
    private ITextViewer fTextViewer;
    private Cursor fCursor;
    private Color fColor;
    private boolean fDisposeColor;
    private IRegion fActiveRegion;
    private Position fRememberedPosition;
    private IPreferenceStore fPreferenceStore;

    public HighlighterHyperlinkPresenter(IPreferenceStore store) {
        this.fPreferenceStore = store;
        this.fDisposeColor = true;
    }

    public HighlighterHyperlinkPresenter(Color color) {
        this.fDisposeColor = false;
        this.fColor = color;
    }

    public boolean canShowMultipleHyperlinks() {
        return false;
    }

    public void showHyperlinks(IHyperlink[] hyperlinks) {
        Assert.isLegal((hyperlinks != null && hyperlinks.length == 1 ? 1 : 0) != 0);
        this.highlightRegion(hyperlinks[0].getHyperlinkRegion());
        this.activateCursor();
    }

    public void hideHyperlinks() {
        this.repairRepresentation();
        this.fRememberedPosition = null;
    }

    public void install(ITextViewer textViewer) {
        Assert.isNotNull((Object)textViewer);
        this.fTextViewer = textViewer;
        this.fTextViewer.addTextInputListener((ITextInputListener)this);
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.addPaintListener((PaintListener)this);
            if (this.fPreferenceStore != null) {
                this.fColor = this.createColor(this.fPreferenceStore, HYPERLINK_COLOR, text.getDisplay());
            }
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void uninstall() {
        StyledText text;
        this.fTextViewer.removeTextInputListener((ITextInputListener)this);
        if (this.fColor != null) {
            if (this.fDisposeColor) {
                this.fColor.dispose();
            }
            this.fColor = null;
        }
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
        if ((text = this.fTextViewer.getTextWidget()) != null && !text.isDisposed()) {
            text.removePaintListener((PaintListener)this);
        }
        this.fTextViewer = null;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void setColor(Color color) {
        Assert.isNotNull((Object)this.fTextViewer);
        this.fColor = color;
    }

    private void highlightRegion(IRegion region) {
        if (region.equals(this.fActiveRegion)) {
            return;
        }
        this.repairRepresentation();
        StyledText text = this.fTextViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int offset = 0;
        int length = 0;
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            IRegion widgetRange = extension.modelRange2WidgetRange(region);
            if (widgetRange == null) {
                return;
            }
            offset = widgetRange.getOffset();
            length = widgetRange.getLength();
        } else {
            offset = region.getOffset() - this.fTextViewer.getVisibleRegion().getOffset();
            length = region.getLength();
        }
        text.redrawRange(offset, length, true);
        this.fActiveRegion = region;
        if (this.fTextViewer instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)this.fTextViewer).invalidateTextPresentation(region.getOffset(), region.getLength());
        } else {
            this.fTextViewer.invalidateTextPresentation();
        }
    }

    private void activateCursor() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        Display display = text.getDisplay();
        if (this.fCursor == null) {
            this.fCursor = new Cursor((Device)display, 21);
        }
        text.setCursor(this.fCursor);
    }

    private void resetCursor() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.setCursor(null);
        }
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
    }

    private void repairRepresentation() {
        if (this.fActiveRegion == null) {
            return;
        }
        int offset = this.fActiveRegion.getOffset();
        int length = this.fActiveRegion.getLength();
        this.fActiveRegion = null;
        this.resetCursor();
        if (this.fTextViewer instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)this.fTextViewer).invalidateTextPresentation(offset, length);
        } else {
            this.fTextViewer.invalidateTextPresentation();
        }
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            offset = extension.modelOffset2WidgetOffset(offset);
        } else {
            offset -= this.fTextViewer.getVisibleRegion().getOffset();
        }
        try {
            StyledText text = this.fTextViewer.getTextWidget();
            text.redrawRange(offset, length, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void paintControl(PaintEvent event) {
        StyleRange style;
        if (this.fActiveRegion == null) {
            return;
        }
        StyledText text = this.fTextViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int offset = 0;
        int length = 0;
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            IRegion widgetRange = extension.modelRange2WidgetRange(this.fActiveRegion);
            if (widgetRange == null) {
                return;
            }
            offset = widgetRange.getOffset();
            length = widgetRange.getLength();
        } else {
            IRegion region = this.fTextViewer.getVisibleRegion();
            if (!this.includes(region, this.fActiveRegion)) {
                return;
            }
            offset = this.fActiveRegion.getOffset() - region.getOffset();
            length = this.fActiveRegion.getLength();
        }
        Point minLocation = this.getMinimumLocation(text, offset, length);
        Point maxLocation = this.getMaximumLocation(text, offset, length);
        int x1 = minLocation.x;
        int x2 = maxLocation.x - 1;
        int y = minLocation.y + text.getLineHeight() - 1;
        GC gc = event.gc;
        if (this.fColor != null && !this.fColor.isDisposed()) {
            gc.setForeground(this.fColor);
        } else if (this.fColor == null && (offset >= 0 || offset < text.getCharCount()) && (style = text.getStyleRangeAtOffset(offset)) != null) {
            gc.setForeground(style.foreground);
        }
        gc.drawLine(x1, y, x2, y);
    }

    private Point getMinimumLocation(StyledText text, int offset, int length) {
        int max = text.getCharCount();
        Rectangle bounds = text.getBounds();
        Point minLocation = new Point(bounds.width, bounds.height);
        int i = 0;
        while (i <= length) {
            int k = offset + i;
            if (k < 0 || k > max) break;
            Point location = text.getLocationAtOffset(k);
            if (location.x < minLocation.x) {
                minLocation.x = location.x;
            }
            if (location.y < minLocation.y) {
                minLocation.y = location.y;
            }
            ++i;
        }
        return minLocation;
    }

    private Point getMaximumLocation(StyledText text, int offset, int length) {
        Point maxLocation = new Point(0, 0);
        int i = 0;
        while (i <= length) {
            int k = offset + i;
            if (k < 0 || k > text.getCharCount()) break;
            Point location = text.getLocationAtOffset(k);
            if (location.x > maxLocation.x) {
                maxLocation.x = location.x;
            }
            if (location.y > maxLocation.y) {
                maxLocation.y = location.y;
            }
            ++i;
        }
        return maxLocation;
    }

    private boolean includes(IRegion region, IRegion position) {
        return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        if (this.fActiveRegion != null) {
            this.fRememberedPosition = new Position(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength());
            try {
                event.getDocument().addPosition(this.fRememberedPosition);
            }
            catch (BadLocationException badLocationException) {
                this.fRememberedPosition = null;
            }
        }
    }

    public void documentChanged(DocumentEvent event) {
        if (this.fRememberedPosition != null) {
            if (!this.fRememberedPosition.isDeleted()) {
                event.getDocument().removePosition(this.fRememberedPosition);
                this.fActiveRegion = new Region(this.fRememberedPosition.getOffset(), this.fRememberedPosition.getLength());
                this.fRememberedPosition = null;
                StyledText widget = this.fTextViewer.getTextWidget();
                if (widget != null && !widget.isDisposed()) {
                    widget.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            HighlighterHyperlinkPresenter.this.hideHyperlinks();
                        }
                    });
                }
            } else {
                this.fActiveRegion = null;
                this.fRememberedPosition = null;
                this.hideHyperlinks();
            }
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput == null) {
            return;
        }
        this.hideHyperlinks();
        oldInput.removeDocumentListener((IDocumentListener)this);
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput == null) {
            return;
        }
        newInput.addDocumentListener((IDocumentListener)this);
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!HYPERLINK_COLOR.equals(event.getProperty())) {
            return;
        }
        if (this.fDisposeColor && this.fColor != null && !this.fColor.isDisposed()) {
            this.fColor.dispose();
        }
        this.fColor = null;
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            this.fColor = this.createColor(this.fPreferenceStore, HYPERLINK_COLOR, textWidget.getDisplay());
        }
    }
}

