/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.IDropAction;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.TransferBuilder;

public class ExtendedEditorDropTargetAdapter
extends DropTargetAdapter {
    private String[] editorIds;
    private Point originalRange = null;
    private IEditorPart targetEditor = null;
    private ITextViewer textViewer = null;
    private Transfer[] transfers = null;
    private boolean useProxy;

    public ExtendedEditorDropTargetAdapter() {
        this(false);
    }

    public ExtendedEditorDropTargetAdapter(boolean useProxy) {
        this.useProxy = useProxy;
    }

    protected boolean doDrop(Transfer transfer, DropTargetEvent event) {
        TransferBuilder tb = new TransferBuilder(this.useProxy);
        IDropAction[] as = null;
        as = this.editorIds != null && this.editorIds.length > 0 ? tb.getDropActions(this.editorIds, transfer) : tb.getDropActions(this.getTargetEditor().getClass().getName(), transfer);
        int i = 0;
        while (i < as.length) {
            IDropAction da = as[i];
            Transfer actualTransfer = transfer instanceof TransferBuilder.TransferProxyForDelayLoading ? ((TransferBuilder.TransferProxyForDelayLoading)transfer).getTransferClass() : transfer;
            if (actualTransfer instanceof FileTransfer) {
                if (event.data == null) {
                    Logger.log(4, "No data in DropTargetEvent from " + event.widget);
                    return false;
                }
                String[] strs = (String[])event.data;
                boolean[] bs = new boolean[strs.length];
                int c = 0;
                int j = 0;
                while (j < strs.length) {
                    bs[j] = false;
                    if (da.isSupportedData(strs[j])) {
                        event.data = new String[]{strs[j]};
                        if (!da.run(event, this.targetEditor)) {
                            bs[j] = true;
                            ++c;
                        }
                    } else {
                        bs[j] = true;
                        ++c;
                    }
                    ++j;
                }
                if (c == 0) {
                    return true;
                }
                int k = 0;
                String[] rests = new String[c];
                int j2 = 0;
                while (j2 < strs.length) {
                    if (bs[j2]) {
                        rests[k++] = strs[j2];
                    }
                    ++j2;
                }
                event.data = rests;
            } else if (da.isSupportedData(event.data) && da.run(event, this.targetEditor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dragEnter(DropTargetEvent event) {
        TransferData data = null;
        Transfer[] ts = this.getTransfers();
        int i = 0;
        while (i < ts.length) {
            int j = 0;
            while (j < event.dataTypes.length) {
                if (ts[i].isSupportedType(event.dataTypes[j])) {
                    data = event.dataTypes[j];
                    break;
                }
                ++j;
            }
            if (data != null) {
                event.currentDataType = data;
                break;
            }
            ++i;
        }
        if (this.textViewer != null) {
            this.originalRange = this.textViewer.getSelectedRange();
        }
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.textViewer != null) {
            this.textViewer.setSelectedRange(this.originalRange.x, this.originalRange.y);
        } else {
            this.originalRange = null;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.operations &= 0xFFFFFFFD;
        event.detail = 1;
        event.feedback |= 8;
    }

    public void drop(DropTargetEvent event) {
        if (event.operations == 0) {
            return;
        }
        Transfer[] ts = this.getTransfers();
        int i = 0;
        while (i < ts.length) {
            if (ts[i].isSupportedType(event.currentDataType) && this.doDrop(ts[i], event)) {
                IEditorPart part = this.targetEditor;
                if (this.targetEditor instanceof StructuredTextEditor) {
                    part = ((StructuredTextEditor)this.targetEditor).getEditorPart();
                }
                this.targetEditor.getSite().getPage().activate((IWorkbenchPart)part);
                break;
            }
            ++i;
        }
    }

    public IEditorPart getTargetEditor() {
        return this.targetEditor;
    }

    public ITextViewer getTextViewer() {
        return this.textViewer;
    }

    public Transfer[] getTransfers() {
        if (this.transfers == null) {
            TransferBuilder tb = new TransferBuilder(this.useProxy);
            this.transfers = this.editorIds == null || this.editorIds.length == 0 ? tb.getDropTargetTransfers(this.getTargetEditor().getClass().getName()) : tb.getDropTargetTransfers(this.editorIds);
        }
        return this.transfers;
    }

    public void setTargetEditor(IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void setTargetIDs(String[] ids) {
        this.editorIds = ids;
    }

    public void setTextViewer(ITextViewer textViewer) {
        this.textViewer = textViewer;
    }
}

