/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.gui;

import de.rcenvironment.core.configuration.PersistentSettingsService;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;

public final class WorkspaceSettings {
    private static final String PERSISTENT_SETTINGS_KEY_LAST_WORKSPACE = "rce.workspace.lastLocation";
    private static final String PERSISTENT_SETTINGS_KEY_RECENT_WORKSPACES = "rce.workspace.recentLocations";
    private static final String PERSISTENT_SETTINGS_KEY_DONT_ASK_AGAIN = "rce.workspace.dontAskAgain";
    private static final String DONT_ASK_AGAIN_TRUE_VALUE = "true";
    private static final WorkspaceSettings INSTANCE = new WorkspaceSettings();
    private PersistentSettingsService pss = (PersistentSettingsService)ServiceRegistry.createAccessFor((Object)this).getService(PersistentSettingsService.class);

    private WorkspaceSettings() {
    }

    public static WorkspaceSettings getInstance() {
        return INSTANCE;
    }

    public boolean getDontAskAgainSetting() {
        return DONT_ASK_AGAIN_TRUE_VALUE.equals(this.pss.readStringValue(PERSISTENT_SETTINGS_KEY_DONT_ASK_AGAIN));
    }

    public void setDontAskAgainSetting(boolean dontAskValue) {
        if (dontAskValue) {
            this.pss.saveStringValue(PERSISTENT_SETTINGS_KEY_DONT_ASK_AGAIN, DONT_ASK_AGAIN_TRUE_VALUE);
        } else {
            this.pss.delete(PERSISTENT_SETTINGS_KEY_DONT_ASK_AGAIN);
        }
    }

    public String getLastLocation() {
        return this.pss.readStringValue(PERSISTENT_SETTINGS_KEY_LAST_WORKSPACE);
    }

    String getRecentLocationData() {
        return this.pss.readStringValue(PERSISTENT_SETTINGS_KEY_RECENT_WORKSPACES);
    }

    void updateLocationHistory(String currentWorkspace, String recentLocationData) {
        this.pss.saveStringValue(PERSISTENT_SETTINGS_KEY_LAST_WORKSPACE, currentWorkspace);
        this.pss.saveStringValue(PERSISTENT_SETTINGS_KEY_RECENT_WORKSPACES, recentLocationData);
    }
}

