/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.scripting;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.types.api.BooleanTD;
import de.rcenvironment.core.datamodel.types.api.EmptyTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public final class ScriptDataTypeHelper {
    private static final int LONG_BIT_LENGTH = 64;

    @Deprecated
    private ScriptDataTypeHelper() {
    }

    public static Object getObjectOfEntryForPythonOrJython(TypedDatum typedDatumOfCell) {
        Object returnValue = null;
        if (typedDatumOfCell == null || typedDatumOfCell.getDataType() == DataType.Empty) {
            return "None";
        }
        switch (typedDatumOfCell.getDataType()) {
            case Boolean: {
                boolean bool = ((BooleanTD)typedDatumOfCell).getBooleanValue();
                if (bool) {
                    returnValue = "True";
                    break;
                }
                returnValue = "False";
                break;
            }
            case ShortText: {
                returnValue = StringEscapeUtils.escapeJava((String)((ShortTextTD)typedDatumOfCell).getShortTextValue());
                break;
            }
            case Integer: {
                returnValue = ((IntegerTD)typedDatumOfCell).getIntValue();
                break;
            }
            case Float: {
                returnValue = ((FloatTD)typedDatumOfCell).getFloatValue();
                break;
            }
            default: {
                returnValue = typedDatumOfCell.toString();
            }
        }
        return returnValue;
    }

    private static TypedDatum parseListValue(Object value, TypedDatumFactory typedDatumFactory, DataType requiredType) throws ComponentException {
        if (!(value instanceof List)) {
            throw new ComponentException(StringUtils.format((String)"Output value '%s' can not be parsed to an array based data type like Vector, Matrix or SmallTable.", (Object[])new Object[]{value.toString()}));
        }
        VectorTD returnValue = null;
        boolean matrixOrSmalltable = true;
        List list = (List)value;
        if (list.size() == 0) {
            throw new ComponentException(StringUtils.format((String)"Output value '%s' can not be parsed to an array based data type like Vector, Matrix or SmallTable, since it contains no elements.", (Object[])new Object[]{value.toString()}));
        }
        if (requiredType == DataType.Vector) {
            FloatTD[] values = new FloatTD[list.size()];
            int i = 0;
            while (i < list.size()) {
                FloatTD resolvedValue = ScriptDataTypeHelper.resolveValueToFloatTD(list.get(i), typedDatumFactory);
                if (resolvedValue == null) {
                    throw new ComponentException(StringUtils.format((String)"Failed to parse output value '%s' to data type Vector.", (Object[])new Object[]{value.toString()}));
                }
                values[i] = resolvedValue;
                ++i;
            }
            returnValue = typedDatumFactory.createVector(values);
            matrixOrSmalltable = false;
        } else {
            for (Object o : list) {
                if (!(o instanceof List)) {
                    matrixOrSmalltable = false;
                    throw new ComponentException(StringUtils.format((String)"Output value '%s' can not be parsed to a 2-dimensional  data type, like Matrix or SmallTable, since its elements must be stored as an array of arrays. However '%s'is not an array. ", (Object[])new Object[]{value.toString(), o.toString()}));
                }
                List tempList = (List)o;
                if (tempList.size() != 0) continue;
                throw new ComponentException(StringUtils.format((String)"Output value '%s' can not be parsed to a Matrix or SmallTable, since some rows contain no elements.", (Object[])new Object[]{value.toString()}));
            }
        }
        if (matrixOrSmalltable) {
            int columnDimension = ((List)list.get(0)).size();
            TypedDatum[][] values = new TypedDatum[list.size()][columnDimension];
            FloatTD[][] matrixValues = new FloatTD[list.size()][columnDimension];
            boolean isMatrix = requiredType == DataType.Matrix;
            boolean isSmallTable = requiredType == DataType.SmallTable;
            int i = 0;
            while (i < list.size()) {
                List row = (List)list.get(i);
                if (row.size() != columnDimension) {
                    throw new ComponentException(StringUtils.format((String)"Output value '%s' can not be parsed to a 2-dimensional data type, like Matrix or SmallTable, since the individual row dimensions are not constant.", (Object[])new Object[]{value.toString()}));
                }
                int j = 0;
                while (j < row.size()) {
                    if (isMatrix) {
                        matrixValues[i][j] = ScriptDataTypeHelper.resolveValueToFloatTD(row.get(j), typedDatumFactory);
                        if (matrixValues[i][j] == null) {
                            throw new ComponentException(StringUtils.format((String)"Output value '%s' can not be parsed to data type Matrix.The value of one of its cells (%s, %s) could not be parsed to a float.", (Object[])new Object[]{value.toString(), i, j}));
                        }
                    } else if (isSmallTable) {
                        values[i][j] = ScriptDataTypeHelper.resolveSimpleValue(row.get(j), typedDatumFactory);
                        if (values[i][j] == null) {
                            throw new ComponentException(StringUtils.format((String)"Output value '%s' can not be parsed to data type SmallTable. The value of one of its cells (%s, %s) could not be parsed to a valid datatype.", (Object[])new Object[]{value.toString(), i, j}));
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (isMatrix) {
                returnValue = typedDatumFactory.createMatrix(matrixValues);
            } else if (isSmallTable) {
                returnValue = typedDatumFactory.createSmallTable(values);
            }
        }
        return returnValue;
    }

    private static TypedDatum resolveValueToIntegerTD(Object value, TypedDatumFactory typedDatumFactory) {
        Object returnValue = null;
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(Integer.class)) {
            returnValue = typedDatumFactory.createInteger((long)((Integer)value).intValue());
        } else if (value.getClass().equals(Long.class)) {
            returnValue = typedDatumFactory.createInteger(((Long)value).longValue());
        } else if (value.getClass().equals(BigInteger.class)) {
            BigInteger newValue = (BigInteger)value;
            returnValue = newValue.bitLength() >= 64 ? null : typedDatumFactory.createInteger(newValue.longValue());
        }
        return returnValue;
    }

    private static FloatTD resolveValueToFloatTD(Object value, TypedDatumFactory typedDatumFactory) {
        FloatTD returnValue = null;
        if (value.getClass().equals(Integer.class)) {
            returnValue = typedDatumFactory.createFloat((double)((Integer)value).intValue());
        } else if (value.getClass().equals(Long.class)) {
            returnValue = typedDatumFactory.createFloat((double)((Long)value).longValue());
        } else if (value.getClass().equals(Double.class)) {
            returnValue = typedDatumFactory.createFloat(((Double)value).doubleValue());
        } else if (value.getClass().equals(Float.class)) {
            returnValue = typedDatumFactory.createFloat((double)((Float)value).floatValue());
        } else if (value.getClass().equals(BigInteger.class)) {
            returnValue = typedDatumFactory.createFloat(((BigInteger)value).doubleValue());
        } else if (value.getClass().equals(String.class)) {
            String castValue = (String)value;
            if (castValue.toString().equalsIgnoreCase("+Infinity") || castValue.toString().equalsIgnoreCase("Infinity")) {
                returnValue = typedDatumFactory.createFloat(Double.POSITIVE_INFINITY);
            }
            if (castValue.toString().equalsIgnoreCase("-Infinity")) {
                returnValue = typedDatumFactory.createFloat(Double.NEGATIVE_INFINITY);
            }
            if (castValue.toString().equalsIgnoreCase("NaN")) {
                returnValue = typedDatumFactory.createFloat(Double.NaN);
            }
        }
        return returnValue;
    }

    private static TypedDatum resolveValueToBooleanTD(Object value, TypedDatumFactory typedDatumFactory) {
        if (value == null) {
            return typedDatumFactory.createBoolean(false);
        }
        String stringValue = value.toString();
        BooleanTD returnValue = typedDatumFactory.createBoolean(false);
        boolean isNumber = true;
        try {
            double numberValue = Double.parseDouble(stringValue);
            if (Math.abs(numberValue) > 0.0) {
                returnValue = typedDatumFactory.createBoolean(true);
            } else if (Math.abs(numberValue) < 0.0) {
                returnValue = typedDatumFactory.createBoolean(false);
            } else {
                isNumber = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            isNumber = false;
        }
        if (!isNumber && (stringValue.equalsIgnoreCase("0") || stringValue.equalsIgnoreCase("0L") || stringValue.equalsIgnoreCase("0.0") || stringValue.equalsIgnoreCase("0j") || stringValue.equalsIgnoreCase("()") || stringValue.equalsIgnoreCase("[]") || stringValue.isEmpty() || stringValue.equalsIgnoreCase("{}") || stringValue.equalsIgnoreCase("false") || stringValue.equalsIgnoreCase("none"))) {
            returnValue = typedDatumFactory.createBoolean(false);
        } else if (!isNumber) {
            returnValue = typedDatumFactory.createBoolean(true);
        }
        return returnValue;
    }

    private static TypedDatum resolveSimpleValue(Object value, TypedDatumFactory typedDatumFactory) {
        String castValue;
        BigInteger newValue;
        Object returnValue = null;
        returnValue = value == null ? typedDatumFactory.createEmpty() : (value.getClass().equals(Integer.class) ? typedDatumFactory.createInteger((long)((Integer)value).intValue()) : (value.getClass().equals(Long.class) ? typedDatumFactory.createInteger(((Long)value).longValue()) : (value.getClass().equals(BigInteger.class) ? ((newValue = (BigInteger)value).bitLength() >= 64 ? null : typedDatumFactory.createInteger(newValue.longValue())) : (value.getClass().equals(Double.class) ? typedDatumFactory.createFloat(((Double)value).doubleValue()) : (value.getClass().equals(Float.class) ? typedDatumFactory.createFloat((double)((Float)value).floatValue()) : (value.getClass().equals(String.class) ? ((castValue = (String)value).toString().equalsIgnoreCase("+Infinity") || castValue.toString().equalsIgnoreCase("Infinity") ? typedDatumFactory.createFloat(Double.POSITIVE_INFINITY) : (castValue.toString().equalsIgnoreCase("-Infinity") ? typedDatumFactory.createFloat(Double.NEGATIVE_INFINITY) : (castValue.toString().equalsIgnoreCase("NaN") ? typedDatumFactory.createFloat(Double.NaN) : (castValue.toString().equalsIgnoreCase("true") ? typedDatumFactory.createBoolean(true) : (castValue.toString().equalsIgnoreCase("false") ? typedDatumFactory.createBoolean(false) : typedDatumFactory.createShortText(castValue)))))) : (value.getClass().equals(Boolean.class) ? typedDatumFactory.createBoolean(((Boolean)value).booleanValue()) : typedDatumFactory.createShortText(value.toString()))))))));
        if (value instanceof List) {
            return null;
        }
        return returnValue;
    }

    private static TypedDatum parseSimpleValue(Object value, TypedDatumFactory typedDatumFactory, DataType requiredType) throws ComponentException {
        EmptyTD returnValue = null;
        if (value == null) {
            returnValue = typedDatumFactory.createEmpty();
        }
        if (requiredType == null) {
            returnValue = ScriptDataTypeHelper.resolveSimpleValue(value, typedDatumFactory);
        } else if (requiredType == DataType.Integer) {
            returnValue = ScriptDataTypeHelper.resolveValueToIntegerTD(value, typedDatumFactory);
            if (returnValue == null) {
                throw new ComponentException(StringUtils.format((String)("Failed to parse output value '%s' to data type Integer. Possible reasons (not restricted): Output value too big (max. 2E" + Long.toBinaryString(Long.MAX_VALUE).length() + " - 1)," + " or output value contains non numeric characters."), (Object[])new Object[]{value.toString()}));
            }
        } else if (requiredType == DataType.Float) {
            returnValue = ScriptDataTypeHelper.resolveValueToFloatTD(value, typedDatumFactory);
            if (returnValue == null) {
                throw new ComponentException(StringUtils.format((String)"Failed to parse output value '%s' to data type Float. Possible reason(not restricted): Output value contains non numeric characters.", (Object[])new Object[]{value.toString()}));
            }
        } else if (requiredType == DataType.Boolean) {
            returnValue = ScriptDataTypeHelper.resolveValueToBooleanTD(value, typedDatumFactory);
        } else if (requiredType == DataType.ShortText) {
            returnValue = typedDatumFactory.createShortText(value.toString());
        }
        return returnValue;
    }

    public static TypedDatum parseToTypedDatum(Object value, TypedDatumFactory typedDatumFactory, DataType requiredType) throws ComponentException {
        TypedDatum returnValue = null;
        returnValue = requiredType == null ? (value instanceof List ? ScriptDataTypeHelper.parseListValue(value, typedDatumFactory, null) : ScriptDataTypeHelper.parseSimpleValue(value, typedDatumFactory, null)) : (requiredType == DataType.Vector || requiredType == DataType.Matrix || requiredType == DataType.SmallTable ? ScriptDataTypeHelper.parseListValue(value, typedDatumFactory, requiredType) : ScriptDataTypeHelper.parseSimpleValue(value, typedDatumFactory, requiredType));
        return returnValue;
    }
}

