/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSession;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSessionService;
import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.embedded.ssh.internal.SshAuthenticationManager;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;

public class SshUplinkCommandHandler
implements Command {
    private InputStream inputStream;
    private ExitCallback callback;
    private OutputStream outputStream;
    private OutputStream errorStream;
    private ServerSideUplinkSessionService serverSideUplinkSessionService;
    private SshAuthenticationManager authenticationManager;
    private final Log log = LogFactory.getLog(this.getClass());

    public SshUplinkCommandHandler(ServerSideUplinkSessionService serverSideUplinkSessionService, SshAuthenticationManager authenticationManager) {
        this.serverSideUplinkSessionService = serverSideUplinkSessionService;
        this.authenticationManager = authenticationManager;
    }

    public void start(ChannelSession channelSession, Environment env) throws IOException {
        String loginAccountName = (String)env.getEnv().get("USER");
        String clientInformationString = StringUtils.format((String)"SSH User \"%s\"", (Object[])new Object[]{loginAccountName});
        ServerSideUplinkSession session = this.serverSideUplinkSessionService.createServerSideSession(clientInformationString, loginAccountName, this.inputStream, this.outputStream);
        SshAccount userAccount = this.authenticationManager.getAccountByLoginName(loginAccountName, false);
        if (userAccount == null) {
            this.writeToStream(this.errorStream, "Invalid/unknown login name: " + loginAccountName);
            this.log.warn((Object)("Blocked unrecognized SSH account " + loginAccountName));
            this.callback.onExit(0);
        }
        if (this.authenticationManager.isAllowedToUseUplink(loginAccountName)) {
            ConcurrencyUtils.getAsyncTaskService().execute("SSH Uplink server: run session", () -> {
                boolean terminatedNormally = session.runSession();
                session.close();
                if (terminatedNormally) {
                    this.callback.onExit(0);
                } else {
                    this.callback.onExit(1);
                }
            });
        } else {
            this.log.warn((Object)("Blocked uplink access for account " + loginAccountName));
            this.callback.onExit(0);
        }
    }

    public void destroy(ChannelSession channelSession) {
        this.callback.onExit(0);
    }

    public void setInputStream(InputStream in) {
        this.inputStream = in;
    }

    public void setOutputStream(OutputStream out) {
        this.outputStream = out;
    }

    public void setErrorStream(OutputStream err) {
        this.errorStream = err;
    }

    public void setExitCallback(ExitCallback callbackParam) {
        this.callback = callbackParam;
    }

    private void writeToStream(OutputStream stream, String message) throws IOException {
        stream.write(message.getBytes(Charsets.UTF_8));
        stream.flush();
    }
}

