/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.WritableConfigurationSegment;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class WritableConfigurationSegmentImpl
implements WritableConfigurationSegment {
    private WritableConfigurationSegmentImpl rootSegment;
    private JsonNode segmentRootNode;
    private final Log log = LogFactory.getLog(this.getClass());

    WritableConfigurationSegmentImpl(JsonNode treeRoot) {
        this.segmentRootNode = treeRoot;
        this.rootSegment = this;
    }

    WritableConfigurationSegmentImpl(JsonNode treeRoot, WritableConfigurationSegmentImpl rootSegment) {
        this.segmentRootNode = treeRoot;
        this.rootSegment = rootSegment;
    }

    @Override
    public ConfigurationSegment getSubSegment(String relativePath) {
        JsonNode treeLocation = this.navigatePath(relativePath);
        return new WritableConfigurationSegmentImpl(treeLocation, this.rootSegment);
    }

    @Override
    public WritableConfigurationSegment getOrCreateWritableSubSegment(String relativePath) throws ConfigurationException {
        JsonNode treeLocation = this.createPath(relativePath);
        return new WritableConfigurationSegmentImpl(treeLocation, this.rootSegment);
    }

    @Override
    public WritableConfigurationSegment createElement(String id) throws ConfigurationException {
        return this.getOrCreateWritableSubSegment(id);
    }

    @Override
    public boolean deleteElement(String id) throws ConfigurationException {
        if (!(this.segmentRootNode instanceof ObjectNode)) {
            throw new ConfigurationException("Consistency error: segment node for deleteElement() is not an object node, but " + this.segmentRootNode.getClass());
        }
        JsonNode removed = ((ObjectNode)this.segmentRootNode).remove(id);
        return removed != null;
    }

    @Override
    public boolean isPresentInCurrentConfiguration() {
        return this.segmentRootNode != null;
    }

    @Override
    public String getString(String relativePath) {
        return this.getString(relativePath, null);
    }

    @Override
    public String getString(String relativePath, String defaultValue) {
        JsonNode treeLocation = this.navigatePath(relativePath);
        if (treeLocation != null) {
            return this.useDefaultValueIfNull(treeLocation.textValue(), defaultValue);
        }
        return defaultValue;
    }

    @Override
    public void setString(String name, String value) throws ConfigurationException {
        this.validateNodeExistsAndIsAnObjectNode();
        ((ObjectNode)this.segmentRootNode).put(name, value);
    }

    @Override
    public Long getLong(String relativePath) {
        return this.getLong(relativePath, null);
    }

    @Override
    public Long getLong(String relativePath, Long defaultValue) {
        JsonNode treeLocation = this.navigatePath(relativePath);
        if (treeLocation != null) {
            if (!treeLocation.isIntegralNumber()) {
                this.log.error((Object)("Expected an integer configuration value, but found \"" + treeLocation.asText() + "\"; treating it as the default value \"" + defaultValue + "\""));
                return defaultValue;
            }
            return treeLocation.longValue();
        }
        return defaultValue;
    }

    @Override
    public Integer getInteger(String relativePath) {
        return this.getInteger(relativePath, null);
    }

    @Override
    public Integer getInteger(String relativePath, Integer defaultValue) {
        JsonNode treeLocation = this.navigatePath(relativePath);
        if (treeLocation != null) {
            if (!treeLocation.isIntegralNumber()) {
                this.log.error((Object)("Expected an integer configuration value, but found \"" + treeLocation.asText() + "\"; treating it as the default value \"" + defaultValue + "\""));
                return defaultValue;
            }
            return treeLocation.intValue();
        }
        return defaultValue;
    }

    @Override
    public Double getDouble(String relativePath) {
        return this.getDouble(relativePath, null);
    }

    @Override
    public Double getDouble(String relativePath, Double defaultValue) {
        JsonNode treeLocation = this.navigatePath(relativePath);
        if (treeLocation != null) {
            return this.useDefaultValueIfNull(treeLocation.doubleValue(), defaultValue);
        }
        return defaultValue;
    }

    @Override
    public Boolean getBoolean(String relativePath) {
        return this.getBoolean(relativePath, null);
    }

    @Override
    public Boolean getBoolean(String relativePath, Boolean defaultValue) {
        JsonNode treeLocation = this.navigatePath(relativePath);
        if (treeLocation != null) {
            return this.useDefaultValueIfNull(treeLocation.booleanValue(), defaultValue);
        }
        return defaultValue;
    }

    @Override
    public void setBoolean(String key, boolean value) throws ConfigurationException {
        this.validateNodeExistsAndIsAnObjectNode();
        ((ObjectNode)this.segmentRootNode).put(key, value);
    }

    @Override
    public void setStringArray(String key, String[] value) throws ConfigurationException {
        this.validateNodeExistsAndIsAnObjectNode();
        ArrayNode newArrayNode = JsonNodeFactory.instance.arrayNode();
        String[] stringArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            newArrayNode.add(element);
            ++n2;
        }
        ((ObjectNode)this.segmentRootNode).put(key, (JsonNode)newArrayNode);
    }

    @Override
    public void setInteger(String key, Integer value) throws ConfigurationException {
        this.validateNodeExistsAndIsAnObjectNode();
        ((ObjectNode)this.segmentRootNode).put(key, value);
    }

    @Override
    public void setFloat(String key, Float value) throws ConfigurationException {
        this.validateNodeExistsAndIsAnObjectNode();
        ((ObjectNode)this.segmentRootNode).put(key, value);
    }

    @Override
    public void setLong(String key, Long value) throws ConfigurationException {
        this.validateNodeExistsAndIsAnObjectNode();
        ((ObjectNode)this.segmentRootNode).put(key, value);
    }

    @Override
    public List<String> getStringArray(String relativePath) throws ConfigurationException {
        this.validateNodeExistsAndIsAnObjectNode();
        ArrayList<String> list = new ArrayList<String>();
        for (JsonNode node : this.segmentRootNode.path(relativePath)) {
            list.add(node.asText());
        }
        return list;
    }

    @Override
    public Map<String, ConfigurationSegment> listElements(String relativePath) {
        HashMap<String, ConfigurationSegment> resultMap = new HashMap<String, ConfigurationSegment>();
        JsonNode treeLocation = this.navigatePath(relativePath);
        if (treeLocation == null) {
            return new HashMap<String, ConfigurationSegment>();
        }
        Iterator iterator = treeLocation.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            resultMap.put((String)entry.getKey(), new WritableConfigurationSegmentImpl((JsonNode)entry.getValue(), this.rootSegment));
        }
        return resultMap;
    }

    @Override
    public <T> T mapToObject(Class<T> clazz) throws IOException {
        try {
            if (this.segmentRootNode == null) {
                return clazz.newInstance();
            }
            return (T)JsonUtils.getDefaultObjectMapper().treeToValue((TreeNode)this.segmentRootNode, clazz);
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException e) {
            throw new IOException("Error parsing configuration", e);
        }
    }

    protected WritableConfigurationSegmentImpl getRootSegment() {
        return this.rootSegment;
    }

    public String toString() {
        if (this.segmentRootNode != null) {
            return this.segmentRootNode.toString();
        }
        return "<null root node>";
    }

    protected JsonNode getSegmentRootNode() {
        return this.segmentRootNode;
    }

    private JsonNode navigatePath(String relativePath) {
        if (this.segmentRootNode == null) {
            return null;
        }
        JsonNode treeLocation = this.segmentRootNode;
        String[] stringArray = relativePath.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pathSegment = stringArray[n2];
            if ((treeLocation = treeLocation.get(pathSegment)) == null) {
                return null;
            }
            ++n2;
        }
        return treeLocation;
    }

    private JsonNode createPath(String relativePath) throws ConfigurationException {
        if (this.segmentRootNode == null) {
            throw new ConfigurationException("Tried to create a new configuration segment from a non-existing one");
        }
        JsonNode treeLocation = this.segmentRootNode;
        String[] stringArray = relativePath.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            JsonNode oldTreeLocation = treeLocation;
            String pathSegment = stringArray[n2];
            if ((treeLocation = oldTreeLocation.get(pathSegment)) == null) {
                ObjectNode newObjectNode = JsonNodeFactory.instance.objectNode();
                ((ObjectNode)oldTreeLocation).put(pathSegment, (JsonNode)newObjectNode);
                treeLocation = newObjectNode;
            }
            ++n2;
        }
        return treeLocation;
    }

    private void validateNodeExistsAndIsAnObjectNode() throws ConfigurationException {
        if (!this.isPresentInCurrentConfiguration()) {
            throw new ConfigurationException("The parent segment must exist before new fields can be added");
        }
        if (!this.segmentRootNode.isObject()) {
            throw new ConfigurationException("The parent segment does not point to a valid configuration (JSON) node");
        }
    }

    private <T> T useDefaultValueIfNull(T value, T defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

