/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap;

import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public final class LoggingReconfigurationHelper {
    private static final String STAGE_TWO_LOG_APPENDER_CLASS = "de.rcenvironment.core.configuration.logging.EarlyLogInsertingAppender";
    private static final String ERROR_CONFIGURATION_ADMIN_SERVICE_IS_NOT_AVAILABLE = "Error while reconfiguring the logging: The Configuration Admin Service is not available.";
    private static final String PROPERTY_KEY_WARNINGS_LOG_DESTINATION = "log4j.appender.WARNINGS_LOG.File";
    private static final String PROPERTY_KEY_DEBUG_LOG_DESTINATION = "log4j.appender.DEBUG_LOG.File";
    private static final Log LOG = LogFactory.getLog(LoggingReconfigurationHelper.class);

    private LoggingReconfigurationHelper() {
    }

    public static void reconfigure(File basePath, String logfilesPrefix) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(LoggingReconfigurationHelper.class);
            if (bundle == null) {
                LOG.error((Object)ERROR_CONFIGURATION_ADMIN_SERVICE_IS_NOT_AVAILABLE);
                return;
            }
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                LOG.error((Object)ERROR_CONFIGURATION_ADMIN_SERVICE_IS_NOT_AVAILABLE);
                return;
            }
            String configurationAdminName = ConfigurationAdmin.class.getName();
            ServiceReference ref = bundleContext.getServiceReference(configurationAdminName);
            if (ref == null) {
                LOG.error((Object)ERROR_CONFIGURATION_ADMIN_SERVICE_IS_NOT_AVAILABLE);
                return;
            }
            ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(ref);
            Configuration configuration = configurationAdmin.getConfiguration("org.ops4j.pax.logging");
            Dictionary properties = configuration.getProperties();
            String earlyDebugLogLocation = StrSubstitutor.replaceSystemProperties(properties.get(PROPERTY_KEY_DEBUG_LOG_DESTINATION));
            String earlyWarningsLogLocation = StrSubstitutor.replaceSystemProperties(properties.get(PROPERTY_KEY_WARNINGS_LOG_DESTINATION));
            if (earlyDebugLogLocation == null || earlyWarningsLogLocation == null) {
                LOG.info((Object)"Standard debug and/or warning log file writing is disabled");
                return;
            }
            String logfilesBasePath = basePath.getAbsolutePath();
            String finalDebugLogLocation = StringUtils.format((String)"%s/%sdebug.log", (Object[])new Object[]{logfilesBasePath, logfilesPrefix});
            String finalWarningsLogLocation = StringUtils.format((String)"%s/%swarnings.log", (Object[])new Object[]{logfilesBasePath, logfilesPrefix});
            properties.put("log4j.appender.DEBUG_LOG", STAGE_TWO_LOG_APPENDER_CLASS);
            properties.put("log4j.appender.DEBUG_LOG.EarlyLogFileLocation", earlyDebugLogLocation);
            properties.put(PROPERTY_KEY_DEBUG_LOG_DESTINATION, finalDebugLogLocation);
            properties.put("log4j.appender.WARNINGS_LOG", STAGE_TWO_LOG_APPENDER_CLASS);
            properties.put("log4j.appender.WARNINGS_LOG.EarlyLogFileLocation", earlyWarningsLogLocation);
            properties.put(PROPERTY_KEY_WARNINGS_LOG_DESTINATION, finalWarningsLogLocation);
            configuration.update(properties);
            LOG.debug((Object)"Reconfigured the log system for writing to profile-specific log files");
        }
        catch (IOException e) {
            LOG.error((Object)"Error while switching from early log capture to profile-specific log files", (Throwable)e);
        }
    }
}

