/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.testutils;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.testutils.CommonVirtualInstanceControl;
import de.rcenvironment.core.communication.testutils.NodeConfigurationServiceTestStub;
import de.rcenvironment.core.communication.testutils.VirtualInstanceState;
import de.rcenvironment.core.communication.transport.spi.NetworkTransportProvider;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class VirtualInstanceSkeleton
implements CommonVirtualInstanceControl {
    private static final AsyncTaskService sharedThreadPool = ConcurrencyUtils.getAsyncTaskService();
    protected final InitialNodeInformation nodeInformation;
    protected final Log log = LogFactory.getLog(this.getClass());
    private final NodeConfigurationServiceTestStub nodeConfigurationService;
    private final StateMachine stateMachine = new StateMachine();

    public VirtualInstanceSkeleton(String predefinedInstanceId, String displayName, boolean isRelay) {
        this.nodeConfigurationService = new NodeConfigurationServiceTestStub(predefinedInstanceId, displayName, isRelay);
        this.nodeInformation = this.nodeConfigurationService.getInitialNodeInformation();
    }

    public void addServerConfigurationEntry(NetworkContactPoint contactPoint) {
        this.nodeConfigurationService.addServerConfigurationEntry(contactPoint);
    }

    @Override
    public void addInitialNetworkPeer(NetworkContactPoint contactPoint) {
        this.nodeConfigurationService.addInitialNetworkPeer(contactPoint);
    }

    public VirtualInstanceState getCurrentState() {
        return this.stateMachine.getCurrentState();
    }

    @Override
    public void setTargetState(VirtualInstanceState requestedState) throws InterruptedException {
        this.stateMachine.onTargetStateRequested(requestedState);
    }

    @Override
    public void waitForStateChangesToFinish() throws InterruptedException {
        this.stateMachine.waitForNonTransitionalState();
    }

    @Override
    public void start() throws InterruptedException {
        this.setTargetState(VirtualInstanceState.STARTED);
        this.waitForStateChangesToFinish();
    }

    @Override
    public void simulateCrash() throws InterruptedException {
        this.setTargetState(VirtualInstanceState.SIMULATED_CRASHING);
        this.waitForStateChangesToFinish();
    }

    @Override
    public void shutDown() throws InterruptedException {
        this.setTargetState(VirtualInstanceState.STOPPED);
        this.waitForStateChangesToFinish();
    }

    @Override
    public abstract void registerNetworkTransportProvider(NetworkTransportProvider var1);

    protected NodeConfigurationService getNodeConfigurationService() {
        return this.nodeConfigurationService;
    }

    protected abstract void performStartup() throws InterruptedException, CommunicationException;

    protected abstract void performShutdown() throws InterruptedException;

    protected abstract void performSimulatedCrash() throws InterruptedException;

    private class StateMachine {
        private VirtualInstanceState currentState = VirtualInstanceState.INITIAL;
        private Semaphore transitionalStateSemaphore = new Semaphore(1);

        private StateMachine() {
        }

        public synchronized void onTargetStateRequested(VirtualInstanceState requestedState) throws InterruptedException {
            switch (requestedState) {
                case STARTED: {
                    if (this.currentState == VirtualInstanceState.INITIAL || this.currentState == VirtualInstanceState.STOPPED) {
                        this.enterState(VirtualInstanceState.STARTING);
                        sharedThreadPool.execute("Communication Layer: Virtual instance startup", () -> {
                            try {
                                VirtualInstanceSkeleton.this.performStartup();
                                this.enterState(VirtualInstanceState.STARTED);
                            }
                            catch (InterruptedException e) {
                                VirtualInstanceSkeleton.this.log.debug((Object)"Virtual instance startup failed", (Throwable)e);
                            }
                            catch (CommunicationException e) {
                                VirtualInstanceSkeleton.this.log.debug((Object)"Virtual instance startup failed", (Throwable)e);
                            }
                        });
                        break;
                    }
                    VirtualInstanceSkeleton.this.log.warn((Object)("Virtual instance was instructed to 'start', but is in " + (Object)((Object)this.currentState) + " state"));
                    break;
                }
                case SIMULATED_CRASHING: {
                    if (this.currentState == VirtualInstanceState.STARTED) {
                        this.enterState(VirtualInstanceState.SIMULATED_CRASHING);
                        sharedThreadPool.execute("Communication Layer: Virtual instance crash simulation", () -> {
                            try {
                                VirtualInstanceSkeleton.this.performSimulatedCrash();
                                this.enterState(VirtualInstanceState.STOPPED);
                            }
                            catch (InterruptedException e) {
                                VirtualInstanceSkeleton.this.log.debug((Object)"Error while simulating virtual instance crash", (Throwable)e);
                            }
                        });
                        break;
                    }
                    VirtualInstanceSkeleton.this.log.warn((Object)("Virtual instance was commanded to 'crash', but in " + (Object)((Object)this.currentState) + " state (instead of STARTED)"));
                    break;
                }
                case STOPPED: {
                    if (this.currentState != VirtualInstanceState.STARTED) break;
                    this.enterState(VirtualInstanceState.STOPPING);
                    sharedThreadPool.execute("Communication Layer: Virtual instance shutdown", () -> {
                        try {
                            VirtualInstanceSkeleton.this.performShutdown();
                            this.enterState(VirtualInstanceState.STOPPED);
                        }
                        catch (InterruptedException e) {
                            VirtualInstanceSkeleton.this.log.debug((Object)"Virtual instance shutdown failed", (Throwable)e);
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid state request: " + (Object)((Object)requestedState));
                }
            }
        }

        public synchronized VirtualInstanceState getCurrentState() {
            return this.currentState;
        }

        public void waitForNonTransitionalState() throws InterruptedException {
            this.transitionalStateSemaphore.acquire();
            this.transitionalStateSemaphore.release();
        }

        private synchronized void enterState(VirtualInstanceState newState) throws InterruptedException {
            if (this.isTransitionalState(this.currentState)) {
                this.transitionalStateSemaphore.release();
            }
            if (this.isTransitionalState(newState)) {
                this.transitionalStateSemaphore.acquire();
            }
            this.currentState = newState;
        }

        private boolean isTransitionalState(VirtualInstanceState state) {
            return state == VirtualInstanceState.STARTING || state == VirtualInstanceState.STOPPING || state == VirtualInstanceState.SIMULATED_CRASHING;
        }
    }
}

