/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.sshconnection.internal;

import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.sshconnection.InitialSshConnectionConfig;
import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListener;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListenerAdapter;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.communication.sshconnection.impl.SshConnectionSetupImpl;
import de.rcenvironment.core.configuration.SecureStorageImportService;
import de.rcenvironment.core.configuration.SecureStorageSection;
import de.rcenvironment.core.configuration.SecureStorageService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.ThreadGuard;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class SshConnectionServiceImpl
implements SshConnectionService {
    private static final String NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED = "No SSH connection with id %s configured.";
    private final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private final Map<String, SshConnectionSetup> connectionSetups;
    private final Log log = LogFactory.getLog(this.getClass());
    private final AsyncOrderedCallbackManager<SshConnectionListener> callbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
    @Reference
    private NodeConfigurationService configurationService;
    @Reference
    private SecureStorageService secureStorageService;
    @Reference
    private SecureStorageImportService secureStorageImportService;
    private SecureStorageSection secureStorageSection;

    public SshConnectionServiceImpl() {
        this.connectionSetups = new HashMap<String, SshConnectionSetup>();
    }

    @Override
    public Session getAvtiveSshSession(String connectionId) {
        SshConnectionSetup setup = this.connectionSetups.get(connectionId);
        if (setup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return null;
        }
        return setup.getSession();
    }

    @Override
    public boolean sshConnectionAlreadyExists(SshConnectionContext context) {
        for (String s : this.connectionSetups.keySet()) {
            if (!this.connectionSetups.get(s).getHost().equals(context.getDestinationHost()) || this.connectionSetups.get(s).getPort() != context.getPort()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addSshConnection(SshConnectionContext context) {
        String connectionId = UUID.randomUUID().toString();
        SshConnectionListener listenerAdapter = this.defineListenerForSSHConnectionSetup();
        SshConnectionSetupImpl newSetup = new SshConnectionSetupImpl(connectionId, context.getDisplayName(), context.getDestinationHost(), context.getPort(), context.getSshAuthUser(), context.getKeyfileLocation(), context.isUsePassphrase(), context.isConnectImmediately(), context.isAutoRetry(), listenerAdapter);
        if (newSetup != null) {
            Map<String, SshConnectionSetup> map = this.connectionSetups;
            synchronized (map) {
                this.connectionSetups.put(connectionId, newSetup);
                final Collection<SshConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
                this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onCollectionChanged(snapshot);
                    }
                });
            }
        }
        return connectionId;
    }

    private SshConnectionListener defineListenerForSSHConnectionSetup() {
        SshConnectionListenerAdapter listenerAdapter = new SshConnectionListenerAdapter(){

            @Override
            public void onConnectionAttemptFailed(final SshConnectionSetup setup, final String reason, final boolean firstConsecutiveFailure, final boolean willAutoRetry) {
                if (willAutoRetry) {
                    SshConnectionServiceImpl.this.scheduleAutoRetry(setup);
                }
                SshConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onConnectionAttemptFailed(setup, reason, firstConsecutiveFailure, willAutoRetry);
                    }
                });
            }

            @Override
            public void onConnectionClosed(final SshConnectionSetup setup, final boolean willAutoRetry) {
                if (willAutoRetry) {
                    SshConnectionServiceImpl.this.scheduleAutoRetry(setup);
                }
                SshConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onConnectionClosed(setup, willAutoRetry);
                    }
                });
            }

            @Override
            public void onConnected(final SshConnectionSetup setup) {
                SshConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onConnected(setup);
                    }
                });
            }

            @Override
            public void onCreated(final SshConnectionSetup setup) {
                SshConnectionServiceImpl.this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onCreated(setup);
                    }
                });
            }
        };
        return listenerAdapter;
    }

    private void scheduleAutoRetry(SshConnectionSetup setup) {
        this.log.debug((Object)StringUtils.format((String)"Scheduling auto-retry of connection %s in %d msec", (Object[])new Object[]{setup.getDisplayName(), 5000}));
        this.threadPool.scheduleAfterDelay("Communication Layer: SshConnectionService auto-reconnect timer", () -> {
            if (setup.isWaitingForRetry()) {
                this.connectSession(setup.getId());
            }
        }, 5000L);
        setup.setWaitingForRetry(true);
    }

    @Override
    public boolean isConnected(String connectionId) {
        return this.connectionSetups.get(connectionId).isConnected();
    }

    @Override
    public boolean isWaitingForRetry(String connectionId) {
        return this.connectionSetups.get(connectionId).isWaitingForRetry();
    }

    @Override
    public Session connectSession(String connectionId) {
        ThreadGuard.checkForForbiddenThread();
        String passphrase = "";
        if (this.connectionSetups.get(connectionId).getUsePassphrase()) {
            passphrase = this.retrieveSshConnectionPassword(connectionId);
        }
        return this.connectSession(connectionId, passphrase);
    }

    @Override
    public Session connectSession(String connectionId, String passphrase) {
        ThreadGuard.checkForForbiddenThread();
        SshConnectionSetup sshConnectionSetup = this.connectionSetups.get(connectionId);
        if (sshConnectionSetup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return null;
        }
        return sshConnectionSetup.connect(passphrase);
    }

    @Override
    public void disconnectSession(String connectionId) {
        final SshConnectionSetup sshConnectionSetup = this.connectionSetups.get(connectionId);
        if (sshConnectionSetup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return;
        }
        if (sshConnectionSetup.isConnected()) {
            sshConnectionSetup.disconnect();
        } else if (sshConnectionSetup.isWaitingForRetry()) {
            sshConnectionSetup.setWaitingForRetry(false);
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                public void performCallback(SshConnectionListener listener) {
                    listener.onConnectionClosed(sshConnectionSetup, false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeConnection(String connectionId) {
        final SshConnectionSetup setup = this.connectionSetups.get(connectionId);
        if (setup == null) {
            this.log.warn((Object)StringUtils.format((String)NO_SSH_CONNECTION_WITH_ID_S_CONFIGURED, (Object[])new Object[]{connectionId}));
            return;
        }
        if (setup.isConnected()) {
            setup.disconnect();
        } else if (setup.isWaitingForRetry()) {
            setup.setWaitingForRetry(false);
        }
        Map<String, SshConnectionSetup> map = this.connectionSetups;
        synchronized (map) {
            this.connectionSetups.remove(connectionId);
            final Collection<SshConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                public void performCallback(SshConnectionListener listener) {
                    listener.onDisposed(setup);
                    listener.onCollectionChanged(snapshot);
                }
            });
        }
    }

    @Override
    public SshConnectionSetup getConnectionSetup(String connnectionId) {
        return this.connectionSetups.get(connnectionId);
    }

    @Override
    public Collection<SshConnectionSetup> getAllSshConnectionSetups() {
        return Collections.unmodifiableCollection(this.connectionSetups.values());
    }

    @Override
    public Map<String, SshConnectionSetup> getAllActiveSshConnectionSetups() {
        HashMap<String, SshConnectionSetup> activeConnections = new HashMap<String, SshConnectionSetup>();
        for (SshConnectionSetup connection : this.connectionSetups.values()) {
            if (!connection.isConnected()) continue;
            activeConnections.put(connection.getId(), connection);
        }
        return activeConnections;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="removeListener")
    public void addListener(SshConnectionListener listener) {
        this.callbackManager.addListener((Object)listener);
    }

    public void removeListener(SshConnectionListener listener) {
        this.callbackManager.removeListener((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editSshConnection(SshConnectionContext context) {
        SshConnectionListener listenerAdapter = this.defineListenerForSSHConnectionSetup();
        SshConnectionSetupImpl newSetup = new SshConnectionSetupImpl(context.getId(), context.getDisplayName(), context.getDestinationHost(), context.getPort(), context.getSshAuthUser(), context.getKeyfileLocation(), context.isUsePassphrase(), context.isConnectImmediately(), context.isAutoRetry(), listenerAdapter);
        if (newSetup != null) {
            Map<String, SshConnectionSetup> map = this.connectionSetups;
            synchronized (map) {
                this.connectionSetups.put(context.getId(), newSetup);
                final Collection<SshConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
                this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onCollectionChanged(snapshot);
                    }
                });
            }
        }
    }

    @Override
    public Collection<String> getAllActiveSshConnectionSetupIds() {
        return this.getAllActiveSshConnectionSetups().keySet();
    }

    @Activate
    public void activate() {
        File importFilesDir = this.configurationService.getStandardImportDirectory("ra-pws");
        try {
            this.secureStorageImportService.processImportDirectory(importFilesDir, "SSHConnectionsPasswords", null, null, true, true);
        }
        catch (OperationFailureException e) {
            this.log.warn((Object)("Error while attempting to import SSH Remote Access connection passwords from " + importFilesDir + ": " + e.getMessage()));
        }
        try {
            this.secureStorageSection = this.secureStorageService.getSecureStorageSection("SSHConnectionsPasswords");
        }
        catch (IOException iOException) {
            this.log.error((Object)"Failed to initialize secure storage");
        }
        ConcurrencyUtils.getAsyncTaskService().execute("Client-Side Remote Access: Add pre-configured SSH connections", () -> this.addAndConnectInitialSshConfigs(this.configurationService.getInitialSSHConnectionConfigs()));
    }

    private void addAndConnectInitialSshConfigs(List<InitialSshConnectionConfig> configs) {
        ThreadGuard.checkForForbiddenThread();
        for (InitialSshConnectionConfig config : configs) {
            SshConnectionSetupImpl setup = new SshConnectionSetupImpl(config.getId(), config.getDisplayName(), config.getHost(), config.getPort(), config.getUser(), config.getKeyFileLocation(), config.getUsePassphrase(), config.getConnectOnStartup(), config.getAutoRetry(), this.defineListenerForSSHConnectionSetup());
            this.connectionSetups.put(config.getId(), setup);
            if (!config.getConnectOnStartup()) continue;
            if (config.getUsePassphrase()) {
                setup.connect(this.retrieveSshConnectionPassword(setup.getId()));
                continue;
            }
            setup.connect("");
        }
    }

    private void storeSshConnectionPassword(String connectionId, String password) {
        try {
            this.secureStorageSection.store(connectionId, password);
        }
        catch (OperationFailureException e) {
            this.log.error((Object)("Could not store password: " + (Object)((Object)e)));
        }
    }

    private void removeSshConnectionPasswordIfExists(String connectionId) {
        try {
            this.secureStorageSection.delete(connectionId);
        }
        catch (OperationFailureException e) {
            this.log.error((Object)("Could not remove password: " + (Object)((Object)e)));
        }
    }

    @Override
    public String retrieveSshConnectionPassword(String connectionId) {
        String passphrase = null;
        try {
            passphrase = this.secureStorageSection.read(connectionId, null);
        }
        catch (OperationFailureException e) {
            this.log.error((Object)("Could not retrieve password: " + (Object)((Object)e)));
            return null;
        }
        return passphrase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAuthPhraseForSshConnection(String id, String sshAuthPassPhrase, boolean storePassphrase) {
        SshConnectionListener listenerAdapter = this.defineListenerForSSHConnectionSetup();
        SshConnectionSetup oldSetup = this.connectionSetups.get(id);
        SshConnectionSetupImpl newSetup = new SshConnectionSetupImpl(id, oldSetup.getDisplayName(), oldSetup.getHost(), oldSetup.getPort(), oldSetup.getUsername(), oldSetup.getKeyfileLocation(), oldSetup.getUsePassphrase(), oldSetup.getConnectOnStartUp(), oldSetup.getAutoRetry(), listenerAdapter);
        if (newSetup != null) {
            Map<String, SshConnectionSetup> map = this.connectionSetups;
            synchronized (map) {
                this.connectionSetups.put(id, newSetup);
                final Collection<SshConnectionSetup> snapshot = Collections.unmodifiableCollection(this.connectionSetups.values());
                this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<SshConnectionListener>(){

                    public void performCallback(SshConnectionListener listener) {
                        listener.onCollectionChanged(snapshot);
                    }
                });
            }
            if (storePassphrase) {
                this.storeSshConnectionPassword(id, sshAuthPassPhrase);
            } else {
                this.removeSshConnectionPasswordIfExists(id);
            }
        }
    }
}

