/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkGraph;
import de.rcenvironment.core.communication.common.NetworkGraphLink;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.model.NetworkRoutingInformation;
import de.rcenvironment.core.communication.protocol.MessageMetaData;
import de.rcenvironment.core.communication.routing.internal.LinkStateAdvertisement;
import de.rcenvironment.core.communication.routing.internal.LinkStateAdvertisementBatch;
import de.rcenvironment.core.communication.routing.internal.NetworkRoute;
import de.rcenvironment.core.communication.routing.internal.NetworkStats;
import de.rcenvironment.core.communication.routing.internal.TopologyLink;
import de.rcenvironment.core.communication.routing.internal.TopologyMap;
import de.rcenvironment.core.communication.routing.internal.TopologyNode;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.GraphvizUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class NetworkFormatter {
    private static final String GRAPHVIZ_STYLE_KEY = "style";
    private static final String GRAPHVIZ_STYLE_VALUE_DASHED = "dashed";
    private static final String GRAPHVIZ_STYLE_VALUE_BOLD = "bold";

    private NetworkFormatter() {
    }

    public static String linkList(TopologyMap networkGraph) {
        return NetworkFormatter.linkList(networkGraph.getAllLinks());
    }

    public static String linkList(Collection<TopologyLink> linkCollection) {
        String result = "";
        ArrayList<TopologyLink> linkList = new ArrayList<TopologyLink>(linkCollection);
        Collections.sort(linkList);
        for (TopologyLink link : linkList) {
            result = String.valueOf(result) + StringUtils.format((String)"  %s --[%s]--> %s (Hash=%s)\n", (Object[])new Object[]{link.getSource().getInstanceNodeSessionIdString(), link.getConnectionId(), link.getDestination().getInstanceNodeSessionIdString(), link.hashCode()});
        }
        return result;
    }

    public static String nodeList(TopologyMap networkGraph) {
        String result = "";
        ArrayList<TopologyNode> networkNodes = new ArrayList<TopologyNode>(networkGraph.getNodes());
        Collections.sort(networkNodes);
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
        for (TopologyNode networkNode : networkNodes) {
            String nodeIdInfo = networkNode.getNodeIdentifier().getInstanceNodeSessionIdString();
            if (nodeIdInfo.equals(networkGraph.getLocalNodeId().getInstanceNodeSessionIdString())) {
                nodeIdInfo = String.valueOf(nodeIdInfo) + "*";
            }
            result = String.valueOf(result) + StringUtils.format((String)"  [%9$s] %1$s, --%4$s-> * --%5$s->, '%8$s', Seq=%2$s, Created=%3$tk:%3$tM:%3$tS, Conv=%6$s, Hash=%7$s\n", (Object[])new Object[]{nodeIdInfo, String.valueOf(networkNode.getSequenceNumber()) + " (" + timestampFormat.format(new Date(networkNode.getSequenceNumber())) + ")", networkNode.getCreatedTime(), networkGraph.getPredecessors(networkNode).size(), networkGraph.getSuccessors(networkNode).size(), networkNode.getLastGraphHashCode() == networkGraph.hashCode(), networkNode.hashCode(), networkNode.getDisplayName(), networkNode.getIsWorkflowHost()});
        }
        return result;
    }

    public static String graphMetaData(TopologyMap networkGraph) {
        return StringUtils.format((String)"  Local Node Id: %s, Nodes: %s, Links: %s, Fully conv.: %s, Hash=%s\n", (Object[])new Object[]{networkGraph.getLocalNodeId().getInstanceNodeSessionIdString(), networkGraph.getNodeCount(), networkGraph.getLinkCount(), networkGraph.hasSameTopologyHashesForAllNodes(), networkGraph.hashCode()});
    }

    public static String summary(TopologyMap networkGraph) {
        return StringUtils.format((String)"Topology Metadata:\n%sKnown Nodes:\n%sLinks:\n%s", (Object[])new Object[]{NetworkFormatter.graphMetaData(networkGraph), NetworkFormatter.nodeList(networkGraph), NetworkFormatter.linkList(networkGraph)});
    }

    public static String topologyToGraphviz(TopologyMap topologyMap) {
        GraphvizUtils.DotFileBuilder builder = GraphvizUtils.createDotFileBuilder((String)"rce_network");
        ArrayList<TopologyNode> networkNodes = new ArrayList<TopologyNode>(topologyMap.getNodes());
        HashMap<String, String> backwardEdgeProperties = new HashMap<String, String>();
        backwardEdgeProperties.put(GRAPHVIZ_STYLE_KEY, GRAPHVIZ_STYLE_VALUE_DASHED);
        for (TopologyNode networkNode : networkNodes) {
            String vertexId = networkNode.getNodeIdentifier().getInstanceNodeIdString();
            String label = networkNode.getDisplayName();
            builder.addVertex(vertexId, label);
        }
        ArrayList<TopologyLink> linkList = new ArrayList<TopologyLink>(topologyMap.getAllLinks());
        for (TopologyLink link : linkList) {
            String edgeId = link.getConnectionId();
            String label = edgeId.substring(0, edgeId.indexOf(45));
            if (label.endsWith("s")) {
                builder.addEdge(link.getSource().getInstanceNodeIdString(), link.getDestination().getInstanceNodeIdString(), label);
                continue;
            }
            builder.addEdge(link.getSource().getInstanceNodeIdString(), link.getDestination().getInstanceNodeIdString(), label, backwardEdgeProperties);
        }
        String localNodeId = topologyMap.getLocalNodeId().getInstanceNodeIdString();
        builder.addVertexProperty(localNodeId, GRAPHVIZ_STYLE_KEY, GRAPHVIZ_STYLE_VALUE_BOLD);
        return builder.getScriptContent();
    }

    public static String message(Serializable messageContent, Map<String, String> metaData) {
        MessageMetaData handler = MessageMetaData.wrap(metaData);
        return StringUtils.format((String)"Src='%s', Dst='%s', Body='%s', HopC=%d, MsgId='%s', Trace='%s'", (Object[])new Object[]{handler.getSender(), handler.getFinalRecipient(), messageContent.toString(), handler.getHopCount(), handler.getMessageId(), handler.getTrace()});
    }

    public static String lsa(LinkStateAdvertisement lsa) {
        return StringUtils.format((String)"owner=%s, links=%s, seq=%s, type=%s, hash=%s\n%s", (Object[])new Object[]{lsa.getOwner(), lsa.getLinks().size(), lsa.getSequenceNumber(), lsa.getReason(), lsa.getGraphHashCode(), NetworkFormatter.linkList(lsa.getLinks())});
    }

    public static String lsaCache(LinkStateAdvertisementBatch lsaCache) {
        String result = StringUtils.format((String)"size=%s\n", (Object[])new Object[]{lsaCache.size()});
        for (LinkStateAdvertisement lsa : lsaCache.values()) {
            result = String.valueOf(result) + NetworkFormatter.lsa(lsa) + "\n";
        }
        return result;
    }

    public static String networkRoute(NetworkRoute networkRoute) {
        String result = StringUtils.format((String)"length: %s, %s, time: %s ms", (Object[])new Object[]{networkRoute.getPath().size(), networkRoute.getSource().getInstanceNodeSessionIdString(), networkRoute.getComputationalEffort()});
        for (TopologyLink link : networkRoute.getPath()) {
            result = String.valueOf(result) + StringUtils.format((String)" --> %s", (Object[])new Object[]{link.getDestination().getInstanceNodeSessionIdString()});
        }
        return result;
    }

    public static String networkStats(NetworkStats networkStats) {
        return StringUtils.format((String)"\nSuccessful communications: %s\nFailed communications: %s\n\nLSAs send:     %s\nLSAs received: %s\nLSAs rejected: %s\n\nMax received hop count:     %s\nMax time to live:           %s\nNumber of computed routes:  %s\n\nAverage hop count of send LSAs:     %s\nAverage hop count of received LSAs: %s\nAverage hop count of rejected LSAs: %s\n", (Object[])new Object[]{networkStats.getSuccessfulCommunications(), networkStats.getFailedCommunications(), networkStats.getSentLSAs(), networkStats.getReceivedLSAs(), networkStats.getRejectedLSAs(), networkStats.getMaxReceivedHopCount(), networkStats.getMaxTimeToLive(), networkStats.getShortestPathComputations(), networkStats.averageHopCountOfSentLSAs(), networkStats.averageHopCountOfReceivedLSAs(), networkStats.averageHopCountOfRejectedLSAs()});
    }

    public static String networkResponseToString(NetworkResponse networkResponse) {
        return StringUtils.format((String)"id=%s, succ=%s, code=%s, header=%s", (Object[])new Object[]{networkResponse.getRequestId(), networkResponse.isSuccess(), networkResponse.getResultCode(), networkResponse.accessRawMetaData().toString()});
    }

    public static String formatTopologyMap(TopologyMap topologyMap, boolean extendedInfo) {
        return StringUtils.format((String)"Nodes:\n%sConnections:\n%s", (Object[])new Object[]{NetworkFormatter.formatTopologyNodes(topologyMap, extendedInfo), NetworkFormatter.formatTopologyLinks(topologyMap, extendedInfo)});
    }

    public static String networkGraphToConsoleInfo(NetworkGraph networkGraph) {
        StringBuilder buffer = new StringBuilder();
        ArrayList<InstanceNodeSessionId> networkNodes = new ArrayList<InstanceNodeSessionId>(networkGraph.getNodeIds());
        buffer.append("Reachable network nodes (" + networkNodes.size() + " total):\n");
        for (InstanceNodeSessionId instanceNodeSessionId : networkNodes) {
            buffer.append(StringUtils.format((String)"  %s [%s]\n", (Object[])new Object[]{instanceNodeSessionId.getAssociatedDisplayName(), instanceNodeSessionId.getInstanceNodeSessionIdString()}));
        }
        buffer.append("Message channels (" + networkGraph.getLinkCount() + " total):\n");
        for (NetworkGraphLink networkGraphLink : networkGraph.getLinks()) {
            buffer.append(StringUtils.format((String)"  %s--[%s]->[%s]\n", (Object[])new Object[]{networkGraphLink.getSourceNodeId(), networkGraphLink.getLinkId(), networkGraphLink.getTargetNodeId()}));
        }
        return buffer.toString();
    }

    public static String networkGraphToGraphviz(NetworkGraph networkGraph, boolean markSpanningTree) {
        Set<Object> spanningTreeLinks;
        GraphvizUtils.DotFileBuilder builder = GraphvizUtils.createDotFileBuilder((String)"rce_network");
        ArrayList<InstanceNodeSessionId> networkNodes = new ArrayList<InstanceNodeSessionId>(networkGraph.getNodeIds());
        if (markSpanningTree) {
            NetworkRoutingInformation routingInformation = networkGraph.getRoutingInformation();
            if (routingInformation == null) {
                throw new IllegalArgumentException("Spanning tree requested for a graph without routing information");
            }
            spanningTreeLinks = routingInformation.getSpanningTreeLinks();
        } else {
            spanningTreeLinks = new HashSet();
        }
        for (InstanceNodeSessionId nodeId : networkNodes) {
            String string = nodeId.getInstanceNodeIdString();
            String label = nodeId.getAssociatedDisplayName();
            builder.addVertex(string, label);
        }
        ArrayList<? extends NetworkGraphLink> linkList = new ArrayList<NetworkGraphLink>(networkGraph.getLinks());
        StringBuilder styleBuilder = new StringBuilder();
        for (NetworkGraphLink networkGraphLink : linkList) {
            String edgeId = networkGraphLink.getLinkId();
            String label = edgeId.substring(0, edgeId.indexOf(45));
            HashMap<String, String> edgeProperties = new HashMap<String, String>();
            if (label.endsWith("r")) {
                styleBuilder.append(GRAPHVIZ_STYLE_VALUE_DASHED);
            }
            if (spanningTreeLinks.contains(networkGraphLink)) {
                if (styleBuilder.length() != 0) {
                    styleBuilder.append(",");
                }
                styleBuilder.append(GRAPHVIZ_STYLE_VALUE_BOLD);
            }
            edgeProperties.put(GRAPHVIZ_STYLE_KEY, styleBuilder.toString());
            styleBuilder.setLength(0);
            builder.addEdge(networkGraphLink.getSourceNodeId().getInstanceNodeIdString(), networkGraphLink.getTargetNodeId().getInstanceNodeIdString(), label, edgeProperties);
        }
        String string = networkGraph.getLocalNodeId().getInstanceNodeIdString();
        builder.addVertexProperty(string, GRAPHVIZ_STYLE_KEY, GRAPHVIZ_STYLE_VALUE_BOLD);
        return builder.getScriptContent();
    }

    private static String formatTopologyNodes(TopologyMap topologyMap, boolean extendedInfo) {
        InstanceNodeSessionId localNodeId = topologyMap.getLocalNodeId();
        Set<InstanceNodeSessionId> reachableNodes = topologyMap.getIdsOfReachableNodes(false);
        ArrayList<TopologyNode> topologyNodes = new ArrayList<TopologyNode>(topologyMap.getNodes());
        StringBuilder result = new StringBuilder();
        Collections.sort(topologyNodes);
        for (TopologyNode topologyNode : topologyNodes) {
            InstanceNodeSessionId nodeId = topologyNode.getNodeIdentifier();
            if (!reachableNodes.contains(nodeId)) continue;
            String markers = "";
            if (nodeId.equals(localNodeId)) {
                markers = String.valueOf(markers) + " <self>";
            }
            result.append(StringUtils.format((String)"  %s%s\n", (Object[])new Object[]{nodeId, markers}));
        }
        return result.toString();
    }

    private static String formatTopologyLinks(TopologyMap topologyMap, boolean extendedInfo) {
        StringBuilder result = new StringBuilder();
        ArrayList<TopologyLink> linkList = new ArrayList<TopologyLink>(topologyMap.getAllLinks());
        Collections.sort(linkList);
        for (TopologyLink link : linkList) {
            result.append(StringUtils.format((String)"  %s --[%s]--> %s\n", (Object[])new Object[]{link.getSource(), link.getConnectionId(), link.getDestination()}));
        }
        return result.toString();
    }
}

