/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.internal;

import de.rcenvironment.core.communication.uplink.client.session.api.UplinkConnection;
import de.rcenvironment.core.communication.uplink.network.internal.CommonUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionLowLevelEventHandler;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionRefusedException;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientSideUplinkLowLevelProtocolWrapper
extends CommonUplinkLowLevelProtocolWrapper {
    private final UplinkConnection connection;
    private CompletableFuture<MessageBlock> handshakeResponseFuture;
    private boolean connectionClosedWithError;

    public ClientSideUplinkLowLevelProtocolWrapper(UplinkConnection connection, UplinkConnectionLowLevelEventHandler eventHandler) {
        super(eventHandler, "client session protocol wrapper");
        this.connection = connection;
    }

    @Override
    public void runSession() {
        block5: {
            this.handshakeResponseFuture = new CompletableFuture();
            try {
                MessageBlock responseMessageBlock;
                this.dataOutputStream = new DataOutputStream(this.connection.open(this::onIncomingStreamAvailable, this::onRemoteErrorMessage));
                this.sendHandshakeInit();
                this.sendHandshakeData(this.generateHandshakeData());
                try {
                    responseMessageBlock = this.awaitHandshakeResponseDataFromInputThread(2000L);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IOException("Error while waiting for the server's handshake response: " + e.toString());
                }
                catch (TimeoutException timeoutException) {
                    throw new IOException("The server did not send a handshake response within 2000 msec");
                }
                this.processHandshakeResponse(responseMessageBlock);
                this.sendHandshakeConfirmation();
                this.eventHandler.onHandshakeComplete();
                this.runMessageReceiveLoop();
            }
            catch (IOException e) {
                if (!this.registerAsFirstCriticalError()) break block5;
                this.eventHandler.onNonProtocolError(e);
            }
        }
    }

    @Override
    public void closeOutgoingMessageStream() {
        this.closeOutgoingDataStream();
    }

    private void onIncomingStreamAvailable(InputStream incomingStream) {
        block4: {
            try {
                this.dataInputStream = new DataInputStream(incomingStream);
                this.expectHandshakeInit();
                MessageBlock response = this.expectHandshakeData();
                this.handshakeResponseFuture.complete(response);
            }
            catch (IOException e) {
                if (this.registerAsFirstCriticalError()) {
                    this.eventHandler.onNonProtocolError(e);
                }
            }
            catch (UplinkConnectionRefusedException e) {
                if (!this.registerAsFirstCriticalError()) break block4;
                this.eventHandler.onErrorGoodbyeMessage(e.getType(), e.getRawMessage());
            }
        }
    }

    private void onRemoteErrorMessage(String errorMessage) {
        this.log.warn((Object)("Uplink connection error: " + errorMessage));
    }

    private MessageBlock awaitHandshakeResponseDataFromInputThread(long timeoutMsec) throws InterruptedException, TimeoutException, ExecutionException {
        MessageBlock responseBytes = this.handshakeResponseFuture.get(timeoutMsec, TimeUnit.MILLISECONDS);
        this.handshakeResponseFuture = null;
        return responseBytes;
    }

    private MessageBlock generateHandshakeData() throws ProtocolException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            this.eventHandler.provideOrProcessHandshakeData(null, dataMap);
        }
        catch (UplinkConnectionRefusedException uplinkConnectionRefusedException) {
            throw new IllegalStateException("Unexpected internal error: The client should never fail to produce its handshake data");
        }
        return this.messageConverter.encodeHandshakeData(dataMap);
    }

    private void processHandshakeResponse(MessageBlock responseMessageBlock) throws IOException {
        Map<String, String> handshakeResponseData = this.messageConverter.decodeHandshakeData(responseMessageBlock);
        try {
            this.eventHandler.provideOrProcessHandshakeData(handshakeResponseData, null);
        }
        catch (UplinkConnectionRefusedException e) {
            throw new IOException("Unexpected error while processing the relay's handshake response: " + e.getMessage());
        }
    }

    private synchronized boolean registerAsFirstCriticalError() {
        boolean result = !this.connectionClosedWithError;
        this.connectionClosedWithError = true;
        return result;
    }
}

