/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import de.rcenvironment.components.switchcmp.gui.Messages;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;

public class SwitchDataInputSelectionPane
extends EndpointSelectionPane {
    private EndpointSelectionPane[] panes;

    public SwitchDataInputSelectionPane(WorkflowNodeCommand.Executor executor) {
        super(Messages.dataInputString, EndpointType.INPUT, null, new String[0], new String[]{"To_forward"}, executor);
    }

    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription) {
        super.executeEditCommand(oldDescription, newDescription);
        SwitchEditDynamicEndpointCommand command = new SwitchEditDynamicEndpointCommand(this.endpointType, newDescription, newDescription, (Refreshable[])this.panes);
        this.execute((WorkflowNodeCommand)command);
    }

    public void setAllPanes(EndpointSelectionPane[] allPanes) {
        this.panes = allPanes;
    }

    private class SwitchEditDynamicEndpointCommand
    extends EditDynamicEndpointCommand {
        SwitchEditDynamicEndpointCommand(EndpointType direction, EndpointDescription oldDescription, EndpointDescription newDescription, Refreshable[] refreshable) {
            super(direction, oldDescription, newDescription, refreshable);
        }

        public void execute() {
            WorkflowNode workflowNode = this.getWorkflowNode();
            super.execute();
            for (EndpointDescription outputDesc : workflowNode.getOutputDescriptionsManager().getStaticEndpointDescriptions()) {
                workflowNode.getOutputDescriptionsManager().editStaticEndpointDescription(outputDesc.getName(), this.newDesc.getDataType(), this.newDesc.getMetaData());
            }
            if (this.refreshable != null) {
                Refreshable[] refreshableArray = this.refreshable;
                int n = this.refreshable.length;
                int n2 = 0;
                while (n2 < n) {
                    Refreshable r = refreshableArray[n2];
                    r.refresh();
                    ++n2;
                }
            }
        }
    }
}

