/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.scpoutputcollector.execution;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.api.LocalExecutionOnly;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@LocalExecutionOnly
public class ScpOutputCollectorComponent
extends DefaultComponent {
    private static final String UNDERSCORE = "_";
    private ComponentContext componentContext;
    private ComponentDataManagementService dataManagementService;
    private TypedDatumSerializer serializer;
    private ObjectMapper mapper;
    private Map<String, List<String>> inputsMap;
    private File downloadDir;
    private File outputsFile;
    private Log log;
    private boolean uncompressedDownload;
    private boolean simpleDescriptionFormat;
    private TempFileService tempFileService = TempFileServiceAccess.getInstance();
    private static /* synthetic */ int[] $SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public void start() throws ComponentException {
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        this.serializer = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getSerializer();
        this.mapper = new ObjectMapper();
        this.inputsMap = new HashMap<String, List<String>>();
        this.downloadDir = new File(this.componentContext.getConfigurationValue("DownloadDirectory"));
        this.downloadDir.mkdirs();
        this.uncompressedDownload = Boolean.valueOf(this.componentContext.getConfigurationValue("UncompressedDownload"));
        this.simpleDescriptionFormat = Boolean.valueOf(this.componentContext.getConfigurationValue("SimpleDescriptionFormat"));
    }

    /*
     * Unable to fully structure code
     */
    public void processInputs() throws ComponentException {
        block21: {
            try {
                if (this.componentContext == null || this.componentContext.getInputsWithDatum() == null) break block21;
                for (String inputName : this.componentContext.getInputsWithDatum()) {
                    input = this.componentContext.readInput(inputName);
                    if (!this.inputsMap.containsKey(inputName)) {
                        this.inputsMap.put(inputName, new ArrayList<E>());
                    }
                    switch (ScpOutputCollectorComponent.$SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType()[input.getDataType().ordinal()]) {
                        case 10: {
                            if (!this.uncompressedDownload) ** GOTO lbl34
                            inputDir = new File(this.downloadDir, String.valueOf(inputName) + "_" + (this.inputsMap.get(inputName).size() + 1) + "_" + ((DirectoryReferenceTD)input).getDirectoryName());
                            try {
                                tempDir = this.tempFileService.createManagedTempDir();
                            }
                            catch (IOException e) {
                                throw new ComponentException("Failed to create temporary directory that is required by Output Writer", (Throwable)e);
                            }
                            try {
                                try {
                                    this.dataManagementService.copyDirectoryReferenceTDToLocalDirectory(this.componentContext, (DirectoryReferenceTD)input, tempDir);
                                    FileUtils.moveDirectory((File)new File(tempDir, ((DirectoryReferenceTD)input).getDirectoryName()), (File)inputDir);
                                }
                                catch (IOException e) {
                                    throw new ComponentException(StringUtils.format((String)"Failed to write directory of input '%s' to %s", (Object[])new Object[]{inputName, inputDir.getAbsolutePath()}), (Throwable)e);
                                }
                            }
                            finally {
                                try {
                                    this.tempFileService.disposeManagedTempDirOrFile(tempDir);
                                }
                                catch (IOException e) {
                                    LogFactory.getLog(this.getClass()).error((Object)"Failed to delete temporary directory", (Throwable)e);
                                }
                            }
                            this.inputsMap.get(inputName).add(inputDir.getName());
                            break;
lbl34:
                            // 1 sources

                            inputFile = new File(this.downloadDir, ((DirectoryReferenceTD)input).getDirectoryReference());
                            this.dataManagementService.copyReferenceTDToLocalCompressedFile(this.componentContext, input, inputFile);
                            this.inputsMap.get(inputName).add(this.serializer.serialize(input));
                            break;
                        }
                        case 9: {
                            if (this.uncompressedDownload) {
                                inputFile = new File(this.downloadDir, String.valueOf(inputName) + "_" + (this.inputsMap.get(inputName).size() + 1) + "_" + ((FileReferenceTD)input).getFileName());
                                this.dataManagementService.copyFileReferenceTDToLocalFile(this.componentContext, (FileReferenceTD)input, inputFile);
                                this.inputsMap.get(inputName).add(inputFile.getName());
                                break;
                            }
                            inputDir = new File(this.downloadDir, ((FileReferenceTD)input).getFileReference());
                            this.dataManagementService.copyReferenceTDToLocalCompressedFile(this.componentContext, input, inputDir);
                            this.inputsMap.get(inputName).add(this.serializer.serialize(input));
                            break;
                        }
                        default: {
                            if (this.simpleDescriptionFormat) {
                                this.inputsMap.get(inputName).add(input.toString());
                                break;
                            }
                            this.inputsMap.get(inputName).add(this.serializer.serialize(input));
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new ComponentException("Failed to copy file or directory to download directory", (Throwable)e);
            }
        }
    }

    public void tearDown(Component.FinalComponentState state) {
        this.outputsFile = new File(this.downloadDir, this.componentContext.getConfigurationValue("OutputsDescriptionFile"));
        try {
            this.mapper.writerWithDefaultPrettyPrinter().writeValue(this.outputsFile, this.inputsMap);
        }
        catch (IOException iOException) {
            this.log.error((Object)("Could not write output values to outputs file " + this.outputsFile.getAbsolutePath()));
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType() {
        if ($SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType != null) {
            return $SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType;
        }
        int[] nArray = new int[DataType.values().length];
        try {
            nArray[DataType.BigTable.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Boolean.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.DateTime.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.DirectoryReference.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Empty.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.FileReference.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Float.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Integer.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Internal.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Matrix.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.NotAValue.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.ShortText.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.SmallTable.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.StructuredData.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataType.Vector.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$rcenvironment$core$datamodel$api$DataType = nArray;
        return nArray;
    }
}

