/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WarningErrorLabel
extends Composite {
    private static final int COMPOSITE_HEIGHT_HINT = 100;
    private static final int LABEL_HEIGHT_HINT = 50;
    private final CLabel upperLabel;
    private final CLabel lowerLabel;
    private final List<String> errors = new LinkedList<String>();
    private final List<String> warnings = new LinkedList<String>();

    public WarningErrorLabel(Composite parent, int style) {
        super(parent, style);
        this.setVisible(true);
        this.setLayout((Layout)new GridLayout(1, false));
        GridData thisGridData = new GridData(1792);
        thisGridData.horizontalSpan = 2;
        thisGridData.heightHint = 100;
        this.setLayoutData(thisGridData);
        GridData labelGridData = new GridData(1792);
        labelGridData.horizontalSpan = 1;
        labelGridData.heightHint = 50;
        this.upperLabel = new CLabel((Composite)this, 32);
        this.upperLabel.setLayoutData((Object)labelGridData);
        this.lowerLabel = new CLabel((Composite)this, 32);
        this.lowerLabel.setLayoutData((Object)labelGridData);
        this.refresh();
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
        this.refresh();
    }

    public void addWarnings(Collection<String> warningsParam) {
        this.warnings.addAll(warningsParam);
        this.refresh();
    }

    public void clearWarnings() {
        this.warnings.clear();
        this.refresh();
    }

    public void addError(String error) {
        this.errors.add(error);
        this.refresh();
    }

    public void addErrors(Collection<String> errorsParam) {
        this.errors.addAll(errorsParam);
        this.refresh();
    }

    public void clearErrors() {
        this.errors.clear();
        this.refresh();
    }

    private void refresh() {
        Optional<Object> warningLabel;
        Optional<Object> errorLabel;
        if (this.errors.isEmpty()) {
            errorLabel = Optional.empty();
            warningLabel = this.warnings.isEmpty() ? Optional.empty() : Optional.of(this.upperLabel);
        } else {
            errorLabel = Optional.of(this.upperLabel);
            warningLabel = this.warnings.isEmpty() ? Optional.empty() : Optional.of(this.lowerLabel);
        }
        this.upperLabel.setVisible(false);
        this.lowerLabel.setVisible(false);
        if (errorLabel.isPresent()) {
            ((CLabel)errorLabel.get()).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ERROR_16));
            ((CLabel)errorLabel.get()).setText(String.join((CharSequence)"\n", this.errors));
            ((CLabel)errorLabel.get()).setVisible(true);
        }
        if (warningLabel.isPresent()) {
            ((CLabel)warningLabel.get()).setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16));
            ((CLabel)warningLabel.get()).setText(String.join((CharSequence)"\n", this.warnings));
            ((CLabel)warningLabel.get()).setVisible(true);
        }
    }
}

