/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import de.rcenvironment.components.outputwriter.gui.Messages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public final class OutputWriterGuiUtils {
    private static final String LINE_SEP = System.getProperty("line.separator");

    private OutputWriterGuiUtils() {
    }

    public static Combo createPlaceholderCombo(Composite parent, String[] placeholders) {
        Combo placeholderCombo = new Combo(parent, 8);
        placeholderCombo.setLayoutData((Object)new GridData(768));
        placeholderCombo.setItems(placeholders);
        placeholderCombo.select(0);
        return placeholderCombo;
    }

    public static Button createPlaceholderInsertButton(Composite parent, final Combo placeholderCombo, final Text textfield) {
        Button insertButton = new Button(parent, 8);
        insertButton.setText(Messages.insertButtonText);
        insertButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                int positionbuffer = textfield.getCaretPosition();
                String word = OutputWriterGuiUtils.escapeSquaredBrackets(placeholderCombo.getText());
                if (word.equals("[Linebreak]")) {
                    word = String.valueOf(word) + LINE_SEP;
                }
                textfield.insert(word);
                if (textfield.getText().length() >= positionbuffer + word.length()) {
                    textfield.setSelection(positionbuffer + word.length());
                }
                textfield.forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return insertButton;
    }

    public static Button createPlaceholderInsertButton(Composite parent, final Combo placeholderCombo, final StyledText textfield) {
        Button insertButton = new Button(parent, 8);
        insertButton.setText(Messages.insertButtonText);
        insertButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                int positionbuffer = textfield.getCaretOffset();
                String word = OutputWriterGuiUtils.escapeSquaredBrackets(placeholderCombo.getText());
                if (word.equals("[Linebreak]")) {
                    word = String.valueOf(word) + LINE_SEP;
                }
                textfield.insert(word);
                if (textfield.getText().length() >= positionbuffer + word.length()) {
                    textfield.setSelection(positionbuffer + word.length());
                }
                textfield.forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return insertButton;
    }

    private static String escapeSquaredBrackets(String text) {
        StringBuilder resultBuilder = new StringBuilder("[");
        int index = 1;
        while (index < text.length() - 1) {
            char currentChar = text.charAt(index);
            switch (currentChar) {
                case '[': {
                    resultBuilder.append("\\[");
                    break;
                }
                case ']': {
                    resultBuilder.append("\\]");
                    break;
                }
                case '\\': {
                    resultBuilder.append("\\\\");
                    break;
                }
                default: {
                    resultBuilder.append(currentChar);
                }
            }
            ++index;
        }
        resultBuilder.append("]");
        return resultBuilder.toString();
    }
}

