/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.easymock.ConstructorArgs;
import org.easymock.cglib.core.CodeGenerationException;
import org.easymock.cglib.core.CollectionUtils;
import org.easymock.cglib.core.DefaultNamingPolicy;
import org.easymock.cglib.core.NamingPolicy;
import org.easymock.cglib.core.Predicate;
import org.easymock.cglib.core.VisibilityPredicate;
import org.easymock.cglib.proxy.Enhancer;
import org.easymock.cglib.proxy.Factory;
import org.easymock.cglib.proxy.MethodInterceptor;
import org.easymock.cglib.proxy.MethodProxy;
import org.easymock.internal.BridgeMethodResolver;
import org.easymock.internal.ClassInstantiatorFactory;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.LinkedClassLoader;
import org.easymock.internal.MethodSerializationWrapper;
import org.easymock.internal.MockInvocationHandler;

public class ClassProxyFactory
implements IProxyFactory {
    private static final NamingPolicy ALLOWS_MOCKING_CLASSES_IN_SIGNED_PACKAGES = new DefaultNamingPolicy(){

        @Override
        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "codegen." + super.getClassName(prefix, source, key, names);
        }
    };

    public static boolean isCallerMockInvocationHandlerInvoke(Throwable e) {
        StackTraceElement[] elements = e.getStackTrace();
        return elements.length > 2 && elements[2].getClassName().equals(MockInvocationHandler.class.getName()) && elements[2].getMethodName().equals("invoke");
    }

    @Override
    public <T> T createProxy(Class<T> toMock, InvocationHandler handler, Method[] mockedMethods, ConstructorArgs args) {
        Factory mock;
        Class mockClass;
        Enhancer enhancer = this.createEnhancer(toMock);
        MockMethodInterceptor interceptor = new MockMethodInterceptor(handler);
        if (mockedMethods != null) {
            interceptor.setMockedMethods(mockedMethods);
        }
        enhancer.setCallbackType(interceptor.getClass());
        try {
            mockClass = enhancer.createClass();
        }
        catch (CodeGenerationException e) {
            LinkedClassLoader linkedClassLoader = AccessController.doPrivileged(() -> new LinkedClassLoader(toMock.getClassLoader(), ClassProxyFactory.class.getClassLoader()));
            enhancer.setClassLoader(linkedClassLoader);
            mockClass = enhancer.createClass();
        }
        if (args != null) {
            Constructor cstr;
            try {
                cstr = mockClass.getDeclaredConstructor(args.getConstructor().getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Fail to find constructor for param types", e);
            }
            try {
                cstr.setAccessible(true);
                mock = (Factory)cstr.newInstance(args.getInitArgs());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to instantiate mock calling constructor", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to instantiate mock calling constructor: Exception in constructor", e.getTargetException());
            }
        }
        try {
            mock = (Factory)ClassInstantiatorFactory.getInstantiator().newInstance(mockClass);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Fail to instantiate mock for " + toMock + " on " + ClassInstantiatorFactory.getJVM() + " JVM");
        }
        mock.setCallback(0, interceptor);
        return (T)mock;
    }

    private Enhancer createEnhancer(Class<?> toMock) {
        Enhancer enhancer = new Enhancer(){

            @Override
            protected void filterConstructors(Class sc, List constructors) {
                CollectionUtils.filter(constructors, new VisibilityPredicate(sc, true));
            }
        };
        enhancer.setSuperclass(toMock);
        if (toMock.getSigners() != null) {
            enhancer.setNamingPolicy(ALLOWS_MOCKING_CLASSES_IN_SIGNED_PACKAGES);
        }
        return enhancer;
    }

    @Override
    public InvocationHandler getInvocationHandler(Object mock) {
        Factory factory = (Factory)mock;
        return ((MockMethodInterceptor)factory.getCallback(0)).handler;
    }

    public static class MockMethodInterceptor
    implements MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = -9054190871232972342L;
        private final InvocationHandler handler;
        private transient Set<Method> mockedMethods;

        public MockMethodInterceptor(InvocationHandler handler) {
            this.handler = handler;
        }

        @Override
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (Modifier.isAbstract(method.getModifiers())) {
                return this.handler.invoke(obj, method, args);
            }
            if (obj instanceof Throwable && method.getName().equals("fillInStackTrace") && ClassProxyFactory.isCallerMockInvocationHandlerInvoke(new Throwable())) {
                return obj;
            }
            if (method.isBridge()) {
                method = BridgeMethodResolver.findBridgedMethod(method);
            }
            if (this.mockedMethods != null && !this.mockedMethods.contains(method)) {
                return proxy.invokeSuper(obj, args);
            }
            return this.handler.invoke(obj, method, args);
        }

        public void setMockedMethods(Method ... mockedMethods) {
            this.mockedMethods = new HashSet<Method>(Arrays.asList(mockedMethods));
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            Set methods = (Set)stream.readObject();
            if (methods == null) {
                return;
            }
            this.mockedMethods = new HashSet<Method>(methods.size());
            for (MethodSerializationWrapper m : methods) {
                try {
                    this.mockedMethods.add(m.getMethod());
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(e.toString());
                }
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            if (this.mockedMethods == null) {
                stream.writeObject(null);
                return;
            }
            HashSet<MethodSerializationWrapper> methods = new HashSet<MethodSerializationWrapper>(this.mockedMethods.size());
            for (Method m : this.mockedMethods) {
                methods.add(new MethodSerializationWrapper(m));
            }
            stream.writeObject(methods);
        }
    }
}

