/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class ImageDisplay
extends BaseDisplay
implements DynamicVectorRenderer {
    public ImageDisplay(int n, boolean bl, int n2, ObjectStore objectStore) {
        this.type = 2;
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.addBackground = bl;
        this.areas = new Vector_Rectangle(n2);
    }

    public final int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        int n4;
        int n5 = (int)graphicsState.CTM[0][0];
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n5 == 0) {
            n5 = (int)graphicsState.CTM[0][1];
        }
        if (n5 < 0) {
            n5 = -n5;
        }
        if ((n4 = (int)graphicsState.CTM[1][1]) < 0) {
            n4 = -n4;
        }
        if (n4 == 0) {
            n4 = (int)graphicsState.CTM[1][0];
        }
        if (n4 < 0) {
            n4 = -n4;
        }
        this.areas.addElement(new Rectangle((int)graphicsState.CTM[2][0], (int)graphicsState.CTM[2][1], n5, n4));
        this.renderImage(null, bufferedImage, graphicsState.getAlpha(2), graphicsState, graphicsState.x, graphicsState.y, n2);
        return -1;
    }

    public void drawClip(GraphicsState graphicsState, Shape shape, boolean bl) {
        Area area = graphicsState.getClippingShape();
        if (!(bl && this.hasClips && this.lastClip == null && area == null || bl && this.lastClip != null && area != null && area.equals(this.lastClip))) {
            RenderUtils.renderClip(graphicsState.getClippingShape(), null, shape, this.g2);
            this.lastClip = area;
            this.hasClips = true;
        }
    }

    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, AffineTransform affineTransform, String string, PdfFont pdfFont) {
        if (n2 == 1) {
            PdfPaint pdfPaint = null;
            PdfPaint pdfPaint2 = null;
            int n3 = graphicsState.getTextRenderType();
            if ((n3 & 2) == 2) {
                pdfPaint2 = graphicsState.getNonstrokeColor();
            }
            if ((n3 & 1) == 1) {
                pdfPaint = graphicsState.getStrokeColor();
            }
            Stroke stroke = graphicsState.getStroke();
            this.g2.setStroke(stroke);
            AffineTransform affineTransform2 = this.g2.getTransform();
            this.g2.translate(fArray[2][0], fArray[2][1]);
            this.g2.transform(affineTransform);
            this.renderText(fArray[2][0], fArray[2][1], n3, (Area)object, null, pdfPaint, pdfPaint2, graphicsState.getAlpha(1), graphicsState.getAlpha(2));
            this.g2.setTransform(affineTransform2);
        } else {
            int n4;
            PdfPaint pdfPaint = null;
            PdfPaint pdfPaint3 = null;
            int n5 = graphicsState.getTextRenderType();
            if ((n5 & 2) == 2) {
                pdfPaint3 = graphicsState.getNonstrokeColor();
            }
            if ((n5 & 1) == 1) {
                pdfPaint = graphicsState.getStrokeColor();
            }
            Stroke stroke = graphicsState.getStroke();
            Stroke stroke2 = this.g2.getStroke();
            if (n5 == 1) {
                this.g2.setStroke(stroke);
            }
            if ((n4 = (int)graphicsState.CTM[1][1]) < 0) {
                n4 = -n4;
            }
            if (n4 == 0) {
                n4 = (int)graphicsState.CTM[0][1];
            }
            if (n4 < 0) {
                n4 = -n4;
            }
            this.areas.addElement(new Rectangle((int)graphicsState.CTM[2][0], (int)graphicsState.CTM[2][1], n4, n4));
            this.renderEmbeddedText(n5, pdfGlyph, n2, affineTransform, null, pdfPaint, pdfPaint3, graphicsState.getAlpha(1), graphicsState.getAlpha(2), (int)graphicsState.getLineWidth());
            this.g2.setStroke(stroke2);
        }
    }

    public final void drawShape(Shape shape, GraphicsState graphicsState, int n) {
        this.areas.addElement(shape.getBounds());
        this.renderShape(null, graphicsState.getFillType(), graphicsState.getStrokeColor(), graphicsState.getNonstrokeColor(), graphicsState.getStroke(), shape, graphicsState.getAlpha(1), graphicsState.getAlpha(2));
    }

    public final void drawXForm(DynamicVectorRenderer dynamicVectorRenderer, GraphicsState graphicsState) {
        this.renderXForm(dynamicVectorRenderer, graphicsState.getAlpha(1));
    }
}

