/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Group
extends Composite {
    String text = "";
    static final int CLIENT_INSET = 3;
    static final long GroupProc;
    static final TCHAR GroupClass;

    static {
        GroupClass = new TCHAR(0, "SWT_GROUP", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        TCHAR WC_BUTTON = new TCHAR(0, "BUTTON", true);
        OS.GetClassInfo(0L, WC_BUTTON, lpWndClass);
        GroupProc = lpWndClass.lpfnWndProc;
        long hInstance = OS.GetModuleHandle(null);
        if (!OS.GetClassInfo(hInstance, GroupClass, lpWndClass)) {
            long hHeap = OS.GetProcessHeap();
            lpWndClass.hInstance = hInstance;
            lpWndClass.style &= 0xFFFFFFFC;
            int byteCount = GroupClass.length() * 2;
            long lpszClassName = OS.HeapAlloc(hHeap, 8, byteCount);
            OS.MoveMemory(lpszClassName, GroupClass, byteCount);
            lpWndClass.lpszClassName = lpszClassName;
            OS.RegisterClass(lpWndClass);
            OS.HeapFree(hHeap, 0, lpszClassName);
        }
    }

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        switch (msg) {
            case 513: 
            case 515: {
                return OS.DefWindowProc(hwnd, msg, wParam, lParam);
            }
        }
        return OS.CallWindowProc(GroupProc, hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = super.computeSizeInPixels(wHint, hHint, changed);
        int length = this.text.length();
        if (length != 0) {
            String string = this.fixText(false);
            TCHAR buffer = new TCHAR(this.getCodePage(), string == null ? this.text : string, true);
            long oldFont = 0L;
            long hDC = OS.GetDC(this.handle);
            long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (newFont != 0L) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            RECT rect = new RECT();
            int flags = 1056;
            OS.DrawText(hDC, buffer, -1, rect, flags);
            if (newFont != 0L) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
            int offsetY = OS.IsAppThemed() ? 0 : 1;
            size.x = Math.max(size.x, rect.right - rect.left + 18 + offsetY);
        }
        return size;
    }

    @Override
    Rectangle computeTrimInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrimInPixels(x, y, width, height);
        long oldFont = 0L;
        long hDC = OS.GetDC(this.handle);
        long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (newFont != 0L) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        TEXTMETRICW tm = new TEXTMETRICW();
        OS.GetTextMetrics(hDC, tm);
        if (newFont != 0L) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(this.handle, hDC);
        int offsetY = OS.IsAppThemed() ? 0 : 1;
        trim.x -= 3;
        trim.y -= tm.tmHeight + offsetY;
        trim.width += 6;
        trim.height += tm.tmHeight + 3 + offsetY;
        return trim;
    }

    @Override
    void createHandle() {
        this.parent.state |= 0x100000;
        super.createHandle();
        this.parent.state &= 0xFFEFFFFF;
        this.state |= 0x200;
        this.state &= 0xFFFFFFFD;
    }

    @Override
    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        String string = this.fixText(enabled);
        if (string != null) {
            TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.handle, buffer);
        }
        if (enabled && this.hasCustomForeground()) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    String fixText(boolean enabled) {
        if (this.text.length() == 0) {
            return null;
        }
        if ((this.style & 0x4000000) != 0) {
            String string = null;
            if (!enabled && !OS.IsAppThemed()) {
                string = " " + this.text + " ";
            }
            return (this.style & Integer.MIN_VALUE) == 0 ? string : (string != null ? String.valueOf('\u202a') + string : String.valueOf('\u202a') + this.text);
        }
        if ((this.style & Integer.MIN_VALUE) != 0) {
            return String.valueOf('\u202b') + this.text;
        }
        return null;
    }

    @Override
    Rectangle getClientAreaInPixels() {
        this.checkWidget();
        this.forceResize();
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        long oldFont = 0L;
        long hDC = OS.GetDC(this.handle);
        long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (newFont != 0L) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        TEXTMETRICW tm = new TEXTMETRICW();
        OS.GetTextMetrics(hDC, tm);
        if (newFont != 0L) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(this.handle, hDC);
        int offsetY = OS.IsAppThemed() ? 0 : 1;
        int x = 3;
        int y = tm.tmHeight + offsetY;
        int width = Math.max(0, rect.right - 6);
        int height = Math.max(0, rect.bottom - y - 3);
        return new Rectangle(x, y, width, height);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    boolean mnemonicHit(char key) {
        return this.setFocus();
    }

    @Override
    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    @Override
    void printWidget(long hwnd, long hdc, GC gc) {
        boolean success = false;
        if (OS.GetDeviceCaps(gc.handle, 2) != 2) {
            int bits = OS.GetWindowLong(hwnd, -16);
            if ((bits & 0x10000000) == 0) {
                OS.ShowWindow(hwnd, 5);
            }
            success = OS.PrintWindow(hwnd, hdc, 0);
            if ((bits & 0x10000000) == 0) {
                OS.ShowWindow(hwnd, 0);
            }
        }
        if (!success) {
            int flags = 14;
            OS.SendMessage(hwnd, 791, hdc, (long)flags);
            int nSavedDC = OS.SaveDC(hdc);
            Control[] children = this._getChildren();
            Rectangle rect = this.getBoundsInPixels();
            OS.IntersectClipRect(hdc, 0, 0, rect.width, rect.height);
            int i = children.length - 1;
            while (i >= 0) {
                Point location = children[i].getLocationInPixels();
                int graphicsMode = OS.GetGraphicsMode(hdc);
                if (graphicsMode == 2) {
                    float[] lpXform = new float[]{1.0f, 0.0f, 0.0f, 1.0f, location.x, location.y};
                    OS.ModifyWorldTransform(hdc, lpXform, 2);
                } else {
                    OS.SetWindowOrgEx(hdc, -location.x, -location.y, null);
                }
                long topHandle = children[i].topHandle();
                int bits = OS.GetWindowLong(topHandle, -16);
                if ((bits & 0x10000000) != 0) {
                    children[i].printWidget(topHandle, hdc, gc);
                }
                if (graphicsMode == 2) {
                    float[] lpXform = new float[]{1.0f, 0.0f, 0.0f, 1.0f, -location.x, -location.y};
                    OS.ModifyWorldTransform(hdc, lpXform, 2);
                }
                --i;
            }
            OS.RestoreDC(hdc, nSavedDC);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
    }

    @Override
    int resolveTextDirection() {
        return BidiUtil.resolveTextDirection(this.text);
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        Rectangle oldRect = this.getClientAreaInPixels();
        super.setFont(font);
        Rectangle newRect = this.getClientAreaInPixels();
        if (!oldRect.equals(newRect)) {
            this.sendResize();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.state & 0x400000) == 0 || !this.updateTextDirection(0x6000000)) {
            string = this.fixText(OS.IsWindowEnabled(this.handle));
            TCHAR buffer = new TCHAR(this.getCodePage(), string == null ? this.text : string, true);
            OS.SetWindowText(this.handle, buffer);
        }
    }

    @Override
    boolean updateTextDirection(int textDirection) {
        if (super.updateTextDirection(textDirection)) {
            String string = this.fixText(OS.IsWindowEnabled(this.handle));
            TCHAR buffer = new TCHAR(this.getCodePage(), string == null ? this.text : string, true);
            OS.SetWindowText(this.handle, buffer);
            return true;
        }
        return false;
    }

    @Override
    int widgetStyle() {
        return super.widgetStyle() | 7 | 0x2000000 | 0x4000000;
    }

    @Override
    TCHAR windowClass() {
        return GroupClass;
    }

    @Override
    long windowProc() {
        return GroupProc;
    }

    @Override
    LRESULT WM_ERASEBKGND(long wParam, long lParam) {
        LRESULT result = super.WM_ERASEBKGND(wParam, lParam);
        if (result != null) {
            return result;
        }
        this.drawBackground(wParam);
        return LRESULT.ONE;
    }

    @Override
    LRESULT WM_NCHITTEST(long wParam, long lParam) {
        LRESULT result = super.WM_NCHITTEST(wParam, lParam);
        if (result != null) {
            return result;
        }
        long code = this.callWindowProc(this.handle, 132, wParam, lParam);
        if (code == -1L) {
            code = 1L;
        }
        return new LRESULT(code);
    }

    @Override
    LRESULT WM_MOUSEMOVE(long wParam, long lParam) {
        LRESULT result = super.WM_MOUSEMOVE(wParam, lParam);
        if (result != null) {
            return result;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PAINT(long wParam, long lParam) {
        LRESULT result = super.WM_PAINT(wParam, lParam);
        if (this.hasCustomForeground() && this.text.length() != 0) {
            String string = this.fixText(false);
            TCHAR buffer = new TCHAR(this.getCodePage(), string == null ? this.text : string, false);
            long hDC = OS.GetDC(this.handle);
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            rect.left += 9;
            long oldFont = 0L;
            long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (newFont != 0L) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            OS.DrawText(hDC, buffer, buffer.length(), rect, 1056);
            rect.right += 3;
            this.drawBackground(hDC, rect);
            OS.SetBkMode(hDC, 1);
            OS.SetTextColor(hDC, this.getForegroundPixel());
            OS.DrawText(hDC, buffer, buffer.length(), rect, 32);
            if (newFont != 0L) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
            OS.ValidateRect(this.handle, rect);
        }
        return result;
    }

    @Override
    LRESULT WM_PRINTCLIENT(long wParam, long lParam) {
        LRESULT result = super.WM_PRINTCLIENT(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (OS.IsAppThemed()) {
            int nSavedDC = OS.SaveDC(wParam);
            long code = this.callWindowProc(this.handle, 792, wParam, lParam);
            OS.RestoreDC(wParam, nSavedDC);
            return new LRESULT(code);
        }
        return result;
    }

    @Override
    LRESULT WM_UPDATEUISTATE(long wParam, long lParam) {
        boolean redraw;
        LRESULT result = super.WM_UPDATEUISTATE(wParam, lParam);
        if (result != null) {
            return result;
        }
        boolean bl = redraw = this.findImageControl() != null;
        if (!redraw) {
            if ((this.state & 0x100) != 0 && OS.IsAppThemed()) {
                boolean bl2 = redraw = this.findThemeControl() != null;
            }
            if (!redraw) {
                boolean bl3 = redraw = this.findBackgroundControl() != null;
            }
        }
        if (redraw) {
            OS.InvalidateRect(this.handle, null, false);
            long code = OS.DefWindowProc(this.handle, 296, wParam, lParam);
            return new LRESULT(code);
        }
        return result;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(long wParam, long lParam) {
        LRESULT result = super.WM_WINDOWPOSCHANGING(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return result;
        }
        WINDOWPOS lpwp = new WINDOWPOS();
        OS.MoveMemory(lpwp, lParam, WINDOWPOS.sizeof);
        if ((lpwp.flags & 9) != 0) {
            return result;
        }
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, lpwp.cx, lpwp.cy);
        OS.SendMessage(this.handle, 131, 0L, rect);
        int newWidth = rect.right - rect.left;
        int newHeight = rect.bottom - rect.top;
        OS.GetClientRect(this.handle, rect);
        int oldWidth = rect.right - rect.left;
        int oldHeight = rect.bottom - rect.top;
        if (newWidth == oldWidth && newHeight == oldHeight) {
            return result;
        }
        if (newWidth != oldWidth) {
            int left = oldWidth;
            if (newWidth < oldWidth) {
                left = newWidth;
            }
            OS.SetRect(rect, left - 3, 0, newWidth, newHeight);
            OS.InvalidateRect(this.handle, rect, true);
        }
        if (newHeight != oldHeight) {
            int bottom = oldHeight;
            if (newHeight < oldHeight) {
                bottom = newHeight;
            }
            if (newWidth < oldWidth) {
                oldWidth -= 3;
            }
            OS.SetRect(rect, 0, bottom - 3, oldWidth, newHeight);
            OS.InvalidateRect(this.handle, rect, true);
        }
        return result;
    }
}

