/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IPerspectiveListener3;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.misc.UIStats;

public class PerspectiveListenerList
extends EventManager {
    public void addPerspectiveListener(IPerspectiveListener l) {
        this.addListenerObject(l);
    }

    private void fireEvent(SafeRunnable runnable, IPerspectiveListener listener, IPerspectiveDescriptor perspective, String description) {
        String label = null;
        if (UIStats.isDebugging(12)) {
            label = String.valueOf(description) + perspective.getId();
            UIStats.start(12, label);
        }
        SafeRunner.run((ISafeRunnable)runnable);
        if (UIStats.isDebugging(12)) {
            UIStats.end(12, listener, label);
        }
    }

    public void firePerspectiveActivated(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPerspectiveListener perspectiveListener = (IPerspectiveListener)listener;
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    perspectiveListener.perspectiveActivated(page, perspective);
                }
            }, perspectiveListener, perspective, "activated::");
            ++n2;
        }
    }

    public void firePerspectivePreDeactivate(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof IPerspectiveListener4) {
                final IPerspectiveListener4 perspectiveListener = (IPerspectiveListener4)listener;
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        perspectiveListener.perspectivePreDeactivate(page, perspective);
                    }
                }, perspectiveListener, perspective, "pre-deactivate::");
            }
            ++n2;
        }
    }

    public void firePerspectiveDeactivated(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 perspectiveListener = (IPerspectiveListener3)listener;
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        perspectiveListener.perspectiveDeactivated(page, perspective);
                    }
                }, perspectiveListener, perspective, "deactivated::");
            }
            ++n2;
        }
    }

    public void firePerspectiveChanged(final IWorkbenchPage page, final IPerspectiveDescriptor perspective, final String changeId) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPerspectiveListener perspectiveListener = (IPerspectiveListener)listener;
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    perspectiveListener.perspectiveChanged(page, perspective, changeId);
                }
            }, perspectiveListener, perspective, "changed::");
            ++n2;
        }
    }

    public void firePerspectiveChanged(final IWorkbenchPage page, final IPerspectiveDescriptor perspective, final IWorkbenchPartReference partRef, final String changeId) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof IPerspectiveListener2) {
                final IPerspectiveListener2 perspectiveListener = (IPerspectiveListener2)listener;
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        perspectiveListener.perspectiveChanged(page, perspective, partRef, changeId);
                    }
                }, perspectiveListener, perspective, "changed::");
            }
            ++n2;
        }
    }

    public void firePerspectiveClosed(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 perspectiveListener = (IPerspectiveListener3)listener;
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        perspectiveListener.perspectiveClosed(page, perspective);
                    }
                }, perspectiveListener, perspective, "closed::");
            }
            ++n2;
        }
    }

    public void firePerspectiveOpened(final IWorkbenchPage page, final IPerspectiveDescriptor perspective) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 perspectiveListener = (IPerspectiveListener3)listener;
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        perspectiveListener.perspectiveOpened(page, perspective);
                    }
                }, perspectiveListener, perspective, "opened::");
            }
            ++n2;
        }
    }

    public void firePerspectiveSavedAs(final IWorkbenchPage page, final IPerspectiveDescriptor oldPerspective, final IPerspectiveDescriptor newPerspective) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof IPerspectiveListener3) {
                final IPerspectiveListener3 perspectiveListener = (IPerspectiveListener3)listener;
                this.fireEvent(new SafeRunnable(){

                    public void run() {
                        perspectiveListener.perspectiveSavedAs(page, oldPerspective, newPerspective);
                    }
                }, perspectiveListener, newPerspective, "saveAs::");
            }
            ++n2;
        }
    }

    public void removePerspectiveListener(IPerspectiveListener l) {
        this.removeListenerObject(l);
    }
}

