/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.osgi.framework.Bundle;

public class BufferingLog
implements PaxLogger {
    private final List<LogPackage> m_queue;
    private final String m_fqcn;
    private PaxContext m_context = new PaxContext();

    public BufferingLog(Bundle bundle, String categoryName) {
        this.m_fqcn = this.getClass().getName();
        this.m_queue = new ArrayList<LogPackage>();
    }

    void flush(PaxLogger destination) {
        for (LogPackage pack : this.m_queue) {
            String fqcn = pack.getFqcn();
            Throwable throwable = pack.getException();
            String message = pack.getMessage();
            this.getPaxContext().putAll(pack.getContext());
            LogType logType = pack.getType();
            int logTypeAsInt = logType.getType();
            switch (logTypeAsInt) {
                case 1: {
                    destination.debug(message, throwable, fqcn);
                    break;
                }
                case 0: {
                    destination.trace(message, throwable, fqcn);
                    break;
                }
                case 2: {
                    destination.inform(message, throwable, fqcn);
                    break;
                }
                case 3: {
                    destination.warn(message, throwable, fqcn);
                    break;
                }
                case 4: {
                    destination.error(message, throwable, fqcn);
                    break;
                }
                case 5: {
                    destination.fatal(message, throwable, fqcn);
                }
            }
            this.getPaxContext().clear();
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public boolean isFatalEnabled() {
        return true;
    }

    @Override
    public void trace(String message, Throwable t) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.trace, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void debug(String message, Throwable t) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.debug, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void inform(String message, Throwable t) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.info, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void warn(String message, Throwable t) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.warn, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void error(String message, Throwable t) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.error, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void fatal(String message, Throwable t) {
        LogPackage p = new LogPackage(this.m_fqcn, LogType.fatal, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void trace(String message, Throwable t, String fqcn) {
        LogPackage p = new LogPackage(fqcn, LogType.trace, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void debug(String message, Throwable t, String fqcn) {
        LogPackage p = new LogPackage(fqcn, LogType.debug, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void inform(String message, Throwable t, String fqcn) {
        LogPackage p = new LogPackage(fqcn, LogType.info, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void warn(String message, Throwable t, String fqcn) {
        LogPackage p = new LogPackage(fqcn, LogType.warn, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void error(String message, Throwable t, String fqcn) {
        LogPackage p = new LogPackage(fqcn, LogType.error, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public void fatal(String message, Throwable t, String fqcn) {
        LogPackage p = new LogPackage(fqcn, LogType.fatal, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    @Override
    public int getLogLevel() {
        return 0;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public PaxContext getPaxContext() {
        return this.m_context;
    }

    private static class LogPackage {
        private final String m_fqcn;
        private final LogType m_type;
        private final String m_message;
        private final Throwable m_exception;
        private final Map<String, Object> m_context;

        public LogPackage(String fqcn, LogType type, String message, Throwable exception, Map<String, Object> context) {
            this.m_fqcn = fqcn;
            this.m_type = type;
            this.m_message = message;
            this.m_exception = exception;
            this.m_context = context;
            if (this.m_exception != null) {
                this.m_exception.fillInStackTrace();
            }
        }

        public String getFqcn() {
            return this.m_fqcn;
        }

        public String getMessage() {
            return this.m_message;
        }

        public Throwable getException() {
            return this.m_exception;
        }

        public LogType getType() {
            return this.m_type;
        }

        public Map<String, Object> getContext() {
            return this.m_context;
        }
    }

    private static class LogType {
        private static final int TRACE_INT = 0;
        private static final int DEBUG_INT = 1;
        private static final int INFO_INT = 2;
        private static final int WARN_INT = 3;
        private static final int ERROR_INT = 4;
        private static final int FATAL_INT = 5;
        private static LogType trace = new LogType(0);
        private static LogType debug = new LogType(1);
        private static LogType info = new LogType(2);
        private static LogType warn = new LogType(3);
        private static LogType error = new LogType(4);
        private static LogType fatal = new LogType(5);
        private final int m_type;

        private LogType(int type) {
            this.m_type = type;
        }

        private int getType() {
            return this.m_type;
        }
    }
}

