/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.core.dom.properties.CSSBorderProperties;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSSWTHelpers {
    public static PaintListener createBorderPaintListener(final CSSEngine engine, final Control control) {
        return new PaintListener(){

            private Color convert(CSSValue value) {
                try {
                    return (Color)engine.convert(value, Color.class, (Object)control.getDisplay());
                }
                catch (Exception e) {
                    engine.handleExceptions(e);
                    return null;
                }
            }

            public void paintControl(PaintEvent e) {
                CSSBorderProperties border = (CSSBorderProperties)control.getData("org.eclipse.e4.ui.core.css.swt.CONTROL_CSS2BORDER_KEY");
                if (border == null) {
                    return;
                }
                int width = border.getWidth();
                GC gc = e.gc;
                CSSPrimitiveValue value = border.getColor();
                if (value == null) {
                    return;
                }
                Color color = this.convert(value);
                if (color != null) {
                    gc.setForeground(color);
                }
                Rectangle rect = control.getBounds();
                if (width == 0) {
                    Rectangle rect1 = new Rectangle(rect.x - width, rect.y - width, rect.width + 2 * width, rect.height + 2 * width);
                    gc.fillRectangle(rect1);
                } else {
                    String borderStyle = border.getStyle();
                    gc.setLineStyle(CSSSWTHelpers.getLineStyle(borderStyle));
                    gc.setLineWidth(width);
                    gc.drawLine(rect.x, rect.y - 1, rect.width + 2 * width, rect.y - 1);
                    gc.setLineStyle(CSSSWTHelpers.getLineStyle(borderStyle));
                    gc.setLineWidth(width);
                    gc.drawLine(rect.x, rect.y + rect.height + 1, rect.width + 2 * width, rect.y + rect.height + 1);
                    gc.setLineStyle(CSSSWTHelpers.getLineStyle(borderStyle));
                    gc.setLineWidth(width);
                    gc.drawLine(rect.x - 1, rect.y - 1, rect.x - 1, rect.y + rect.height + 1);
                    gc.setLineStyle(CSSSWTHelpers.getLineStyle(borderStyle));
                    gc.setLineWidth(width);
                    gc.drawLine(rect.width + 2 * width, rect.y - 1, rect.width + 2 * width, rect.y + rect.height + 1);
                }
            }
        };
    }

    public static int getLineStyle(String borderStyle) {
        if (borderStyle == null) {
            return 1;
        }
        if ("dashed".equals(borderStyle)) {
            return 2;
        }
        if ("dotted".equals(borderStyle)) {
            return 3;
        }
        return 1;
    }
}

