/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.environment.eclipse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.internal.environment.eclipse.FileResourceUtils;

public class FileResourceOutputStream
extends OutputStream {
    IPath fFilePath;
    IStatusHandler fStatusHandler;
    ByteArrayOutputStream fByteArrayOutputStream;
    boolean fOpen;

    public FileResourceOutputStream(IPath filePath, IStatusHandler statusHandler) {
        this.fFilePath = filePath;
        this.fStatusHandler = statusHandler;
        this.fByteArrayOutputStream = new ByteArrayOutputStream();
        this.fOpen = true;
    }

    public void close() throws IOException {
        if (!this.fOpen) {
            return;
        }
        this.fOpen = false;
        this.fByteArrayOutputStream.close();
        byte[] buffer = this.fByteArrayOutputStream.toByteArray();
        ByteArrayInputStream tempInputStream = new ByteArrayInputStream(buffer);
        try {
            FileResourceUtils.createFile(this.fFilePath, tempInputStream, this.fStatusHandler);
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void flush() throws IOException {
        this.fByteArrayOutputStream.flush();
    }

    public void write(byte[] b) throws IOException {
        this.fByteArrayOutputStream.write(b);
    }

    public void write(byte[] b, int off, int len) {
        this.fByteArrayOutputStream.write(b, off, len);
    }

    public void write(int b) {
        this.fByteArrayOutputStream.write(b);
    }
}

