/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.avalon;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.avalon.framework.logger.Logger;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.avalon.AvalonLogger;
import org.osgi.framework.BundleContext;

public class AvalonLogFactory {
    private static PaxLoggingManager m_paxLogging;
    private static Map<String, AvalonLogger> m_loggers;

    public static void setBundleContext(BundleContext context) {
        m_paxLogging = new OSGIPaxLoggingManager(context);
        for (Map.Entry<String, AvalonLogger> entry : m_loggers.entrySet()) {
            String name = entry.getKey();
            AvalonLogger logger = entry.getValue();
            logger.setPaxLoggingManager(m_paxLogging, name);
        }
        m_paxLogging.open();
    }

    public static void release() {
    }

    public static Logger getLogger(String name) {
        return AvalonLogFactory.getLogger(null, name);
    }

    public static Logger getLogger(AvalonLogger parent, String name) {
        String newName = parent == null ? name : parent.getName() + "." + name;
        PaxLogger logger = m_paxLogging.getLogger(newName, AvalonLogger.AVALON_FQCN);
        AvalonLogger avalonLogger = new AvalonLogger(logger);
        m_loggers.put(newName, avalonLogger);
        return avalonLogger;
    }

    public static void dispose() {
        m_paxLogging.close();
        m_paxLogging.dispose();
        m_paxLogging = null;
    }

    static {
        m_loggers = Collections.synchronizedMap(new WeakHashMap());
    }
}

