/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;

public class FontUtils {
    private static final int TRAY_FONT_HEIGHT_LIMIT = 17;

    public static boolean isFontTooLargeForTray() {
        try {
            int height = Display.getDefault().getSystemFont().getFontData()[0].getHeight();
            return height > 17;
        }
        catch (RuntimeException runtimeException) {
            return true;
        }
    }

    public static String getRescaleScript(int percent) {
        String scaleString = String.valueOf(percent / 100) + "." + percent % 100 / 10;
        String os = Platform.getOS();
        if ("win32".equalsIgnoreCase(os) || "macosx".equalsIgnoreCase(os)) {
            return "document.body.style.zoom = " + scaleString;
        }
        return null;
    }

    public static boolean canRescaleHelpView() {
        String os = Platform.getOS();
        return "win32".equalsIgnoreCase(os) || "macosx".equalsIgnoreCase(os);
    }
}

