/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TypeFilteringDialog;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.SelectResourcesBlock;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class SelectResourcesDialog
extends Dialog {
    private SelectResourcesBlock fResourceGroup;
    private List<Object> fAcceptedFileTypes = new ArrayList<Object>();
    private IResource[] fInput;
    private String fTitle;
    private String fInstruction;
    private Label fCountIndication;
    private IFilter fAcceptableLocationsFilter;

    public SelectResourcesDialog(Shell parentShell, String title, String instruction, IFilter acceptableLocationsFilter) {
        super(parentShell);
        this.fTitle = title;
        this.fInstruction = instruction;
        this.fAcceptableLocationsFilter = acceptableLocationsFilter;
    }

    protected boolean isResizable() {
        return true;
    }

    public void setInput(IResource[] input) {
        this.fInput = input;
    }

    public void refresh() {
        this.fResourceGroup.refresh();
        this.setSelection(this.fInput, this.fAcceptableLocationsFilter);
    }

    public IResource[] getSelectedResources() {
        List<Object> items = this.fResourceGroup.getAllCheckedListItems();
        return items.toArray(new IResource[items.size()]);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fTitle != null) {
            newShell.setText(this.fTitle);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 16384);
        label.setText(this.fInstruction);
        label.setLayoutData((Object)new GridData(768));
        this.fResourceGroup = new SelectResourcesBlock(composite, ResourcesPlugin.getWorkspace().getRoot(), this.getResourceProvider(6), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, this.useHeightHint(parent));
        this.fResourceGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectResourcesDialog.this.updateSelectionCount();
            }
        });
        this.fCountIndication = new Label(composite, 16384);
        this.fCountIndication.setLayoutData((Object)new GridData(768));
        this.createSelectionButtonGroup(composite);
        this.setInitialSelection();
        return composite;
    }

    private boolean useHeightHint(Composite parent) {
        int displayHeight = parent.getDisplay().getClientArea().height;
        int fontHeight = parent.getFont().getFontData()[0].getHeight();
        return displayHeight / fontHeight > 50;
    }

    private ITreeContentProvider getResourceProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IWorkspaceRoot) {
                    HashSet<IProject> projects = new HashSet<IProject>();
                    int i = 0;
                    while (i < SelectResourcesDialog.this.fInput.length) {
                        IProject project = SelectResourcesDialog.this.fInput[i].getProject();
                        if ((project.getType() & resourceType) > 0) {
                            projects.add(project);
                        }
                        ++i;
                    }
                    return projects.toArray();
                }
                if (o instanceof IContainer) {
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    int i = 0;
                    while (i < members.length) {
                        if ((members[i].getType() & resourceType) > 0 && (resourceType != 1 || SelectResourcesDialog.this.fAcceptableLocationsFilter == null || SelectResourcesDialog.this.fAcceptableLocationsFilter.accept(members[i]))) {
                            results.add(members[i]);
                        }
                        ++i;
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList)o).toArray();
                }
                return new Object[0];
            }
        };
    }

    protected Composite createSelectionButtonGroup(Composite parent) {
        Font font = parent.getFont();
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setFont(parent.getFont());
        buttonComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(0).equalWidth(true).create());
        Button selectButton = this.createButton(buttonComposite, 18, TextEditorMessages.SelectResourcesDialog_selectAll, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectResourcesDialog.this.fResourceGroup.setAllSelections(true);
                SelectResourcesDialog.this.updateSelectionCount();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        selectButton.setFont(font);
        this.setButtonLayoutData(selectButton);
        Button deselectButton = this.createButton(buttonComposite, 19, TextEditorMessages.SelectResourcesDialog_deselectAll, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectResourcesDialog.this.fResourceGroup.setAllSelections(false);
                SelectResourcesDialog.this.updateSelectionCount();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        deselectButton.setFont(font);
        this.setButtonLayoutData(deselectButton);
        Button selectTypesButton = this.createButton(buttonComposite, 20, TextEditorMessages.SelectResourcesDialog_filterSelection, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectResourcesDialog.this.handleSelectFileTypes();
            }
        };
        selectTypesButton.addSelectionListener((SelectionListener)listener);
        selectTypesButton.setFont(font);
        this.setButtonLayoutData(selectTypesButton);
        return buttonComposite;
    }

    protected void handleSelectFileTypes() {
        Object[] acceptedFileTypes = this.queryFileTypes();
        if (acceptedFileTypes != null) {
            this.fAcceptedFileTypes = Arrays.asList(acceptedFileTypes);
            this.filterSelection();
        }
    }

    protected Object[] queryFileTypes() {
        TypeFilteringDialog dialog = new TypeFilteringDialog(this.getShell(), this.fAcceptedFileTypes);
        dialog.open();
        return dialog.getResult();
    }

    private void filterSelection() {
        final IFilter filter = new IFilter(){

            @Override
            public boolean accept(IResource resource) {
                return SelectResourcesDialog.this.hasAcceptedFileType(resource);
            }
        };
        List<Object> list = this.fResourceGroup.getAllWhiteCheckedItems();
        final IResource[] resources = list.toArray(new IResource[list.size()]);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SelectResourcesDialog.this.setSelection(resources, filter);
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)runnable);
    }

    protected boolean hasAcceptedFileType(IResource resource) {
        if (this.fAcceptedFileTypes == null) {
            return true;
        }
        String resourceName = resource.getName();
        int separatorIndex = resourceName.lastIndexOf(".");
        if (separatorIndex == -1) {
            return false;
        }
        String extension = resourceName.substring(separatorIndex + 1);
        Iterator<Object> e = this.fAcceptedFileTypes.iterator();
        while (e.hasNext()) {
            if (!extension.equalsIgnoreCase((String)e.next())) continue;
            return true;
        }
        return false;
    }

    protected void setInitialSelection() {
        this.setSelection(this.fInput, this.fAcceptableLocationsFilter);
        this.selectAndReveal(this.fInput[0]);
    }

    protected void setSelection(IResource[] input, IFilter filter) {
        Hashtable<IContainer, List<Object>> selectionMap = new Hashtable<IContainer, List<Object>>();
        int i = 0;
        while (i < input.length) {
            IResource resource = input[i];
            if ((resource.getType() & 1) > 0) {
                if (filter.accept(resource)) {
                    List files = null;
                    IContainer parent = resource.getParent();
                    files = selectionMap.containsKey(parent) ? (List)selectionMap.get(parent) : new ArrayList();
                    files.add(resource);
                    selectionMap.put(parent, files);
                }
            } else {
                this.setSelection(selectionMap, (IContainer)resource, filter);
            }
            ++i;
        }
        this.fResourceGroup.updateSelections(selectionMap);
        this.updateSelectionCount();
    }

    private void setSelection(Map<IContainer, List<Object>> selectionMap, IContainer parent, IFilter filter) {
        try {
            IResource[] resources = parent.members();
            ArrayList<IResource> selections = new ArrayList<IResource>();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if ((resource.getType() & 1) > 0) {
                    if (filter.accept(resource)) {
                        selections.add(resource);
                    }
                } else {
                    this.setSelection(selectionMap, (IContainer)resource, filter);
                }
                ++i;
            }
            if (!selections.isEmpty()) {
                selectionMap.put(parent, selections);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private void selectAndReveal(IResource resource) {
        IContainer container = null;
        container = (1 & resource.getType()) > 0 ? resource.getParent() : (IContainer)resource;
        this.fResourceGroup.selectAndReveal(container);
    }

    private void updateSelectionCount() {
        List<Object> listItems = this.fResourceGroup.getAllCheckedListItems();
        int checkedFiles = listItems.size();
        StringBuilder buffer = new StringBuilder();
        switch (checkedFiles) {
            case 0: {
                buffer.append(TextEditorMessages.SelectResourcesDialog_noFilesSelected);
                break;
            }
            case 1: {
                buffer.append(TextEditorMessages.SelectResourcesDialog_oneFileSelected);
                break;
            }
            default: {
                buffer.append(NLSUtility.format(TextEditorMessages.SelectResourcesDialog_nFilesSelected, checkedFiles));
            }
        }
        this.fCountIndication.setText(buffer.toString());
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(checkedFiles > 0);
        }
    }

    static interface IFilter {
        public boolean accept(IResource var1);
    }
}

