/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInstallationBuilder;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessageStore;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.common.EditorsHelper;
import de.rcenvironment.core.gui.utils.incubator.ContextMenuItemRemover;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.GUIWorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.gui.workflow.WorkflowNodeLabelConnectionHelper;
import de.rcenvironment.core.gui.workflow.editor.Messages;
import de.rcenvironment.core.gui.workflow.editor.PaletteCreationTool;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditorContextMenuProvider;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditorHelpContextProvider;
import de.rcenvironment.core.gui.workflow.editor.WorkflowScalableFreeformRootEditPart;
import de.rcenvironment.core.gui.workflow.editor.WorkflowZoomManager;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowNodeLabelConnectionCreateCommand;
import de.rcenvironment.core.gui.workflow.editor.handlers.OpenConnectionEditorHandler;
import de.rcenvironment.core.gui.workflow.editor.handlers.OpenConnectionsViewHandler;
import de.rcenvironment.core.gui.workflow.editor.validator.WorkflowDescriptionValidationUtils;
import de.rcenvironment.core.gui.workflow.parts.ConnectionPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowEditorEditPartFactory;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowPart;
import de.rcenvironment.core.gui.workflow.view.outline.OutlineView;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class WorkflowEditor
extends GraphicalEditor
implements ITabbedPropertySheetPageContributor {
    public static final int PROP_FINAL_WORKFLOW_DESCRIPTION_SET = 768;
    public static final int PROP_WORKFLOW_VAILDATION_FINISHED = 1024;
    public static final String COMPONENTNAMES_WITH_VERSION = " (%s)";
    public static final String SHOW_LABELS_PREFERENCE_KEY = "showConnections";
    public static final String DRAG_STATE_BENDPOINT = "DRAG_STATE_BENDPOINT";
    protected static final int DEFAULT_TOLERANCE = 10;
    private static final int MOVEMENT = 1;
    private static final Log LOGGER = LogFactory.getLog(WorkflowEditor.class);
    private static final char OPEN_CONNECTION_VIEW_KEYCODE = 'c';
    private static final int MINUS_ONE = -1;
    private static final int UNDO_LIMIT = 10;
    private static final int TILE_OFFSET = 30;
    private static final int TILE_SIZE = 60;
    private static final int MAXIMUM_LOCAL_COMPONENT_LOADING_WAIT_SECONDS = 20;
    protected final ServiceRegistryPublisherAccess serviceRegistryAccess;
    protected final WorkflowExecutionService workflowExecutionService;
    protected final LocalComponentRegistrationService localComponentRegistrationService;
    protected WorkflowDescription workflowDescription;
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private GraphicalViewer viewer;
    private int mouseX;
    private int mouseY;
    private final ToolIntegrationContextRegistry toolIntegrationRegistry;
    private ResourceTracker resourceListener = new ResourceTracker();

    public WorkflowEditor() {
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        this.toolIntegrationRegistry = (ToolIntegrationContextRegistry)this.serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class);
        this.workflowExecutionService = (WorkflowExecutionService)this.serviceRegistryAccess.getService(WorkflowExecutionService.class);
        this.localComponentRegistrationService = (LocalComponentRegistrationService)this.serviceRegistryAccess.getService(LocalComponentRegistrationService.class);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public WorkflowDescription getWorkflowDescription() {
        return this.workflowDescription;
    }

    public CommandStack getEditorsCommandStack() {
        return this.getCommandStack();
    }

    private void openConnectionEditor() {
        OpenConnectionsViewHandler openConnectionViewHandler = new OpenConnectionsViewHandler();
        try {
            openConnectionViewHandler.execute(new ExecutionEvent());
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
    }

    protected void initializeGraphicalViewer() {
        this.viewer = this.getGraphicalViewer();
        WorkflowScalableFreeformRootEditPart rootEditPart = new WorkflowScalableFreeformRootEditPart();
        this.viewer.setRootEditPart((RootEditPart)rootEditPart);
        this.viewer.setEditPartFactory((EditPartFactory)new WorkflowEditorEditPartFactory());
        this.getCommandStack().setUndoLimit(10);
        this.viewer.getControl().addKeyListener((KeyListener)new WorkflowEditorKeyListener());
        this.viewer.setContents((Object)this.workflowDescription);
        this.viewer.addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)this.viewer));
        WorkflowEditorContextMenuProvider cmProvider = new WorkflowEditorContextMenuProvider((EditPartViewer)this.viewer, this.getActionRegistry());
        this.viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)this.viewer);
        WorkflowZoomManager zoomManager = (WorkflowZoomManager)rootEditPart.getZoomManager();
        this.getActionRegistry().registerAction((IAction)new ZoomInAction((ZoomManager)zoomManager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction((ZoomManager)zoomManager));
        this.viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.tabbedPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                for (Object structuredSelectionObject : structuredSelection.toList()) {
                    if (structuredSelectionObject instanceof ConnectionPart) {
                        ConnectionPart connectionPart = (ConnectionPart)structuredSelectionObject;
                        if (WorkflowEditor.this.viewer.getSelectedEditParts().contains(connectionPart)) {
                            connectionPart.getConnectionFigure().setForegroundColor(ColorConstants.blue);
                            connectionPart.showLabel();
                        }
                    }
                    if (structuredSelectionObject instanceof WorkflowNodePart) {
                        WorkflowNodePart nodePart = (WorkflowNodePart)structuredSelectionObject;
                        ComponentInterface ci = ((WorkflowNode)nodePart.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface();
                        String id = ci.getIdentifierAndVersion().substring(0, ci.getIdentifierAndVersion().lastIndexOf("/"));
                        if (WorkflowEditor.this.toolIntegrationRegistry.hasTIContextMatchingPrefix(id)) {
                            WorkflowEditor.this.setHelp("de.rcenvironment.integration.*");
                            continue;
                        }
                        WorkflowEditor.this.setHelp(id);
                        continue;
                    }
                    WorkflowEditor.this.setHelp(null);
                }
                WorkflowEditor.this.removeConnectionColorsAndLabel();
            }
        });
        this.viewer.getControl().setData(DRAG_STATE_BENDPOINT, (Object)false);
        this.viewer.getControl().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent ev) {
            }

            public void mouseDown(MouseEvent ev) {
            }

            public void mouseDoubleClick(MouseEvent ev) {
                ConnectionPart connectionPart = WorkflowEditor.this.selectConnection(ev);
                if (connectionPart != null) {
                    WorkflowNode source = null;
                    WorkflowNode target = null;
                    if (connectionPart.getSource().getModel() instanceof WorkflowNode) {
                        source = (WorkflowNode)connectionPart.getSource().getModel();
                    }
                    if (connectionPart.getTarget().getModel() instanceof WorkflowNode) {
                        target = (WorkflowNode)connectionPart.getTarget().getModel();
                    }
                    OpenConnectionEditorHandler openConnectionEditorHandler = new OpenConnectionEditorHandler(source, target);
                    try {
                        openConnectionEditorHandler.execute(new ExecutionEvent());
                    }
                    catch (ExecutionException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.getActionRegistry().registerAction((IAction)new ToggleGridAction(this.getGraphicalViewer()));
        this.getActionRegistry().registerAction((IAction)new ToggleSnapToGeometryAction(this.getGraphicalViewer()));
        this.getViewer().setProperty("SnapToGeometry.isEnabled", (Object)true);
        this.getViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(20, 20));
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("de.rcenvironment.rce.gui.workflow.editor.scope");
        IPreferenceStore preferenceStore = Activator.getInstance().getPreferenceStore();
        preferenceStore.setValue(SHOW_LABELS_PREFERENCE_KEY, false);
        ContextMenuItemRemover.removeUnwantedMenuEntries((Control)this.viewer.getControl());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
    }

    public void showAllConnectionLabels() {
        for (Object connectionPartObject : this.viewer.getEditPartRegistry().values()) {
            if (!(connectionPartObject instanceof ConnectionPart)) continue;
            ((ConnectionPart)connectionPartObject).showLabel();
        }
    }

    public void hideUnselectedConnectionLabels() {
        for (Object connectionPartObject : this.viewer.getEditPartRegistry().values()) {
            if (!(connectionPartObject instanceof ConnectionPart)) continue;
            ConnectionPart part = (ConnectionPart)connectionPartObject;
            int selectedCode = 2;
            if (part.getSelected() == selectedCode) continue;
            part.hideLabel();
        }
    }

    private void removeConnectionColorsAndLabel() {
        for (Object connectionPartObject : this.viewer.getEditPartRegistry().values()) {
            if (!(connectionPartObject instanceof ConnectionPart) || this.viewer.getSelectedEditParts().contains(connectionPartObject)) continue;
            ConnectionPart connectionPart = (ConnectionPart)connectionPartObject;
            connectionPart.getConnectionFigure().setForegroundColor(ColorConstants.black);
            IPreferenceStore prefs = Activator.getInstance().getPreferenceStore();
            boolean labelsVisible = prefs.getBoolean(SHOW_LABELS_PREFERENCE_KEY);
            if (labelsVisible) continue;
            connectionPart.hideLabel();
        }
    }

    private ConnectionPart selectConnection(MouseEvent ev) {
        for (Object editPart : this.viewer.getEditPartRegistry().values()) {
            Rectangle toleranceRectangle;
            if (!(editPart instanceof ConnectionPart)) continue;
            int offsetX = ((FigureCanvas)this.getViewer().getControl()).getViewport().getViewLocation().x;
            int offsetY = ((FigureCanvas)this.getViewer().getControl()).getViewport().getViewLocation().y;
            ConnectionPart connectionPart = (ConnectionPart)editPart;
            PointList connectionPoints = connectionPart.getConnectionFigure().getPoints();
            if (!connectionPoints.intersects(toleranceRectangle = new Rectangle(ev.x + offsetX - 5, ev.y + offsetY - 5, 10, 10))) continue;
            this.viewer.select((EditPart)connectionPart);
            this.viewer.reveal((EditPart)connectionPart);
            return connectionPart;
        }
        return null;
    }

    public void dispose() {
        this.serviceRegistryAccess.dispose();
        super.dispose();
    }

    protected void loadWorkflowFromFile(final File wfFile, final GUIWorkflowDescriptionLoaderCallback wfdc) {
        if (wfFile != null) {
            Job job = new Job(Messages.openWorkflow){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            monitor.beginTask("Waiting for component availability", 1);
                            if (!WorkflowEditor.this.localComponentRegistrationService.waitForLocalComponentInitialization(20, TimeUnit.SECONDS)) {
                                LOGGER.warn((Object)"Local component/tool initialization did not complete within 20 seconds; attempting to open the workflow anyway");
                            }
                            monitor.worked(1);
                            monitor.beginTask(Messages.loadingComponents, 2);
                            monitor.worked(1);
                            WorkflowEditor.this.workflowDescription = WorkflowEditor.this.workflowExecutionService.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, (WorkflowDescriptionLoaderCallback)wfdc);
                            WorkflowEditor.this.initializeWorkflowDescriptionListener();
                            monitor.worked(1);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (WorkflowEditor.this.viewer.getControl() != null) {
                                        WorkflowEditor.this.viewer.setContents((Object)(this).WorkflowEditor.this.workflowDescription);
                                        if (WorkflowEditor.this.getEditorSite() != null) {
                                            WorkflowEditor.this.setFocus();
                                        }
                                        WorkflowEditor.this.validateWorkflow();
                                        WorkflowEditor.this.firePropertyChange(768);
                                    }
                                }
                            });
                        }
                        catch (WorkflowFileException | InterruptedException e) {
                            LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)("Failed to open workflow: " + wfFile.getAbsolutePath()), e);
                            Display.getDefault().asyncExec(new Runnable((Exception)e){
                                private final /* synthetic */ Exception val$e;
                                {
                                    this.val$e = exception;
                                }

                                @Override
                                public void run() {
                                    WorkflowEditor.this.closeEditorAndShowMessage(this.val$e.getMessage());
                                }
                            });
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    protected void setInput(IEditorInput input) {
        File wfFile;
        super.setInput(input);
        this.workflowDescription = new WorkflowDescription("");
        GUIWorkflowDescriptionLoaderCallback workflowDescriptionLoader = null;
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            IFile workspaceWfFile = fileEditorInput.getFile();
            workflowDescriptionLoader = new GUIWorkflowDescriptionLoaderCallback(workspaceWfFile);
            if (workspaceWfFile != null && workspaceWfFile.getRawLocation() != null) {
                this.setPartName(workspaceWfFile.getName());
                wfFile = new File(workspaceWfFile.getLocation().toOSString());
            } else {
                this.closeEditorAndShowMessage(StringUtils.format((String)"Workflow file could not be found: %s", (Object[])new Object[]{fileEditorInput.getFile()}));
                wfFile = null;
            }
        } else if (input instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)input;
            wfFile = new File(fileStoreEditorInput.getURI());
            this.setPartName(wfFile.getName());
            workflowDescriptionLoader = new GUIWorkflowDescriptionLoaderCallback();
        } else {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Workflow File Error", (String)"Failed to load workflow file for an unknown reason.");
            wfFile = null;
        }
        this.loadWorkflowFromFile(wfFile, workflowDescriptionLoader);
    }

    protected void closeEditorAndShowMessage(String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Workflow File Error", (String)message);
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    protected void initializeWorkflowDescriptionListener() {
        this.workflowDescription.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WorkflowEditor.this.updateDirty();
            }
        });
    }

    protected void updateDirty() {
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                if (file.exists()) {
                    WorkflowDescriptionPersistenceHandler wdHandler = new WorkflowDescriptionPersistenceHandler();
                    this.workflowDescription = this.updateExecutionInformation(this.workflowDescription, wdHandler, file.getRawLocation().toFile());
                    file.setContents((InputStream)new ByteArrayInputStream(wdHandler.writeWorkflowDescriptionToStream(this.workflowDescription).toByteArray()), true, false, monitor);
                    this.workflowDescription.firePropertyChange("e.rcenvironment.wf.n");
                    this.workflowDescription.firePropertyChange("e.rcenvironment.wf.l");
                } else {
                    this.doSaveAs();
                }
            } else if (this.getEditorInput() instanceof FileStoreEditorInput) {
                File file = new File(((FileStoreEditorInput)this.getEditorInput()).getURI().getPath().replaceFirst("/", ""));
                WorkflowDescriptionPersistenceHandler wdHandler = new WorkflowDescriptionPersistenceHandler();
                Throwable throwable = null;
                Object var5_11 = null;
                try (ByteArrayOutputStream outStream = wdHandler.writeWorkflowDescriptionToStream(this.workflowDescription);){
                    if (file.canWrite()) {
                        FileUtils.writeByteArrayToFile((File)file, (byte[])outStream.toByteArray());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.getCommandStack().markSaveLocation();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (OutOfMemoryError error) {
            this.showMemoryExceedingWarningMessage();
            error.printStackTrace();
        }
        this.getCommandStack().markSaveLocation();
        this.validateWorkflow();
    }

    private WorkflowDescription updateExecutionInformation(WorkflowDescription wd, WorkflowDescriptionPersistenceHandler wdHandler, File file) {
        try {
            FileInputStream fileInputStream;
            Throwable throwable = null;
            Object var5_8 = null;
            try {
                fileInputStream = new FileInputStream(file);
                try {
                    String workflowControllerNodeId = wdHandler.readWorkflowControllerNodeId((InputStream)fileInputStream);
                    wd.setControllerNode(NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)workflowControllerNodeId));
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var5_8 = null;
            try {
                fileInputStream = new FileInputStream(file);
                try {
                    Map componentControllerNodeIds = wdHandler.readComponentControllerNodeIds((InputStream)fileInputStream);
                    for (WorkflowNode wn : wd.getWorkflowNodes()) {
                        ComponentInstallationBuilder builder = ComponentInstallationBuilder.fromComponentInstallation((ComponentInstallation)wn.getComponentDescription().getComponentInstallation());
                        if (componentControllerNodeIds.containsKey(wn.getIdentifierAsObject())) {
                            String compNodeId = (String)componentControllerNodeIds.get(wn.getIdentifierAsObject());
                            builder.setNodeId(NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)compNodeId));
                        }
                        wn.getComponentDescription().setComponentInstallation(builder.build());
                    }
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to consider stored execution information on workflow saving", (Throwable)e);
        }
        return wd;
    }

    private void validateWorkflow() {
        ComponentValidationMessageStore.getInstance().emptyMessageStore();
        List list = this.viewer.getRootEditPart().getChildren();
        WorkflowDescriptionValidationUtils.validateWorkflowDescription(this.workflowDescription, false, true);
        for (Object object : list) {
            if (!(object instanceof WorkflowPart)) continue;
            WorkflowPart workflowPart = (WorkflowPart)object;
            List children = workflowPart.getChildren();
            for (Object child : children) {
                WorkflowNodePart workflowNodePart;
                WorkflowNode workflowNode;
                if (!(child instanceof WorkflowNodePart) || (workflowNode = (WorkflowNode)(workflowNodePart = (WorkflowNodePart)child).getModel()).isValid()) continue;
                workflowNodePart.updateValid();
            }
        }
        this.firePropertyChange(1024);
    }

    public void doSaveAs() {
        FileDialog fd = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        fd.setText("Save As...");
        String[] filterExt = new String[]{"*.wf"};
        fd.setFilterExtensions(filterExt);
        fd.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        fd.setFileName(this.getTitle());
        fd.setOverwrite(true);
        String selected = fd.open();
        if (selected == null) {
            return;
        }
        if (!selected.substring(selected.lastIndexOf(46) + 1).toLowerCase().equals("wf")) {
            selected = String.valueOf(selected) + ".wf";
        }
        File file = null;
        try {
            byte[] stream;
            file = new File(selected);
            FileWriter fw = new FileWriter(file);
            WorkflowDescriptionPersistenceHandler wdHandler = new WorkflowDescriptionPersistenceHandler();
            byte[] byArray = stream = wdHandler.writeWorkflowDescriptionToStream(this.workflowDescription).toByteArray();
            int n = stream.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                fw.append((char)element);
                ++n2;
            }
            fw.flush();
            fw.close();
            this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (file.getAbsolutePath().startsWith(workspace.getRoot().getFullPath().toFile().getAbsolutePath())) {
                IFile[] ifile = workspace.getRoot().findFilesForLocationURI(file.toURI());
                if (ifile.length == 1) {
                    EditorsHelper.openFileInEditor((IFile)ifile[0], (Runnable[])new Runnable[0]);
                }
            } else {
                EditorsHelper.openExternalFileInEditor((File)file, (Runnable[])new Runnable[0]);
                LOGGER.warn((Object)"Saved workflow openend as external file (not in workspace location). Executing the workflow might not work.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (OutOfMemoryError error) {
            if (file != null) {
                file.deleteOnExit();
            }
            this.showMemoryExceedingWarningMessage();
            error.printStackTrace();
        }
        catch (PartInitException e) {
            LOGGER.warn((Object)"Could not open new file. ", (Throwable)e);
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LOGGER.warn((Object)"Could not refresh Project Explorer. ", (Throwable)e);
        }
    }

    private void showMemoryExceedingWarningMessage() {
        MessageBox messageBox = new MessageBox(this.viewer.getControl().getShell(), 40);
        messageBox.setMessage(Messages.memoryExceededWarningMessage);
        messageBox.setText(Messages.memoryExceededWarningHeading);
        messageBox.open();
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            if (this.tabbedPropertySheetPage == null || this.tabbedPropertySheetPage.getControl() == null || this.tabbedPropertySheetPage.getControl().isDisposed()) {
                this.tabbedPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return this.tabbedPropertySheetPage;
        }
        if (type == IContextProvider.class) {
            return new WorkflowEditorHelpContextProvider(this.viewer);
        }
        if (type == IContentOutlinePage.class) {
            return new OutlineView(this.getGraphicalViewer());
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(type);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    private void movePart(int movementHorizontal, int movementVertical) {
        List selected = this.getGraphicalViewer().getSelectedEditParts();
        if (selected.isEmpty()) {
            return;
        }
        this.getCommandStack().execute((Command)new MovementCommand(selected, movementHorizontal, movementVertical));
    }

    private void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    private void superSetInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.setPartName(file.getName());
        }
    }

    public void onPaletteDoubleClick(Tool tool) {
        if (!(tool instanceof PaletteCreationTool)) {
            return;
        }
        PaletteCreationTool creationTool = (PaletteCreationTool)tool;
        CreationFactory factory = creationTool.getFactory();
        Object objectType = factory.getObjectType();
        Object newObject = factory.getNewObject();
        WorkflowNodeLabelConnectionCreateCommand createCommand = this.getCreateCommand(newObject, objectType);
        this.getEditorsCommandStack().execute((Command)createCommand);
        for (Object editpart : this.viewer.getContents().getChildren()) {
            EditPart currentEditPart;
            if (!(editpart instanceof EditPart) || !(currentEditPart = (EditPart)editpart).getModel().equals(newObject)) continue;
            this.viewer.select(currentEditPart);
            this.tabbedPropertySheetPage.selectionChanged((IWorkbenchPart)this, this.viewer.getSelection());
            break;
        }
    }

    private WorkflowNodeLabelConnectionCreateCommand getCreateCommand(Object newObject, Object objectType) {
        WorkflowDescription model = (WorkflowDescription)this.viewer.getContents().getModel();
        if (objectType == WorkflowNode.class) {
            Rectangle rectangle = new Rectangle(30, 30, 60, 60);
            for (WorkflowNode node : model.getWorkflowNodes()) {
                Rectangle nodeRect = new Rectangle(node.getX(), node.getY(), 60, 60);
                if (!nodeRect.intersects(rectangle)) continue;
                rectangle.translate(20, 20);
            }
            WorkflowNodeLabelConnectionHelper helper = new WorkflowNodeLabelConnectionHelper((WorkflowNode)newObject, model, rectangle);
            return helper.createCommand();
        }
        if (objectType == WorkflowLabel.class) {
            Rectangle rectangle = new Rectangle(30, 30, -1, -1);
            WorkflowNodeLabelConnectionHelper helper = new WorkflowNodeLabelConnectionHelper((WorkflowLabel)newObject, model, rectangle);
            return helper.createCommand();
        }
        return null;
    }

    public void setHelp(String id) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), id);
    }

    private class MovementCommand
    extends Command {
        private int movementHorizontal = 0;
        private int movementVertical = 0;
        private List<AbstractGraphicalEditPart> selected;

        MovementCommand(List<AbstractGraphicalEditPart> sel, int h, int v) {
            this.movementHorizontal = h;
            this.movementVertical = v;
            this.selected = sel;
        }

        public void undo() {
            super.undo();
            this.setValue(-this.movementHorizontal, -this.movementVertical);
        }

        public void redo() {
            super.redo();
            this.setValue(this.movementHorizontal, this.movementVertical);
        }

        public void execute() {
            super.execute();
            this.setValue(this.movementHorizontal, this.movementVertical);
        }

        private void setValue(int h, int v) {
            for (AbstractGraphicalEditPart s : this.selected) {
                if (s.getModel() instanceof WorkflowLabel) {
                    WorkflowLabel label = (WorkflowLabel)s.getModel();
                    label.setLocation(label.getX() + h, label.getY() + v);
                    continue;
                }
                if (!(s.getModel() instanceof WorkflowNode)) continue;
                WorkflowNode node = (WorkflowNode)s.getModel();
                node.setLocation(node.getX() + h, node.getY() + v);
            }
        }
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException exception) {
                throw new RuntimeException(exception);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !(WorkflowEditor.this.getEditorInput() instanceof IFileEditorInput) || !delta.getResource().equals((Object)((IFileEditorInput)WorkflowEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                Display display = WorkflowEditor.this.getSite().getShell().getDisplay();
                if ((0x2000 & delta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!WorkflowEditor.this.isDirty()) {
                                WorkflowEditor.this.closeEditor(false);
                            }
                        }
                    });
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WorkflowEditor.this.superSetInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }
    }

    private final class WorkflowEditorKeyListener
    implements KeyListener {
        private WorkflowEditorKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.stateMask == 65536 && e.keyCode == 99) {
                WorkflowEditor.this.openConnectionEditor();
            } else if (e.keyCode == 0x1000001) {
                WorkflowEditor.this.movePart(0, -1);
            } else if (e.keyCode == 0x1000002) {
                WorkflowEditor.this.movePart(0, 1);
            } else if (e.keyCode == 0x1000003) {
                WorkflowEditor.this.movePart(-1, 0);
            } else if (e.keyCode == 0x1000004) {
                WorkflowEditor.this.movePart(1, 0);
            }
        }
    }
}

