/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionService;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionSetup;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class SshUplinkConnectionSetupCommandPlugin
implements CommandPlugin {
    private static final String CONNECTION_WITH_ID = "Connection with id ";
    private static final String CMD_SSH_UPLINK = "uplink";
    @Reference
    private SshUplinkConnectionService sshConnectionService;

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(CMD_SSH_UPLINK);
        String subCmd = context.consumeNextToken();
        if (subCmd == null) {
            this.performList(context);
        } else {
            List parameters = context.consumeRemainingTokens();
            if ("add".equals(subCmd)) {
                this.performAdd(context, parameters);
            } else if ("list".equals(subCmd)) {
                this.performList(context);
            } else if ("start".equals(subCmd)) {
                this.performStart(context, parameters);
            } else if ("stop".equals(subCmd)) {
                this.performStop(context, parameters);
            } else {
                throw CommandException.unknownCommand((CommandContext)context);
            }
        }
    }

    private void performAdd(final CommandContext context, List<String> parameters) throws CommandException {
        boolean isGateway;
        if (parameters.size() < 6 || parameters.size() > 7) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        String connectionName = parameters.get(0);
        String host = parameters.get(1);
        int port = Integer.parseInt(parameters.get(2));
        String username = parameters.get(3);
        String keyfileLocation = parameters.get(4);
        String clientId = parameters.get(5);
        final SshConnectionContext contextUplinkSSH = new SshConnectionContext(null, connectionName, clientId, host, port, username, keyfileLocation, false, false, false, isGateway = parameters.size() == 7 ? Boolean.parseBoolean(parameters.get(6)) : false);
        if (this.sshConnectionService.sshUplinkConnectionAlreadyExists(contextUplinkSSH)) {
            context.println((Object)StringUtils.format((String)"Connection setup to host '%s:%d' already exists.", (Object[])new Object[]{contextUplinkSSH.getDestinationHost(), contextUplinkSSH.getPort()}));
            return;
        }
        ConcurrencyUtils.getAsyncTaskService().execute("Create new Uplink Connection.", new Runnable(){

            @Override
            public void run() {
                String id = SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.addSshUplinkConnection(contextUplinkSSH);
                context.println((Object)("Added Uplink connection setup, created id " + id));
            }
        });
    }

    private void performList(CommandContext context) {
        Collection<SshUplinkConnectionSetup> setups = this.sshConnectionService.getAllSshConnectionSetups();
        for (SshUplinkConnectionSetup setup : setups) {
            context.println((Object)StringUtils.format((String)"%s: %s:%s username: %s, keyfile: %s clientId: %s isGateway: %s (id: %s) CONNECTED: %s", (Object[])new Object[]{setup.getDisplayName(), setup.getHost(), setup.getPort(), setup.getUsername(), setup.getKeyfileLocation(), setup.getQualifier(), setup.isGateway(), setup.getId(), setup.isConnected()}));
        }
    }

    private void performStart(final CommandContext context, List<String> parameters) throws CommandException {
        if (parameters.size() < 1) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        final String connectionId = parameters.get(0);
        ConcurrencyUtils.getAsyncTaskService().execute("Start SSH Connection.", new Runnable(){

            @Override
            public void run() {
                if (SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.getConnectionSetup(connectionId) == null) {
                    context.println((Object)(SshUplinkConnectionSetupCommandPlugin.CONNECTION_WITH_ID + connectionId + " does not exist."));
                } else if (SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.getConnectionSetup(connectionId).isConnected()) {
                    context.println((Object)(SshUplinkConnectionSetupCommandPlugin.CONNECTION_WITH_ID + connectionId + "is already connected."));
                } else {
                    SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.connectSession(connectionId);
                }
            }
        });
    }

    private void performStop(final CommandContext context, List<String> parameters) throws CommandException {
        if (parameters.size() < 1) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        final String connectionId = parameters.get(0);
        ConcurrencyUtils.getAsyncTaskService().execute("Start SSH Connection.", new Runnable(){

            @Override
            public void run() {
                if (SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.getConnectionSetup(connectionId) != null) {
                    SshUplinkConnectionSetupCommandPlugin.this.sshConnectionService.disconnectSession(connectionId);
                } else {
                    context.println((Object)(SshUplinkConnectionSetupCommandPlugin.CONNECTION_WITH_ID + connectionId + " does not exist."));
                }
            }
        });
    }

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(CMD_SSH_UPLINK, "", false, "short form of \"uplink list\"", new String[0]));
        contributions.add(new CommandDescription("uplink add", "<displayName> <host> <port> <username> <keyfileLocation> <clientId>  <isGateway>", false, "add a new uplink connection", new String[0]));
        contributions.add(new CommandDescription("uplink list", "", false, "lists all uplink connections, including ids and connection states", new String[0]));
        contributions.add(new CommandDescription("uplink start", "<id>", false, "starts/connects an uplink connection (use \" uplink list\" to get the id)", new String[0]));
        contributions.add(new CommandDescription("uplink stop", "<id>", false, "stops/disconnects an uplink connection (use \" uplink list\" to get the id)", new String[0]));
        return contributions;
    }
}

