/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jzlib;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.jzlib.Deflater;
import com.jcraft.jsch.jzlib.Inflater;

public class Compression
implements com.jcraft.jsch.Compression {
    private static final int BUF_SIZE = 4096;
    private final int buffer_margin = 52;
    private Deflater deflater;
    private Inflater inflater;
    private byte[] tmpbuf = new byte[4096];
    private byte[] inflated_buf;

    @Override
    public void init(int type, int level) throws Exception {
        if (type == 1) {
            this.deflater = new Deflater(level);
        } else if (type == 0) {
            this.inflater = new Inflater();
            this.inflated_buf = new byte[4096];
        }
        if (JSch.getLogger().isEnabled(0)) {
            JSch.getLogger().log(0, "zlib using " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public byte[] compress(byte[] buf, int start, int[] len) {
        this.deflater.next_in = buf;
        this.deflater.next_in_index = start;
        this.deflater.avail_in = len[0] - start;
        int outputlen = start;
        byte[] outputbuf = buf;
        int tmp = 0;
        block3: do {
            this.deflater.next_out = this.tmpbuf;
            this.deflater.next_out_index = 0;
            this.deflater.avail_out = 4096;
            int status = this.deflater.deflate(1);
            switch (status) {
                case 0: {
                    tmp = 4096 - this.deflater.avail_out;
                    if (outputbuf.length < outputlen + tmp + 52) {
                        byte[] foo = new byte[(outputlen + tmp + 52) * 2];
                        System.arraycopy(outputbuf, 0, foo, 0, outputbuf.length);
                        outputbuf = foo;
                    }
                    System.arraycopy(this.tmpbuf, 0, outputbuf, outputlen, tmp);
                    outputlen += tmp;
                    break;
                }
                default: {
                    if (!JSch.getLogger().isEnabled(2)) continue block3;
                    JSch.getLogger().log(2, "compress: deflate returnd " + status);
                }
            }
        } while (this.deflater.avail_out == 0);
        len[0] = outputlen;
        return outputbuf;
    }

    @Override
    public byte[] uncompress(byte[] buffer, int start, int[] length) {
        int status;
        int inflated_end = 0;
        this.inflater.next_in = buffer;
        this.inflater.next_in_index = start;
        this.inflater.avail_in = length[0];
        block4: while (true) {
            this.inflater.next_out = this.tmpbuf;
            this.inflater.next_out_index = 0;
            this.inflater.avail_out = 4096;
            status = this.inflater.inflate(1);
            switch (status) {
                case 0: {
                    if (this.inflated_buf.length < inflated_end + 4096 - this.inflater.avail_out) {
                        int len = this.inflated_buf.length * 2;
                        if (len < inflated_end + 4096 - this.inflater.avail_out) {
                            len = inflated_end + 4096 - this.inflater.avail_out;
                        }
                        byte[] foo = new byte[len];
                        System.arraycopy(this.inflated_buf, 0, foo, 0, inflated_end);
                        this.inflated_buf = foo;
                    }
                    System.arraycopy(this.tmpbuf, 0, this.inflated_buf, inflated_end, 4096 - this.inflater.avail_out);
                    length[0] = inflated_end += 4096 - this.inflater.avail_out;
                    continue block4;
                }
                case -5: {
                    if (inflated_end > buffer.length - start) {
                        byte[] foo = new byte[inflated_end + start];
                        System.arraycopy(buffer, 0, foo, 0, start);
                        System.arraycopy(this.inflated_buf, 0, foo, start, inflated_end);
                        buffer = foo;
                    } else {
                        System.arraycopy(this.inflated_buf, 0, buffer, start, inflated_end);
                    }
                    length[0] = inflated_end;
                    return buffer;
                }
            }
            break;
        }
        if (JSch.getLogger().isEnabled(2)) {
            JSch.getLogger().log(2, "uncompress: inflate returnd " + status);
        }
        return null;
    }
}

